/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.proxy;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.dap.proxy.Array;
import org.eclipse.vjet.dsf.dap.proxy.NaN;
import org.eclipse.vjet.dsf.dap.proxy.ScriptEngineCtx;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugger;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.IJsJavaProxy;
import org.mozilla.mod.javascript.IWillBeScriptable;
import org.mozilla.mod.javascript.NativeArray;
import org.mozilla.mod.javascript.NativeJavaObject;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.mozilla.mod.javascript.Undefined;

public class NativeJsHelper {
    private static Class<?>[] PARAM_TYPES = new Class[]{Scriptable.class};
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final String VJO_getClass = "getClass";
    private static final String VJO_CLASS_getName = "getName";
    private static final Map<Class<?>, Class<?>> s_primiNumTypes = new HashMap();

    static {
        s_primiNumTypes.put(Integer.TYPE, Integer.class);
        s_primiNumTypes.put(Long.TYPE, Long.class);
        s_primiNumTypes.put(Double.TYPE, Double.class);
        s_primiNumTypes.put(Float.TYPE, Float.class);
        s_primiNumTypes.put(Short.TYPE, Short.class);
        s_primiNumTypes.put(Byte.TYPE, Byte.class);
    }

    public static Scriptable getNativeClzType(String clzType) {
        Context ctx = NativeJsHelper.getContext();
        Scriptable scope = NativeJsHelper.getScope();
        if (clzType.indexOf("$") > 0) {
            clzType = clzType.replace("$", ".");
        }
        return (Scriptable)ctx.evaluateString(scope, clzType, clzType, 0, null);
    }

    public static NativeArray createNativeArray(int size) {
        Context ctx = NativeJsHelper.getContext();
        Scriptable scope = NativeJsHelper.getScope();
        String js = "new Array(" + size + ")";
        return (NativeArray)ctx.evaluateString(scope, js, js, 0, null);
    }

    public static <T> T invokeNativeFunc(String funcName, Class<? extends T> type, Object ... args) {
        Context ctx = NativeJsHelper.getContext();
        Scriptable scope = NativeJsHelper.getScope();
        Function func = (Function)ctx.evaluateString(scope, funcName, funcName, 0, null);
        Object value = func.call(ctx, scope, null, NativeJsHelper.toNatives(args));
        return NativeJsHelper.convert(type, value);
    }

    public static Object eval(String js) {
        Context ctx = NativeJsHelper.getContext();
        Scriptable scope = NativeJsHelper.getScope();
        return ctx.evaluateString(scope, js, js, 0, null);
    }

    public static <T> T convert(Class<? extends T> type, Object value) {
        Class<?> wrapperType;
        if (value == null || value instanceof Undefined) {
            return null;
        }
        if (value.getClass().equals(s_primiNumTypes.get(type))) {
            return (T)value;
        }
        if (IWillBeScriptable.class.isAssignableFrom(type) && value instanceof IWillBeScriptable) {
            return type.cast(value);
        }
        if (value instanceof NativeJavaObject) {
            value = ((NativeJavaObject)value).unwrap();
        }
        if (IJsJavaProxy.class.isAssignableFrom(type) && value instanceof Scriptable) {
            return NativeJsHelper.getProxy(type, (Scriptable)value);
        }
        if (value instanceof NativeArray && (type == Array.class || type == Object.class)) {
            return (T)new Array((Scriptable)((NativeArray)value));
        }
        if (value instanceof ScriptableObject) {
            ScriptableObject s = (ScriptableObject)value;
            String typeName = s.getClassName();
            if ("Number".equals(typeName)) {
                value = Double.valueOf(s.toString());
            } else {
                T o = NativeJsHelper.getProxy(type, (Scriptable)value);
                if (o != null) {
                    return o;
                }
                try {
                    value = Context.jsToJava((Object)value, type);
                }
                catch (Exception exception) {
                    throw new RuntimeException("can't covert value [" + value + "] to type of " + type.getName());
                }
            }
        }
        if (value instanceof Double) {
            if (type == Integer.class || type == Integer.TYPE) {
                value = Double.isNaN((Double)value) ? NaN.intValue() : new Integer(((Double)value).intValue());
            } else if (type == Long.class || type == Long.TYPE) {
                value = new Long(((Double)value).longValue());
            } else if (type == Short.class || type == Short.TYPE) {
                value = new Short(((Double)value).shortValue());
            } else if (type == Byte.class || type == Byte.TYPE) {
                value = new Byte(((Double)value).byteValue());
            } else if (type == Float.class || type == Float.TYPE) {
                value = Double.isNaN((Double)value) ? NaN.floatValue() : new Float(((Double)value).floatValue());
            }
            wrapperType = s_primiNumTypes.get(type);
            if (wrapperType != null) {
                return (T)value;
            }
        }
        if (type == Boolean.TYPE && value instanceof Boolean) {
            return (T)value;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        if (value instanceof String) {
            if (type == Integer.class || type == Integer.TYPE) {
                value = new Integer((String)value);
            } else if (type == Long.class || type == Long.TYPE) {
                value = new Long((String)value);
            } else if (type == Short.class || type == Short.TYPE) {
                value = new Short((String)value);
            } else if (type == Byte.class || type == Byte.TYPE) {
                value = new Byte((String)value);
            } else if (type == Float.class || type == Float.TYPE) {
                value = new Float((String)value);
            } else if (type == Double.class || type == Double.TYPE) {
                value = new Double((String)value);
            }
            wrapperType = s_primiNumTypes.get(type);
            if (wrapperType != null) {
                return (T)value;
            }
        }
        throw new RuntimeException("can't covert value [" + value + "] to type of " + type.getName());
    }

    public static String toString(Object value) {
        if (value instanceof NativeJavaObject) {
            value = ((NativeJavaObject)value).unwrap();
        } else if (value instanceof NativeArray) {
            value = new Array((Scriptable)((NativeArray)value));
        } else if (value instanceof IJsJavaProxy) {
            value = ((IJsJavaProxy)value).getJsNative();
        }
        return value.toString();
    }

    public static Object[] toNatives(Object[] args) {
        Object[] nativeArgs = new Object[args.length];
        int i = 0;
        while (i < args.length) {
            nativeArgs[i] = NativeJsHelper.toNative(args[i]);
            ++i;
        }
        return nativeArgs;
    }

    public static Object toNative(Object arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof Undefined) {
            return arg;
        }
        if (arg instanceof IJsJavaProxy) {
            return ((IJsJavaProxy)arg).getJsNative();
        }
        if (arg instanceof String) {
            return arg;
        }
        if (arg instanceof Boolean) {
            return arg;
        }
        return Context.toObject((Object)arg, (Scriptable)NativeJsHelper.getScope());
    }

    public static <T> T getStaticProperty(Class<?> type, String name, Class<T> rtnType) {
        Object result = ScriptableObject.getProperty((Scriptable)NativeJsHelper.getNativeClzType(type.getName()), (String)name);
        return NativeJsHelper.convert(rtnType, result);
    }

    public static Scriptable getScope() {
        Scriptable scope = ScriptEngineCtx.ctx().getScope();
        if (scope == null && Thread.currentThread() instanceof DBGPDebugger) {
            DBGPDebugger debugger = (DBGPDebugger)Thread.currentThread();
            scope = debugger.getCurrentScope();
            ScriptEngineCtx.ctx().setScope(scope);
        }
        return scope;
    }

    public static Context getContext() {
        Context scriptContext = ScriptEngineCtx.ctx().getScriptContext();
        if (scriptContext == null && Thread.currentThread() instanceof DBGPDebugger) {
            DBGPDebugger debugger = (DBGPDebugger)Thread.currentThread();
            scriptContext = debugger.getContext();
            ScriptEngineCtx.ctx().setScriptContext(scriptContext);
        }
        return scriptContext;
    }

    public static String getVjoTypeName(Scriptable s) {
        Scriptable vjoClz;
        Object rtn = ScriptableObject.getProperty((Scriptable)s, (String)VJO_getClass);
        if (!(rtn instanceof Function)) {
            return null;
        }
        Function getClassFunc = (Function)ScriptableObject.getProperty((Scriptable)s, (String)VJO_getClass);
        if (getClassFunc != null && (vjoClz = (Scriptable)getClassFunc.call(NativeJsHelper.getContext(), NativeJsHelper.getScope(), s, EMPTY_ARGS)) != null) {
            Function getNameFunc = (Function)ScriptableObject.getProperty((Scriptable)vjoClz, (String)VJO_CLASS_getName);
            return (String)getNameFunc.call(NativeJsHelper.getContext(), NativeJsHelper.getScope(), vjoClz, EMPTY_ARGS);
        }
        return null;
    }

    private static <T> T getProxy(Class<? extends T> type, Scriptable s) {
        Object proxy = s.get("_js_java_proxy", s);
        if (type.isInstance(proxy)) {
            return type.cast(proxy);
        }
        String typeName = NativeJsHelper.getVjoTypeName(s);
        if (typeName != null) {
            try {
                type = NativeJsHelper.getContext().getApplicationClassLoader().loadClass(typeName);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (!IJsJavaProxy.class.isAssignableFrom(type)) {
            return null;
        }
        try {
            Constructor<Object> constructor = type.getDeclaredConstructor(PARAM_TYPES);
            constructor.setAccessible(true);
            return (T)constructor.newInstance(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

