/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.event.listener;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.event.DapEvent;
import org.eclipse.vjet.dsf.dap.event.listener.IBlurListener;
import org.eclipse.vjet.dsf.dap.event.listener.IChangeListener;
import org.eclipse.vjet.dsf.dap.event.listener.IClickListener;
import org.eclipse.vjet.dsf.dap.event.listener.IDapEventListener;
import org.eclipse.vjet.dsf.dap.event.listener.IDblClickListener;
import org.eclipse.vjet.dsf.dap.event.listener.IFocusListener;
import org.eclipse.vjet.dsf.dap.event.listener.IKeyDownListener;
import org.eclipse.vjet.dsf.dap.event.listener.IKeyListener;
import org.eclipse.vjet.dsf.dap.event.listener.IKeyPressListener;
import org.eclipse.vjet.dsf.dap.event.listener.IKeyUpListener;
import org.eclipse.vjet.dsf.dap.event.listener.ILoadListener;
import org.eclipse.vjet.dsf.dap.event.listener.IMouseDownListener;
import org.eclipse.vjet.dsf.dap.event.listener.IMouseListener;
import org.eclipse.vjet.dsf.dap.event.listener.IMouseMoveListener;
import org.eclipse.vjet.dsf.dap.event.listener.IMouseOutListener;
import org.eclipse.vjet.dsf.dap.event.listener.IMouseOverListener;
import org.eclipse.vjet.dsf.dap.event.listener.IMouseUpListener;
import org.eclipse.vjet.dsf.dap.event.listener.IResetListener;
import org.eclipse.vjet.dsf.dap.event.listener.IResizeListener;
import org.eclipse.vjet.dsf.dap.event.listener.IScrollListener;
import org.eclipse.vjet.dsf.dap.event.listener.ISelectListener;
import org.eclipse.vjet.dsf.dap.event.listener.ISubmitListener;
import org.eclipse.vjet.dsf.dap.event.listener.IUnloadListener;
import org.eclipse.vjet.dsf.html.events.EventType;

public final class DapEventListenerHelper {
    private static Map<Class<? extends IDapEventListener>, List<EventType>> s_evtTypeMap = new LinkedHashMap<Class<? extends IDapEventListener>, List<EventType>>(10);
    private static Map<Class<? extends IDapEventListener>, List<Class<? extends DapEvent>>> s_evtClsMap = new LinkedHashMap<Class<? extends IDapEventListener>, List<Class<? extends DapEvent>>>(10);
    private static List<Class<? extends DapEvent>> m_allEvtClsList = new ArrayList<Class<? extends DapEvent>>();

    static {
        DapEventListenerHelper.add(IBlurListener.class);
        DapEventListenerHelper.add(IChangeListener.class);
        DapEventListenerHelper.add(IClickListener.class);
        DapEventListenerHelper.add(IDblClickListener.class);
        DapEventListenerHelper.add(IFocusListener.class);
        DapEventListenerHelper.add(IKeyListener.class);
        DapEventListenerHelper.add(IKeyUpListener.class);
        DapEventListenerHelper.add(IKeyDownListener.class);
        DapEventListenerHelper.add(IKeyPressListener.class);
        DapEventListenerHelper.add(ILoadListener.class);
        DapEventListenerHelper.add(IMouseListener.class);
        DapEventListenerHelper.add(IMouseUpListener.class);
        DapEventListenerHelper.add(IMouseDownListener.class);
        DapEventListenerHelper.add(IMouseMoveListener.class);
        DapEventListenerHelper.add(IMouseOutListener.class);
        DapEventListenerHelper.add(IMouseOverListener.class);
        DapEventListenerHelper.add(IResetListener.class);
        DapEventListenerHelper.add(IResizeListener.class);
        DapEventListenerHelper.add(IScrollListener.class);
        DapEventListenerHelper.add(ISelectListener.class);
        DapEventListenerHelper.add(ISubmitListener.class);
        DapEventListenerHelper.add(IUnloadListener.class);
    }

    public static Collection<Class<? extends IDapEventListener>> getAllEventListeners() {
        return s_evtTypeMap.keySet();
    }

    public static List<EventType> getSupportedEventTypes(Class<? extends IDapEventListener> listenerType) {
        return s_evtTypeMap.get(listenerType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class<? extends DapEvent>> getSupportedEvents() {
        if (!m_allEvtClsList.isEmpty()) {
            return m_allEvtClsList;
        }
        Class<DapEventListenerHelper> clazz = DapEventListenerHelper.class;
        synchronized (DapEventListenerHelper.class) {
            for (List<Class<? extends DapEvent>> events : s_evtClsMap.values()) {
                for (Class<? extends DapEvent> cls : events) {
                    if (m_allEvtClsList.contains(cls)) continue;
                    m_allEvtClsList.add(cls);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_allEvtClsList;
        }
    }

    private static void add(Class<? extends IDapEventListener> listenerType) {
        DapEventListenerHelper.addEvents(listenerType);
        DapEventListenerHelper.addEventTypes(listenerType);
    }

    private static void addEvents(Class<? extends IDapEventListener> listenerType) {
        Method[] mtds;
        List<Class<? extends DapEvent>> list = s_evtClsMap.get(listenerType);
        if (list == null) {
            list = new ArrayList<Class<? extends DapEvent>>();
            s_evtClsMap.put(listenerType, list);
        }
        Method[] methodArray = mtds = listenerType.getDeclaredMethods();
        int n = mtds.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> evtCls;
            Method mtd = methodArray[n2];
            Class<?>[] paramTypes = mtd.getParameterTypes();
            if (paramTypes.length != 0 && DapEvent.class.isAssignableFrom(evtCls = paramTypes[0])) {
                list.add(evtCls.asSubclass(DapEvent.class));
            }
            ++n2;
        }
    }

    private static void addEventTypes(Class<? extends IDapEventListener> listenerType) {
        Method[] mtds;
        List<EventType> list = s_evtTypeMap.get(listenerType);
        if (list == null) {
            list = new ArrayList<EventType>();
            s_evtTypeMap.put(listenerType, list);
        }
        Method[] methodArray = mtds = listenerType.getDeclaredMethods();
        int n = mtds.length;
        int n2 = 0;
        while (n2 < n) {
            Method mtd = methodArray[n2];
            String mtdName = mtd.getName();
            EventType evtType = EventType.get((String)mtdName.substring(2).toLowerCase());
            if (evtType == null) {
                evtType = EventType.get((String)mtdName.toLowerCase());
            }
            if (evtType == null) {
                throw new DsfRuntimeException("evtType nor found for: " + listenerType.getSimpleName() + "," + mtd.getName());
            }
            list.add(evtType);
            ++n2;
        }
    }
}

