/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.cnr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.dap.rt.DapHttpRequest;
import org.eclipse.vjet.dsf.dap.rt.DapHttpResponse;
import org.eclipse.vjet.dsf.liveconnect.client.DLCEvent;

public class DapCaptureData
implements Serializable {
    public static final String VERSION_1_0_0 = "1.0.0";
    private static final long serialVersionUID = 1L;
    private static final List<IEventCapture> EMPTY_LIST = Collections.emptyList();
    private transient int m_httpCounter = 0;
    private transient Map<DapHttpRequest, Integer> m_httpCallIds = new LinkedHashMap<DapHttpRequest, Integer>();
    private String m_version;
    private String m_userAgent;
    private Map<Integer, DapHttpCall> m_httpCalls = new LinkedHashMap<Integer, DapHttpCall>();
    private List<ViewCapture> m_viewCaptures = new ArrayList<ViewCapture>();
    private EventCapture m_initEventCapture;

    public String getVersion() {
        return this.m_version;
    }

    public DapCaptureData setVersion(String version) {
        this.m_version = version;
        return this;
    }

    public String getUserAgent() {
        return this.m_userAgent;
    }

    public DapCaptureData setUserAgent(String userAgent) {
        this.m_userAgent = userAgent;
        return this;
    }

    public void addViewCapture(ViewCapture viewCapture) {
        this.m_viewCaptures.add(viewCapture);
    }

    public List<ViewCapture> getViewCaptures() {
        return Collections.unmodifiableList(this.m_viewCaptures);
    }

    public ViewCapture getCurrentViewCapture() {
        if (this.m_viewCaptures.isEmpty()) {
            return null;
        }
        return this.m_viewCaptures.get(this.m_viewCaptures.size() - 1);
    }

    public Map<Integer, DapHttpCall> getHttpCallCaptures() {
        return Collections.unmodifiableMap(this.m_httpCalls);
    }

    public List<IEventCapture> getAllEventCaptures() {
        ArrayList<IEventCapture> captures = new ArrayList<IEventCapture>();
        if (this.m_initEventCapture != null) {
            captures.add(this.m_initEventCapture);
        }
        for (ViewCapture vc : this.m_viewCaptures) {
            captures.addAll(vc.getAllEventCaptures());
        }
        return captures;
    }

    public IEventCapture getCurrentEventCapture() {
        ViewCapture curViewCapture = this.getCurrentViewCapture();
        if (curViewCapture == null) {
            return null;
        }
        List<IEventCapture> list = curViewCapture.getAllEventCaptures();
        if (!list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    public void setInitEventCapture(EventCapture initEventCapture) {
        this.m_initEventCapture = initEventCapture;
    }

    public EventCapture getInitEventCapture() {
        return this.m_initEventCapture;
    }

    public static abstract class AbstractEventCapture
    implements IEventCapture {
        @Override
        public Iterator<IActionInfo> getActionsIter() {
            return this.getActions().iterator();
        }

        public int getActionsSize() {
            return this.getActions().size();
        }

        @Override
        public void addDlcSend(String message) {
            if (message != null) {
                this.getActions().add(new DlcSend(message));
            }
        }

        @Override
        public void addDlcRequest(String message) {
            if (message != null) {
                this.getActions().add(new DlcRnR(message));
            }
        }

        @Override
        public void addDlcResponse(String message) {
            List<IActionInfo> actions = this.getActions();
            if (actions.isEmpty()) {
                return;
            }
            IActionInfo info = actions.get(actions.size() - 1);
            if (!(info instanceof DlcRnR)) {
                throw new DsfRuntimeException("there is no matching request for the response : " + message);
            }
            ((DlcRnR)info).m_response = message;
        }
    }

    public static class DapHttpCall {
        private static final long serialVersionUID = 1L;
        private int m_id;
        private DapHttpRequest m_req;
        private DapHttpResponse m_resp;
        private long m_respTime;

        public DapHttpCall(int id, DapHttpRequest req) {
            this.m_id = id;
            this.m_req = req;
            this.m_respTime = System.currentTimeMillis();
        }

        public void setResponse(DapHttpResponse resp) {
            this.m_resp = resp;
            this.m_respTime = System.currentTimeMillis() - this.m_respTime;
        }

        public int getId() {
            return this.m_id;
        }

        public DapHttpRequest getRequest() {
            return this.m_req;
        }

        public DapHttpResponse getResponse() {
            return this.m_resp;
        }

        public long getResponseTime() {
            return this.m_respTime;
        }
    }

    public static class DlcRnR
    implements IDlcMsg {
        private static final long serialVersionUID = 1L;
        private String m_request;
        private String m_response;

        DlcRnR(String request) {
            this.m_request = request;
        }

        public String getRequest() {
            return this.m_request;
        }

        public String getResponse() {
            return this.m_response;
        }

        public String toString() {
            return "[" + this.m_request + "]-[" + this.m_response + "]";
        }
    }

    public static class DlcSend
    implements IDlcMsg {
        private static final long serialVersionUID = 1L;
        private String m_message;

        DlcSend(String message) {
            this.m_message = message;
        }

        public String getMessage() {
            return this.m_message;
        }

        public String toString() {
            return this.m_message;
        }
    }

    public class EventCapture
    extends AbstractEventCapture
    implements Serializable,
    IEventCapture {
        private static final long serialVersionUID = 1L;
        private final long m_eventTimeInterval;
        private final DLCEvent m_event;
        private List<IActionInfo> m_actions = new ArrayList<IActionInfo>();

        EventCapture() {
            this.m_event = null;
            this.m_eventTimeInterval = 0L;
        }

        EventCapture(DLCEvent event, long eventTimeInterval) {
            this.m_event = event;
            this.m_eventTimeInterval = eventTimeInterval;
        }

        public DLCEvent getEvent() {
            return this.m_event;
        }

        public long getEventTimeInterval() {
            return this.m_eventTimeInterval;
        }

        @Override
        public List<IActionInfo> getActions() {
            return this.m_actions;
        }

        @Override
        public int getDomChangeSize() {
            int size = 0;
            for (IActionInfo action : this.m_actions) {
                if (!(action instanceof IDomChange)) continue;
                ++size;
            }
            return size;
        }

        @Override
        public void addDomChange(IDomChange data) {
            if (data != null) {
                this.m_actions.add(data);
            }
        }

        @Override
        public void addHttpReq(DapHttpRequest req) {
            DapCaptureData dapCaptureData = DapCaptureData.this;
            int n = dapCaptureData.m_httpCounter + 1;
            dapCaptureData.m_httpCounter = n;
            int count = n;
            Integer id = new Integer(count);
            DapHttpCall httpCall = new DapHttpCall(id, req);
            DapCaptureData.this.m_httpCallIds.put(req, count);
            DapCaptureData.this.m_httpCalls.put(count, httpCall);
            this.m_actions.add(new HttpReq(httpCall.getId()));
        }

        @Override
        public void addHttpResp(DapHttpRequest req, DapHttpResponse resp) {
            Integer id = (Integer)DapCaptureData.this.m_httpCallIds.get(req);
            DapHttpCall httpCall = (DapHttpCall)DapCaptureData.this.m_httpCalls.get(id);
            if (httpCall != null) {
                httpCall.setResponse(resp);
                this.m_actions.add(new HttpResp(httpCall.getId()));
            }
        }

        @Override
        public String getInfo() {
            return "event-" + this.m_event;
        }
    }

    public static class HttpReq
    implements IHttpMsg {
        private static final long serialVersionUID = 1L;
        private int m_id;

        public HttpReq(int id) {
            this.m_id = id;
        }

        public int getId() {
            return this.m_id;
        }

        public String toString() {
            return "HttpReq " + String.valueOf(this.m_id);
        }
    }

    public static class HttpResp
    implements IHttpMsg {
        private static final long serialVersionUID = 1L;
        private int m_id;

        public HttpResp(int id) {
            this.m_id = id;
        }

        public int getId() {
            return this.m_id;
        }

        public String toString() {
            return "HttpResp " + String.valueOf(this.m_id);
        }
    }

    public static interface IActionInfo
    extends Serializable {
    }

    public static interface IDlcMsg
    extends IActionInfo {
    }

    public static interface IDomChange
    extends IActionInfo {
    }

    public static interface IEventCapture {
        public List<IActionInfo> getActions();

        public Iterator<IActionInfo> getActionsIter();

        public String getInfo();

        public void addDomChange(IDomChange var1);

        public int getDomChangeSize();

        public void addDlcSend(String var1);

        public void addDlcRequest(String var1);

        public void addDlcResponse(String var1);

        public void addHttpReq(DapHttpRequest var1);

        public void addHttpResp(DapHttpRequest var1, DapHttpResponse var2);
    }

    public static interface IHttpMsg
    extends IActionInfo {
    }

    public class TaskCapture
    extends AbstractEventCapture
    implements Serializable,
    IEventCapture {
        private static final long serialVersionUID = 1L;
        private String m_msg;
        private List<IActionInfo> m_actions = new ArrayList<IActionInfo>();

        public TaskCapture(String msg) {
            this.m_msg = msg;
        }

        @Override
        public List<IActionInfo> getActions() {
            return this.m_actions;
        }

        @Override
        public int getDomChangeSize() {
            int size = 0;
            for (IActionInfo action : this.m_actions) {
                if (!(action instanceof IDomChange)) continue;
                ++size;
            }
            return size;
        }

        @Override
        public void addDomChange(IDomChange data) {
            if (data != null) {
                this.m_actions.add(data);
            }
        }

        @Override
        public void addHttpReq(DapHttpRequest req) {
            DapCaptureData dapCaptureData = DapCaptureData.this;
            int n = dapCaptureData.m_httpCounter + 1;
            dapCaptureData.m_httpCounter = n;
            int count = n;
            Integer id = new Integer(count);
            DapHttpCall httpCall = new DapHttpCall(id, req);
            DapCaptureData.this.m_httpCallIds.put(req, count);
            DapCaptureData.this.m_httpCalls.put(count, httpCall);
            this.m_actions.add(new HttpReq(httpCall.getId()));
        }

        @Override
        public void addHttpResp(DapHttpRequest req, DapHttpResponse resp) {
            Integer id = (Integer)DapCaptureData.this.m_httpCallIds.get(req);
            DapHttpCall httpCall = (DapHttpCall)DapCaptureData.this.m_httpCalls.get(id);
            if (httpCall != null) {
                httpCall.setResponse(resp);
                this.m_actions.add(new HttpResp(httpCall.getId()));
            }
        }

        @Override
        public String getInfo() {
            return this.m_msg;
        }
    }

    public class ViewCapture
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String m_url;
        private Map<String, List<IEventCapture>> m_IEventCaptures = new LinkedHashMap<String, List<IEventCapture>>();

        public ViewCapture(String url) {
            this.m_url = url;
        }

        public String getUrl() {
            return this.m_url;
        }

        public void addEventCapture(String captureName, IEventCapture IEventCapture2) {
            List<IEventCapture> list = this.m_IEventCaptures.get(captureName);
            if (list == null) {
                list = new ArrayList<IEventCapture>();
                this.m_IEventCaptures.put(captureName, list);
            }
            list.add(IEventCapture2);
        }

        public Map<String, List<IEventCapture>> getEventCaptures() {
            return Collections.unmodifiableMap(this.m_IEventCaptures);
        }

        public List<IEventCapture> getEventCapture(String captureName) {
            return this.m_IEventCaptures.get(captureName);
        }

        public List<IEventCapture> getAllEventCaptures() {
            if (this.getEventCaptures().isEmpty()) {
                return EMPTY_LIST;
            }
            ArrayList<IEventCapture> captures = new ArrayList<IEventCapture>();
            for (List<IEventCapture> list : this.getEventCaptures().values()) {
                captures.addAll(list);
            }
            return captures;
        }
    }
}

