/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.prebuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.eclipse.vjet.dsf.javatojs.control.BuildController;
import org.eclipse.vjet.dsf.javatojs.control.DefaultTranslationInitializer;
import org.eclipse.vjet.dsf.javatojs.control.ITranslationInitializer;
import org.eclipse.vjet.dsf.javatojs.prebuild.BaseBuildTask;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.translate.config.CodeGenConfig;
import org.eclipse.vjet.dsf.logger.LogLevel;

public class J2JsBuildTask
extends BaseBuildTask {
    private String m_projectDir;
    private String m_sourceDirs;
    private String m_exclusion;
    private String m_j2jPkgName;
    private boolean m_genJsr = false;
    private boolean m_enableParallel = false;
    private boolean m_enableTrace = false;
    private boolean m_enableDebug = false;
    private boolean m_useOnDemand = false;
    private String m_sourceSearchPath;
    private BuildController m_controller;

    public void execute() throws BuildException {
        if (this.m_sourceDirs == null) {
            throw new BuildException("Java2JsPreBuild - source dirctory not set");
        }
        if (this.m_projectDir == null) {
            throw new BuildException("Java2JsPreBuild - project not set");
        }
        System.out.println("executing Java2JsPreBuild....");
        System.out.println("projectDir=" + this.m_projectDir);
        System.out.println("sourceDirs=" + this.m_sourceDirs);
        System.out.println("exclusion=" + this.m_exclusion);
        if (this.m_sourceSearchPath != null && !"".equals(this.m_sourceSearchPath)) {
            System.out.println("sourceSearchPath=" + this.m_sourceSearchPath);
            System.setProperty("java.source.path", this.m_sourceSearchPath);
        } else {
            System.out.println("sourceSearchPath=null!!!");
        }
        try {
            File[] dirs;
            long startTime = System.currentTimeMillis();
            this.initCodeGenConfig();
            File[] fileArray = dirs = J2JsBuildTask.parseSourceDirs((String)this.getSourceDirs(), (String)this.getProjectDir());
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File srcDir = fileArray[n2];
                if (srcDir != null) {
                    ArrayList<URL> files = new ArrayList<URL>();
                    this.getBuildFiles(srcDir, files, this.m_j2jPkgName, null, this.m_enableDebug);
                    if (files.size() > 0) {
                        BuildController controller = this.getBuildController();
                        controller.buildFiles(files);
                        if (this.m_enableDebug) {
                            this.dump(controller.getTranslatedJstTypes());
                        }
                        List<TranslateError> errors = controller.getAllErrors();
                        this.printErrors(errors);
                    }
                }
                ++n2;
            }
            long totalTime = (System.currentTimeMillis() - startTime) / 1000L;
            System.out.println("Java2JsPreBuild completed in " + totalTime + " sec");
        }
        catch (Throwable e) {
            System.out.println("Java2JsPreBuild: exception - " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void initCodeGenConfig() {
        if (!this.shouldOverrideConfig()) {
            return;
        }
        CodeGenConfig config = new CodeGenConfig(this.getCodeGenProps());
        this.m_j2jPkgName = config.getGenPkgNames();
        this.m_genJsr = config.shouldGenJsr();
        this.m_enableParallel = config.isParallelEnabled();
        this.m_enableTrace = config.isTraceEnabled();
        this.m_enableDebug = config.isVerbose();
        this.m_useOnDemand = config.getMode() == CodeGenConfig.TranslationMode.ONDEMAND;
    }

    private boolean shouldOverrideConfig() {
        File file;
        String globalGenPropPath = System.getProperty("java2js.codegen.prop.file");
        if (globalGenPropPath != null && globalGenPropPath.length() != 0 && (file = new File(globalGenPropPath)).exists()) {
            return true;
        }
        String codeGenPropPath = String.valueOf(this.getProjectDir()) + File.separatorChar + "java2js.properties";
        File file2 = new File(codeGenPropPath);
        return file2.exists();
    }

    private Properties getCodeGenProps() {
        Properties prop = null;
        String globalGenPropPath = System.getProperty("java2js.codegen.prop.file");
        Properties globalProp = this.loadPropFile(globalGenPropPath, new Properties());
        if (globalProp != null && !globalProp.isEmpty()) {
            prop = new Properties(globalProp);
        }
        String codeGenPropPath = String.valueOf(this.getProjectDir()) + File.separatorChar + "java2js.properties";
        prop = this.loadPropFile(codeGenPropPath, prop == null ? new Properties() : prop);
        return prop;
    }

    private Properties loadPropFile(String propFilePath, Properties prop) {
        block16: {
            FileInputStream fis = null;
            if (propFilePath == null || propFilePath.length() == 0) {
                return prop;
            }
            File file = new File(propFilePath);
            if (!file.exists()) {
                return prop;
            }
            try {
                fis = new FileInputStream(file);
                prop.load(fis);
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
                break block16;
            }
            catch (Exception exception) {
                try {
                    System.err.println("Error loading properties from " + file);
                }
                catch (Throwable throwable) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
                break block16;
            }
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        return prop;
    }

    private BuildController getBuildController() {
        if (this.m_controller == null) {
            this.m_controller = new BuildController();
            this.m_controller.enableParallel(this.m_enableParallel).enableTrace(this.m_enableTrace);
            this.m_controller.setGenJsr(this.getGenJsr());
            this.m_controller.setUseOnDemand(this.m_useOnDemand);
            this.m_controller.setVerbose(this.m_enableDebug);
            this.m_controller.getTranslateController().setInitializer((ITranslationInitializer)new DefaultTranslationInitializer());
            if (this.m_enableDebug) {
                System.out.println("m_useOnDemand=" + this.m_useOnDemand);
                System.out.println("m_genJsr=" + this.m_genJsr);
                System.out.println("m_enableParallel=" + this.m_enableParallel);
                System.out.println("m_enableTrace=" + this.m_enableTrace);
            }
        }
        return this.m_controller;
    }

    public String getSourceDirs() {
        return this.m_sourceDirs;
    }

    public void setSourceDirs(String baseDir) {
        this.m_sourceDirs = baseDir;
    }

    public String getProjectDir() {
        return this.m_projectDir;
    }

    public void setProjectDir(String projectDir) {
        this.m_projectDir = projectDir;
    }

    public void setExclusion(String string) {
        this.m_exclusion = string;
    }

    public String getExclusion() {
        return this.m_exclusion;
    }

    public boolean getEnableParallel() {
        return this.m_enableParallel;
    }

    public void setEnableParallel(boolean parallel) {
        this.m_enableParallel = parallel;
    }

    public boolean getEnableTrace() {
        return this.m_enableTrace;
    }

    public void setEnableTrace(boolean trace) {
        this.m_enableTrace = trace;
    }

    public boolean getEnableDebug() {
        return this.m_enableDebug;
    }

    public void setEnableDebug(boolean debug) {
        this.m_enableDebug = debug;
    }

    public boolean getGenJsr() {
        return this.m_genJsr;
    }

    public void setGenJsr(boolean value) {
        this.m_genJsr = value;
    }

    public String getJ2jPkgName() {
        return this.m_j2jPkgName;
    }

    public void setJ2jPkgName(String pkgName) {
        this.m_j2jPkgName = pkgName;
    }

    private void printErrors(List<TranslateError> errors) {
        if (!this.m_enableDebug) {
            return;
        }
        for (TranslateError e : errors) {
            if (e.getLevel() != LogLevel.ERROR) continue;
            System.err.println(e.toString());
        }
    }

    public String getSourceSearchPath() {
        return this.m_sourceSearchPath;
    }

    public void setSourceSearchPath(String searchPath) {
        this.m_sourceSearchPath = searchPath;
    }
}

