/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.JSSourceModule;
import org.eclipse.dltk.mod.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.internal.ui.wizards.JstTypeDefaultValueHelper;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VjetWizardMessages;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VjoClassCreationPage;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VjoSourceModulePage;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VjoSourceModuleWizard;
import org.eclipse.vjet.eclipse.ui.JavaScriptImages;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;

public class VjoClassCreationWizard
extends VjoSourceModuleWizard {
    public static final String PROPS = "props";
    public static final String PROTOS = "protos";
    public static final String EMPTY = "";
    private static final String INHERITS = ".inherits(''{0}'')";
    private static final String SATISFIES = ".satisfies(''{0}'')";
    private static final String INDENTATION = "\r\n\t";
    private static final String ATYPE = "atype";
    private static final String TYPE = "ctype";

    public VjoClassCreationWizard() {
        this.setDefaultPageImageDescriptor(JavaScriptImages.DESC_WIZBAN_PROJECT_CREATION);
        this.setDialogSettings(DLTKUIPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(VjetWizardMessages.ClassCreationWizard_title);
    }

    @Override
    protected VjoSourceModulePage createVjoSourceModulePage() {
        return new VjoClassCreationPage();
    }

    @Override
    public void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        super.finishPage(monitor);
        JSSourceModule module = (JSSourceModule)this.getCreatedElement();
        IFile file = (IFile)module.getResource();
        byte[] content = this.getInitialFileContent(file);
        ByteArrayInputStream stream = new ByteArrayInputStream(content);
        file.appendContents((InputStream)stream, false, false, monitor);
    }

    protected byte[] getInitialFileContent(IFile file) throws ModelException {
        String satisfiesMethods;
        String constStub;
        String satsifies;
        String content = this.getFileContentTamplate();
        String buffer = CodeassistUtils.getClassName((IFile)file);
        String modifiers = this.getModifierIndex();
        String modifierDesc = this.formatModifier(modifiers);
        modifierDesc = String.valueOf(modifierDesc) + "\r\n";
        String type = this.getClassType();
        String inheritance = this.getInheritance();
        if (inheritance.length() > 0) {
            inheritance = String.valueOf(inheritance) + "\r\n";
        }
        if ((satsifies = this.getSatisfies()).length() > 0) {
            satsifies = String.valueOf(satsifies) + "\r\n";
        }
        if ((constStub = this.getConstructorStub()).length() > 0) {
            constStub = String.valueOf(constStub) + "\r\n";
        }
        if ((satisfiesMethods = this.getSastisfiesMethods()).length() > 0) {
            if (constStub.length() > 0) {
                satisfiesMethods = String.valueOf(satisfiesMethods) + ",";
            }
            satisfiesMethods = String.valueOf(satisfiesMethods) + "\r\n";
        }
        String methodStub = this.getMethodStub();
        String blockName = this.getBlockName();
        if ("etype".equals(type)) {
            String newContent;
            String valueSection = ".values('\r\n\t''''\r\n')\r\n";
            int position = content.indexOf(".{4}(");
            String sufContent = content.substring(0, position);
            content = newContent = String.valueOf(sufContent) + valueSection + content.substring(content.indexOf(".{4}("));
        }
        if ("otype".equals(type)) {
            int position = content.indexOf(".{7}(");
            content = String.valueOf(content.substring(0, position)) + ".endType();";
        }
        IPreferenceStore store = VjetUIPlugin.getDefault().getPreferenceStore();
        store.getString("formatter.tabulation.char");
        Object[] objects = new Object[]{type, buffer, inheritance, methodStub, blockName, modifierDesc, satsifies, PROTOS, constStub, satisfiesMethods};
        return MessageFormat.format(content, objects).getBytes();
    }

    private static boolean isMethodEquivalent(IJstMethod m1, IJstMethod m2) {
        if (!m1.getName().getName().equals(m2.getName().getName())) {
            return false;
        }
        List args1 = m1.getArgs();
        List args2 = m2.getArgs();
        if (args1.size() == args2.size()) {
            int i = 0;
            while (i < args1.size()) {
                if (!((JstArg)args1.get(i)).getType().getName().equals(((JstArg)args2.get(i)).getType().getName())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean isContainMethod(List<IJstMethod> ms, IJstMethod m) {
        for (IJstMethod jstMethod : ms) {
            if (!VjoClassCreationWizard.isMethodEquivalent(jstMethod, m)) continue;
            return true;
        }
        return false;
    }

    private String getSastisfiesMethods() {
        if (!(this.page instanceof VjoClassCreationPage)) {
            return EMPTY;
        }
        List elms = this.page.getSuperInterfacesDialogField().getElements();
        IJstType baseType = ((VjoClassCreationPage)this.page).getBaseType();
        ArrayList<IJstMethod> canOverrideMethods = new ArrayList<IJstMethod>();
        if (baseType != null) {
            List baseMethods = baseType.getMethods(false, true);
            for (IJstMethod m : baseMethods) {
                if (!m.isProtected() && !m.isPublic()) continue;
                canOverrideMethods.add(m);
            }
        }
        String satisfiesMethods = EMPTY;
        ArrayList<IJstMethod> toBeAddedMethods = new ArrayList<IJstMethod>();
        for (Object object : elms) {
            VjoSourceModulePage.InterfaceWrapper iw = (VjoSourceModulePage.InterfaceWrapper)object;
            IJstType type = iw.getSourceType();
            List ml = type.getMethods(false, true);
            for (IJstMethod jstMethod : ml) {
                if (VjoClassCreationWizard.isContainMethod(canOverrideMethods, jstMethod) || VjoClassCreationWizard.isContainMethod(toBeAddedMethods, jstMethod)) continue;
                toBeAddedMethods.add(jstMethod);
            }
        }
        for (IJstMethod jstMethod2 : toBeAddedMethods) {
            satisfiesMethods = String.valueOf(satisfiesMethods) + VjoClassCreationWizard.getReplaceStringForOverrideProposal(jstMethod2);
            satisfiesMethods = String.valueOf(satisfiesMethods) + ",\r\n";
        }
        int length = satisfiesMethods.lastIndexOf(",");
        return length == -1 ? satisfiesMethods : satisfiesMethods.substring(0, length);
    }

    public static String getReplaceStringForOverrideProposal(IJstMethod method) {
        StringBuffer buffer = new StringBuffer();
        String commStr = CodeCompletionUtils.getJstCommentStringR((IJstMethod)method);
        buffer.append("\r\n\t//>" + commStr);
        String name = method.getName().getName();
        buffer.append(INDENTATION + name);
        buffer.append(" : function(");
        String aname = CodeCompletionUtils.getJstArgsStringR((IJstMethod)method);
        if (aname.length() > 0) {
            buffer.append(aname);
        }
        buffer.append(")");
        String returnStatement = null;
        String defaultReturnValue = JstTypeDefaultValueHelper.getDefaultValue(method.getRtnType());
        returnStatement = defaultReturnValue == null ? "\t\t\r\n\t" : "\t\treturn " + defaultReturnValue + ";\r\n\t";
        buffer.append("{\r\n" + returnStatement + "}");
        return buffer.toString();
    }

    protected String getBlockName() {
        return PROPS;
    }

    protected String getFileContentTamplate() {
        return VjetWizardMessages.ClassCreationWizard_file_content;
    }

    protected String getInheritance() {
        String className = ((VjoClassCreationPage)this.page).getSuperclassFieldText();
        String inheritance = EMPTY;
        if (className != null && !className.trim().equals(EMPTY)) {
            inheritance = MessageFormat.format(INHERITS, className);
        }
        return inheritance;
    }

    protected String getSatisfies() {
        List elms = this.page.getSuperInterfacesDialogField().getElements();
        String satisfies = EMPTY;
        for (Object object : elms) {
            String interfacename = object.toString();
            if (interfacename == null || interfacename.trim().equals(EMPTY)) continue;
            if ("itype".equals(this.getClassType())) {
                if (satisfies.equals(EMPTY)) {
                    satisfies = String.valueOf(satisfies) + MessageFormat.format(INHERITS, interfacename);
                    continue;
                }
                satisfies = String.valueOf(satisfies) + "\r\n" + MessageFormat.format(INHERITS, interfacename);
                continue;
            }
            satisfies = satisfies.equals(EMPTY) ? String.valueOf(satisfies) + MessageFormat.format(SATISFIES, interfacename) : String.valueOf(satisfies) + "\r\n" + MessageFormat.format(SATISFIES, interfacename);
        }
        return satisfies;
    }

    protected String getClassType() {
        String type = TYPE;
        return type;
    }

    protected String formatModifier(String modifier) {
        String modDesc = EMPTY;
        String preFix = " //< ";
        if (modifier.contains("public")) {
            modDesc = "public";
        }
        if (modifier.contains("default")) {
            modDesc = EMPTY;
        }
        if (modifier.contains("private")) {
            modDesc = "private";
        }
        if (modifier.contains("protected")) {
            modDesc = "protected";
        }
        if (modifier.contains("abstract")) {
            modDesc = String.valueOf(modDesc) + " abstract";
        }
        if (modifier.contains("final")) {
            modDesc = String.valueOf(modDesc) + " final";
        }
        if (modDesc.trim().length() > 0) {
            modDesc = String.valueOf(preFix) + modDesc;
        }
        return modDesc;
    }

    protected String getOpenTypeErrorMessage() {
        return DLTKUIMessages.OpenTypeAction_errorMessage;
    }

    protected String getOpenTypeErrorTitle() {
        return DLTKUIMessages.OpenTypeAction_errorTitle;
    }

    private String getMethodStub() {
        String content = EMPTY;
        if (this.page != null && this.page instanceof VjoClassCreationPage && ((VjoClassCreationPage)this.page).isMethodStubsButtonSelected()) {
            content = VjetWizardMessages.ClassCreationWizard_main_method_content;
        }
        return content;
    }

    private String getConstructorStub() {
        String content = EMPTY;
        if (this.page != null && this.page instanceof VjoClassCreationPage && ((VjoClassCreationPage)this.page).isConstructorButtonSelected()) {
            content = String.valueOf(content) + VjetWizardMessages.ClassCreationWizard_constructor_content;
        }
        return content;
    }
}

