/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.refactoring.rename;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.DLTKContentTypeManager;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.internal.corext.refactoring.Checks;
import org.eclipse.dltk.mod.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.dltk.mod.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.mod.internal.corext.refactoring.ScriptRefactoringArguments;
import org.eclipse.dltk.mod.internal.corext.refactoring.ScriptRefactoringDescriptor;
import org.eclipse.dltk.mod.internal.corext.refactoring.ScriptRefactoringDescriptorComment;
import org.eclipse.dltk.mod.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.dltk.mod.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.dltk.mod.internal.corext.refactoring.changes.RenameSourceModuleChange;
import org.eclipse.dltk.mod.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.dltk.mod.internal.corext.refactoring.participants.RenameTypeArguments;
import org.eclipse.dltk.mod.internal.corext.refactoring.participants.ScriptProcessors;
import org.eclipse.dltk.mod.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.dltk.mod.internal.corext.refactoring.rename.ScriptRenameProcessor;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.ISimilarDeclarationUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.dltk.mod.internal.corext.util.Messages;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IResourceMapper;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.vjet.eclipse.internal.ui.refactoring.rename.RenameVjoTypeProcessor;

public class RenameVjoSourceModuleProcessor
extends ScriptRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating,
ISimilarDeclarationUpdating,
IResourceMapper {
    private RenameVjoTypeProcessor fRenameTypeProcessor = null;
    private boolean fWillRenameType = false;
    private static final String ID_RENAME_COMPILATION_UNIT = "org.eclipse.dltk.mod.ui.rename.sourcemodule";
    private static final String ATTRIBUTE_PATH = "path";
    private static final String ATTRIBUTE_NAME = "name";
    private ISourceModule fCu;
    public static final String IDENTIFIER = "org.eclipse.dltk.mod.ui.renameSourceModulerocessor";

    public RenameVjoSourceModuleProcessor(ISourceModule unit) throws CoreException {
        this.fCu = unit;
        if (this.fCu != null) {
            this.computeRenameTypeRefactoring();
            this.setNewElementName(this.fCu.getElementName());
        }
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() {
        return RefactoringAvailabilityTester.isRenameAvailable((ISourceModule)this.fCu);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameSourceModuleRefactoring_name;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return ScriptProcessors.computeAffectedNatures((IModelElement)this.fCu);
    }

    public Object[] getElements() {
        return new Object[]{this.fCu};
    }

    protected RenameModifications computeRenameModifications() {
        RenameModifications result = new RenameModifications();
        result.rename(this.fCu, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
        if (this.fRenameTypeProcessor != null) {
            String newTypeName = RenameVjoSourceModuleProcessor.removeFileNameExtension(this.getNewElementName());
            RenameTypeArguments arguments = new RenameTypeArguments(newTypeName, this.getUpdateReferences(), this.getUpdateSimilarDeclarations(), this.getSimilarElements());
            result.rename(this.fRenameTypeProcessor.getType(), arguments, (IParticipantDescriptorFilter)(this.getUpdateSimilarDeclarations() ? new RenameVjoTypeProcessor.ParticipantDescriptorFilter() : null));
        }
        return result;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        IFile file = ResourceUtil.getFile((ISourceModule)this.fCu);
        if (file != null) {
            return new IFile[]{file};
        }
        return new IFile[0];
    }

    public String getCurrentElementName() {
        return this.getSimpleCUName();
    }

    public String getCurrentElementQualifier() {
        IScriptFolder pack = (IScriptFolder)this.fCu.getParent();
        return pack.getElementName();
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull((Object)newName, (String)"new name");
        String typeName = RenameVjoSourceModuleProcessor.removeFileNameExtension(newName);
        RefactoringStatus result = Checks.checkSourceModuleName((String)newName);
        if (this.fWillRenameType) {
            result.merge(this.fRenameTypeProcessor.checkNewElementName(typeName));
        }
        if (Checks.isAlreadyNamed((IModelElement)this.fCu, (String)newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameSourceModuleRefactoring_same_name);
        }
        return result;
    }

    public void setNewElementName(String newName) {
        super.setNewElementName(newName);
        if (this.fWillRenameType) {
            this.fRenameTypeProcessor.setNewElementName(RenameVjoSourceModuleProcessor.removeFileNameExtension(newName));
        }
    }

    public Object getNewElement() {
        IModelElement parent = this.fCu.getParent();
        if (parent.getElementType() != 4) {
            return this.fCu;
        }
        IScriptFolder pack = (IScriptFolder)parent;
        IDLTKLanguageToolkit tk = null;
        tk = DLTKLanguageManager.getLanguageToolkit((IModelElement)pack);
        if (tk != null && !DLTKContentTypeManager.isValidFileNameForContentType((IDLTKLanguageToolkit)tk, (String)this.getNewElementName())) {
            return this.fCu;
        }
        return pack.getSourceModule(this.getNewElementName());
    }

    public boolean canEnableTextUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableUpdateReferences();
    }

    public boolean getUpdateTextualMatches() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateTextualMatches();
    }

    public void setUpdateTextualMatches(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateTextualMatches(update);
        }
    }

    public boolean canEnableUpdateReferences() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableUpdateReferences();
    }

    public void setUpdateReferences(boolean update) {
        if (this.fRenameTypeProcessor != null) {
            this.fRenameTypeProcessor.setUpdateReferences(update);
        }
    }

    public boolean getUpdateReferences() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateReferences();
    }

    public boolean canEnableQualifiedNameUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableQualifiedNameUpdating();
    }

    public boolean getUpdateQualifiedNames() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateQualifiedNames();
    }

    public void setUpdateQualifiedNames(boolean update) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setUpdateQualifiedNames(update);
    }

    public String getFilePatterns() {
        if (this.fRenameTypeProcessor == null) {
            return null;
        }
        return this.fRenameTypeProcessor.getFilePatterns();
    }

    public void setFilePatterns(String patterns) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setFilePatterns(patterns);
    }

    public boolean canEnableSimilarDeclarationUpdating() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.canEnableSimilarDeclarationUpdating();
    }

    public void setUpdateSimilarDeclarations(boolean update) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setUpdateSimilarDeclarations(update);
    }

    public boolean getUpdateSimilarDeclarations() {
        if (this.fRenameTypeProcessor == null) {
            return false;
        }
        return this.fRenameTypeProcessor.getUpdateSimilarDeclarations();
    }

    public int getMatchStrategy() {
        if (this.fRenameTypeProcessor == null) {
            return 1;
        }
        return this.fRenameTypeProcessor.getMatchStrategy();
    }

    public void setMatchStrategy(int selectedStrategy) {
        if (this.fRenameTypeProcessor == null) {
            return;
        }
        this.fRenameTypeProcessor.setMatchStrategy(selectedStrategy);
    }

    public IModelElement[] getSimilarElements() {
        if (this.fRenameTypeProcessor == null) {
            return null;
        }
        return this.fRenameTypeProcessor.getSimilarElements();
    }

    public IResource getRefactoredResource(IResource element) {
        if (this.fRenameTypeProcessor == null) {
            return element;
        }
        return this.fRenameTypeProcessor.getRefactoredResource(element);
    }

    public IModelElement getRefactoredModelElement(IModelElement element) {
        if (this.fRenameTypeProcessor == null) {
            return element;
        }
        return this.fRenameTypeProcessor.getRefactoredModelElement(element);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        if (this.fRenameTypeProcessor != null && !this.fCu.isStructureKnown()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        if (this.fWillRenameType && this.fRenameTypeProcessor != null && !this.fRenameTypeProcessor.getType().exists()) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return new RefactoringStatus();
        }
        return new RefactoringStatus();
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            if (this.fWillRenameType && !this.fCu.isStructureKnown()) {
                RefactoringStatus result1 = new RefactoringStatus();
                RefactoringStatus result2 = new RefactoringStatus();
                result2.merge(Checks.checkSourceModuleNewName((ISourceModule)this.fCu, (String)this.getNewElementName()));
                if (result2.hasFatalError()) {
                    result1.addError(Messages.format((String)RefactoringCoreMessages.RenameSourceModuleRefactoring_not_parsed_1, (Object)this.fCu.getElementName()));
                } else {
                    result1.addError(Messages.format((String)RefactoringCoreMessages.RenameSourceModuleRefactoring_not_parsed, (Object)this.fCu.getElementName()));
                }
                result1.merge(result2);
                RefactoringStatus refactoringStatus = result1;
                return refactoringStatus;
            }
            if (this.fWillRenameType) {
                RefactoringStatus refactoringStatus = this.fRenameTypeProcessor.checkFinalConditions(pm, context);
                return refactoringStatus;
            }
            RefactoringStatus refactoringStatus = Checks.checkSourceModuleNewName((ISourceModule)this.fCu, (String)this.getNewElementName());
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    protected void computeRenameTypeRefactoring() throws CoreException {
        if (this.getSimpleCUName().indexOf(".") != -1) {
            this.fRenameTypeProcessor = null;
            this.fWillRenameType = false;
            return;
        }
        IType type = this.getTypeWithTheSameName();
        this.fRenameTypeProcessor = type != null ? new RenameVjoTypeProcessor(type) : null;
        this.fWillRenameType = this.fRenameTypeProcessor != null && this.fCu.isStructureKnown();
    }

    private IType getTypeWithTheSameName() {
        try {
            IType[] topLevelTypes = this.fCu.getTypes();
            String name = this.getSimpleCUName();
            int i = 0;
            while (i < topLevelTypes.length) {
                if (name.equals(topLevelTypes[i].getElementName())) {
                    return topLevelTypes[i];
                }
                ++i;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private String getSimpleCUName() {
        return RenameVjoSourceModuleProcessor.removeFileNameExtension(this.fCu.getElementName());
    }

    private static String removeFileNameExtension(String fileName) {
        if (fileName.lastIndexOf(".") == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.fWillRenameType) {
            return this.fRenameTypeProcessor.createChange(pm);
        }
        this.fRenameTypeProcessor = null;
        String newName = this.getNewElementName();
        IResource resource = ResourceUtil.getResource((ISourceModule)this.fCu);
        if (resource != null && resource.isLinked()) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            IProject project = resource.getProject();
            String name = project.getName();
            String description = Messages.format((String)RefactoringCoreMessages.RenameSourceModuleChange_descriptor_description_short, (Object)resource.getName());
            String header = Messages.format((String)RefactoringCoreMessages.RenameSourceModuleChange_descriptor_description, (Object[])new String[]{resource.getFullPath().toString(), newName});
            String comment = new ScriptRefactoringDescriptorComment((Object)this, header).asString();
            ScriptRefactoringDescriptor descriptor = new ScriptRefactoringDescriptor("org.eclipse.dltk.mod.ui.rename.resource", name, description, comment, arguments, 7);
            arguments.put("input", ScriptRefactoringDescriptor.resourceToHandle((String)name, (IResource)resource));
            arguments.put(ATTRIBUTE_NAME, newName);
            return new DynamicValidationStateChange((Change)new RenameResourceChange((RefactoringDescriptor)descriptor, resource, newName, comment));
        }
        String label = null;
        if (this.fCu != null) {
            IScriptFolder fragment = (IScriptFolder)this.fCu.getParent();
            label = !fragment.isRootFolder() ? String.valueOf(fragment.getElementName()) + "." + this.fCu.getElementName() : this.fCu.getElementName();
        }
        HashMap<String, String> arguments = new HashMap<String, String>();
        String name = this.fCu.getScriptProject().getElementName();
        String description = Messages.format((String)RefactoringCoreMessages.RenameSourceModuleChange_descriptor_description_short, (Object)this.fCu.getElementName());
        String header = Messages.format((String)RefactoringCoreMessages.RenameSourceModuleChange_descriptor_description, (Object[])new String[]{label, newName});
        String comment = new ScriptRefactoringDescriptorComment((Object)this, header).asString();
        ScriptRefactoringDescriptor descriptor = new ScriptRefactoringDescriptor(ID_RENAME_COMPILATION_UNIT, name, description, comment, arguments, 589830);
        arguments.put("input", descriptor.elementToHandle((IModelElement)this.fCu));
        arguments.put(ATTRIBUTE_NAME, newName);
        return new DynamicValidationStateChange((Change)new RenameSourceModuleChange((RefactoringDescriptor)descriptor, this.fCu, newName, comment));
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        if (this.fWillRenameType) {
            return this.fRenameTypeProcessor.postCreateChange(participantChanges, pm);
        }
        return super.postCreateChange(participantChanges, pm);
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        if (!(arguments instanceof ScriptRefactoringArguments)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        ScriptRefactoringArguments extended = (ScriptRefactoringArguments)arguments;
        String handle = extended.getAttribute("input");
        if (handle == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format((String)RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, (Object)"input"));
        }
        IModelElement element = ScriptRefactoringDescriptor.handleToElement((String)extended.getProject(), (String)handle, (boolean)false);
        if (element == null || !element.exists() || element.getElementType() != 5) {
            return ScriptableRefactoring.createInputFatalStatus((Object)element, (String)this.getRefactoring().getName(), (String)"org.eclipse.vjet.eclipse.ui.rename.sourcemodule");
        }
        this.fCu = (ISourceModule)element;
        String name = extended.getAttribute(ATTRIBUTE_NAME);
        if (name == null || name.length() == 0) {
            name = this.fCu.getElementName();
        }
        try {
            this.computeRenameTypeRefactoring();
            this.setNewElementName(name);
        }
        catch (CoreException exception) {
            DLTKUIPlugin.log((Throwable)exception);
            return ScriptableRefactoring.createInputFatalStatus((Object)element, (String)this.getRefactoring().getName(), (String)"org.eclipse.vjet.eclipse.ui.rename.sourcemodule");
        }
        return new RefactoringStatus();
    }

    public RenameVjoTypeProcessor getRenameTypeProcessor() {
        return this.fRenameTypeProcessor;
    }

    public boolean isWillRenameType() {
        return this.fWillRenameType;
    }
}

