/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.mod.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.dltk.mod.ui.preferences.AbstractOptionsBlock;
import org.eclipse.dltk.mod.ui.preferences.PreferenceKey;
import org.eclipse.dltk.mod.ui.util.IStatusChangeListener;
import org.eclipse.dltk.mod.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoSemanticRule;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoSemanticRuleSet;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoGroupRulesCache;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticRulePolicy;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.eclipse.core.validation.DefaultValidator;
import org.eclipse.vjet.eclipse.internal.ui.preferences.VjetPreferenceMessages;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class VjetProblemSeveritiesConfigurationBlock
extends AbstractOptionsBlock {
    public static final String VJETVALIDATION = "VJETVALIDATION";
    private static final String ERROR = "error";
    private static final String IGNORE = "ignore";
    private static final String WARNING = "warning";
    private static final String DEFAULT = "default";
    private PixelConverter fPixelConverter;
    String[] errorWarningIgnoreLabels = new String[]{VjetPreferenceMessages.ProblemSeveritiesConfigurationBlock_error, VjetPreferenceMessages.ProblemSeveritiesConfigurationBlock_warning, VjetPreferenceMessages.ProblemSeveritiesConfigurationBlock_ignore, "Default"};
    private HashMap<PreferenceKey, Combo> comboPool = new HashMap();
    private Button validationCheckbox;
    private static VjoSemanticRuleRepo ruleRepo = VjoSemanticRuleRepo.getInstance();

    public VjetProblemSeveritiesConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
        super(context, project, VjetProblemSeveritiesConfigurationBlock.getKeys(), container);
    }

    private static PreferenceKey[] getKeys() {
        VjoSemanticRuleRepo ruleRepo = VjoSemanticRuleRepo.getInstance();
        String keyName = "";
        ArrayList<PreferenceKey> list = new ArrayList<PreferenceKey>();
        for (IVjoSemanticRuleSet ruleSet : ruleRepo.getRuleSets()) {
            keyName = ruleSet.getRuleSetName();
            list.add(new PreferenceKey("org.eclipse.vjet.eclipse.core", keyName));
        }
        list.add(new PreferenceKey("org.eclipse.vjet.eclipse.core", VJETVALIDATION));
        PreferenceKey[] keys = new PreferenceKey[list.size()];
        return list.toArray(keys);
    }

    protected static PreferenceKey getKey(String keyName) {
        PreferenceKey[] preferenceKeyArray = VjetProblemSeveritiesConfigurationBlock.getKeys();
        int n = preferenceKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceKey key = preferenceKeyArray[n2];
            if (key.getName().equals(keyName)) {
                return key;
            }
            ++n2;
        }
        return null;
    }

    protected static final PreferenceKey getVJETCoreKey(String key) {
        return VjetProblemSeveritiesConfigurationBlock.getKey((String)"org.eclipse.vjet.eclipse.ui", (String)key);
    }

    private Composite createStyleTabContent(Composite folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        int nColumns = 3;
        final Composite buttonComposite = new Composite(folder, 0);
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 2;
        layout1.marginHeight = 0;
        layout1.marginWidth = 0;
        layout1.horizontalSpacing = 5;
        layout1.makeColumnsEqualWidth = false;
        buttonComposite.setLayout((Layout)layout1);
        Button exportButton = new Button(buttonComposite, 8);
        Dialog.applyDialogFont((Control)exportButton);
        Button importButton = new Button(buttonComposite, 8);
        Dialog.applyDialogFont((Control)importButton);
        exportButton.setText("&Export Policy");
        importButton.setText("&Import Policy");
        importButton.setVisible(false);
        exportButton.setVisible(false);
        GridData data = new GridData(256);
        data.widthHint = 20;
        data.heightHint = 12;
        IProject project = this.getProject();
        if (project == null) {
            exportButton.setToolTipText(VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_4);
            importButton.setToolTipText(VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_5);
        } else {
            exportButton.setToolTipText(String.valueOf(VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_6) + project.getName() + VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_7);
            importButton.setToolTipText(String.valueOf(VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_8) + project.getName() + "\"");
        }
        exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VjetProblemSeveritiesConfigurationBlock.this.exportValidationPolicy(buttonComposite);
            }
        });
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VjetProblemSeveritiesConfigurationBlock.this.importValidationPolicy(buttonComposite);
            }
        });
        ScrolledPageContent sc1 = new ScrolledPageContent(folder);
        Composite composite = sc1.getBody();
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 16448);
        description.setFont(description.getFont());
        description.setText(VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_10);
        description.setLayoutData((Object)new GridData(1, 2, true, false, nColumns - 1, 1));
        int indentStep = this.fPixelConverter.convertWidthInCharsToPixels(1);
        int defaultIndent = indentStep * 0;
        if (this.validationCheckbox != null) {
            this.bindControl(this.validationCheckbox, VjetProblemSeveritiesConfigurationBlock.getKey(VJETVALIDATION), null);
        }
        String keyName = VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_11;
        PreferenceKey key = null;
        this.comboPool.clear();
        for (IVjoSemanticRuleSet ruleSet : ruleRepo.getRuleSets()) {
            String label = ruleSet.getRuleSetDescription();
            label = ruleSet.getRuleSetDescription();
            keyName = ruleSet.getRuleSetName();
            key = VjetProblemSeveritiesConfigurationBlock.getKey(keyName);
            if (key == null) continue;
            String value = this.getValue(key);
            if (value == null) {
                this.setValue(key, this.getSeverity(ruleSet));
            }
            Combo combo = this.addComboBox(composite, label, key, errorWarningIgnore, this.errorWarningIgnoreLabels, defaultIndent);
            this.bindControl(combo, key);
            this.comboPool.put(key, combo);
        }
        return sc1;
    }

    protected Combo addComboBox(Composite parent, String label, PreferenceKey key, String[] values, String[] valueLabels, int indent) {
        GridData gd = new GridData(4, 2, true, false, 2, 1);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16384);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(parent, key, values, valueLabels);
        comboBox.setLayoutData((Object)new GridData(256));
        return comboBox;
    }

    protected Combo newComboControl(Composite composite, PreferenceKey key, String[] values, String[] valueLabels) {
        OptionsConfigurationBlock.ControlData data = new OptionsConfigurationBlock.ControlData(key, values);
        Combo comboBox = new Combo(composite, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.setFont(JFaceResources.getDialogFont());
        this.makeScrollableCompositeAware((Control)comboBox);
        String currValue = this.getValue(key);
        comboBox.select(data.getSelection(currValue));
        return comboBox;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_13;
        String message = VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_14;
        return new String[]{title, message};
    }

    private String getSeverity(IVjoSemanticRuleSet ruleSet) {
        return DEFAULT;
    }

    private String getSeverity(VjoSemanticRulePolicy policy) {
        if (VjoSemanticRulePolicy.GLOBAL_ERROR_POLICY.equals(policy)) {
            return ERROR;
        }
        if (VjoSemanticRulePolicy.GLOBAL_WARNING_POLICY.equals(policy)) {
            return WARNING;
        }
        if (VjoSemanticRulePolicy.GLOBAL_IGNORE_POLICY.equals(policy)) {
            return IGNORE;
        }
        return DEFAULT;
    }

    protected Control createOptionsBlock(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        this.creteValidationCheckBoxComposite(mainComp);
        Composite commonComposite = this.createStyleTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(20);
        commonComposite.setLayoutData((Object)gridData);
        return mainComp;
    }

    private void creteValidationCheckBoxComposite(Composite ancestor) {
        IProject project = this.getProject();
        String groupName = null;
        if (project != null) {
            groupName = project.getName();
        }
        if (groupName != null) {
            return;
        }
        Composite validationCheckBoxComposite = new Composite(ancestor, 0);
        this.validationCheckbox = new Button(validationCheckBoxComposite, 32);
        this.validationCheckbox.setText(VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_15);
        this.validationCheckbox.setSelection(VjetUIPlugin.getDefault().getPreferenceStore().getBoolean(VJETVALIDATION));
        validationCheckBoxComposite.setLayout((Layout)new GridLayout());
    }

    protected void changesSaved() {
        IProject project = this.getProject();
        String groupName = null;
        if (project != null) {
            groupName = project.getName();
        }
        DefaultValidator.getValidator().ruleChanged(groupName);
    }

    private void exportValidationPolicy(Composite folder) {
        FileDialog exportDialog = new FileDialog(folder.getShell(), 8192);
        IProject p = this.getProject();
        exportDialog.setFilterExtensions(new String[]{"*.prefs"});
        if (p == null) {
            exportDialog.setText(VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_17);
        } else {
            exportDialog.setText("Export project:\"" + p.getName() + "\"valdiation policy");
        }
        String path = exportDialog.open();
        if (path == null) {
            return;
        }
        VjetProblemSeveritiesConfigurationBlock.exportPolicy2File(folder, p, path);
    }

    public static void exportPolicy2File(Composite folder, IProject p, String path) {
        File f = new File(path);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException iOException) {
                MessageDialog.openError((Shell)folder.getShell(), (String)VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_20, (String)VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_21);
                return;
            }
        }
        Properties pro = new Properties();
        String ruleSetName = "";
        for (IVjoSemanticRuleSet ruleSet : ruleRepo.getRuleSets()) {
            ruleSetName = ruleSet.getRuleSetName();
            for (IVjoSemanticRule rule : ruleSet.getRules()) {
                if (p == null) {
                    pro.put(String.valueOf(ruleSetName) + "." + rule.getRuleName(), rule.getGlobalRulePolicy().getProblemSeverity(null).toString());
                    continue;
                }
                pro.put(String.valueOf(ruleSetName) + "." + rule.getRuleName(), VjoGroupRulesCache.getInstance().getRulePolicy(p.getName(), rule).getProblemSeverity(null).toString());
            }
        }
        try {
            if (f.canWrite()) {
                pro.store(new FileOutputStream(path), "");
            } else {
                MessageDialog.openError((Shell)folder.getShell(), (String)VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_26, (String)VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_27);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void importValidationPolicy(Composite folder) {
        FileDialog exportDialog = new FileDialog(folder.getShell(), 8);
        IProject p = this.getProject();
        exportDialog.setFilterExtensions(new String[]{"*.prefs"});
        if (p == null) {
            exportDialog.setText(VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_29);
        } else {
            exportDialog.setText(String.valueOf(VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_30) + p.getName() + "\"");
        }
        String path = exportDialog.open();
        if (path == null) {
            return;
        }
        this.importPre2Repo(folder, path);
    }

    public void importPre2Repo(Composite folder, String path) {
        File f = new File(path);
        if (!f.exists()) {
            MessageDialog.openError((Shell)folder.getShell(), (String)VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_32, (String)VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_33);
        }
        Properties pro = new Properties();
        try {
            pro.load(new FileInputStream(path));
            String ruleSetName = "";
            String proKey = "";
            for (IVjoSemanticRuleSet ruleSet : ruleRepo.getRuleSets()) {
                ruleSetName = ruleSet.getRuleSetName();
                for (IVjoSemanticRule rule : ruleSet.getRules()) {
                    proKey = String.valueOf(ruleSetName) + "." + rule.getRuleName();
                    PreferenceKey key = VjetProblemSeveritiesConfigurationBlock.getKey(proKey);
                    this.setValue(key, pro.getProperty(proKey));
                    if (this.comboPool.get(key) == null) continue;
                    this.comboPool.get(key).select(this.getComboIndex(pro.getProperty(proKey)));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageDialog.openError((Shell)folder.getShell(), (String)VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_37, (String)VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_38);
        }
        catch (IOException iOException) {
            MessageDialog.openError((Shell)folder.getShell(), (String)VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_39, (String)VjetPreferenceMessages.VjetProblemSeveritiesConfigurationBlock_40);
        }
    }

    private int getComboIndex(String property) {
        if (property.equalsIgnoreCase(this.errorWarningIgnoreLabels[0])) {
            return 0;
        }
        if (property.equalsIgnoreCase(this.errorWarningIgnoreLabels[1])) {
            return 1;
        }
        if (property.equalsIgnoreCase(this.errorWarningIgnoreLabels[2])) {
            return 2;
        }
        return 0;
    }
}

