/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javatojs.ui.adapters;

import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.vjet.core.codegen.bootstrap.IToolMonitor;

public class ToolMonitor
implements IToolMonitor {
    private IProgressMonitor monitor;
    private PrintStream stream;
    private boolean console;

    public ToolMonitor(IProgressMonitor monitor, OutputStream stream) {
        this.monitor = monitor;
        this.setStream(stream);
        this.console = true;
    }

    public void setStream(OutputStream ostream) {
        this.stream = ostream == null ? System.out : new PrintStream(ostream);
    }

    public void setConsole(boolean console) {
        this.console = console;
    }

    public boolean isConsole() {
        return this.console;
    }

    public void beginTask(String name, int totalWork) {
        this.monitor.beginTask(name, totalWork);
        this.console(String.valueOf(name) + "\n");
    }

    public void done() {
        this.monitor.done();
        this.console("Done\n");
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public void setCanceled(boolean value) {
        this.monitor.setCanceled(value);
        this.console("Canceled\n");
    }

    public void subTask(String name) {
        this.monitor.setTaskName(name);
        this.console(String.valueOf(name) + "\n");
    }

    public void worked(int work) {
        this.monitor.worked(work);
        this.console(".");
    }

    protected void console(String msg) {
        if (this.console) {
            this.stream.print(msg);
        }
    }
}

