/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.core;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementVisitor;
import org.eclipse.dltk.mod.core.IModelStatus;
import org.eclipse.dltk.mod.core.IOpenable;
import org.eclipse.dltk.mod.core.IScriptModel;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;

public abstract class VjoModelElement
extends PlatformObject
implements IModelElement {
    public static final char JEM_ESCAPE = '\\';
    public static final char JEM_SCRIPTPROJECT = '=';
    public static final char JEM_PROJECTFRAGMENT = '/';
    public static final char JEM_SCRIPTFOLDER = '<';
    public static final char JEM_FIELD = '^';
    public static final char JEM_METHOD = '~';
    public static final char JEM_SOURCEMODULE = '{';
    public static final char JEM_TYPE = '[';
    public static final char JEM_IMPORTDECLARATION = '#';
    public static final char JEM_COUNT = '!';
    public static final char JEM_LOCALVARIABLE = '@';
    public static final char JEM_TYPE_PARAMETER = ']';
    public static final char JEM_PACKAGEDECLARATION = '%';
    public static final char JEM_SKIP_DELIMETER = '>';
    protected static final IModelElement[] NO_ELEMENTS = new IModelElement[0];
    protected IJstNode m_jstNode;
    protected VjoModelElement m_parent;
    protected String m_name;

    public VjoModelElement(VjoModelElement parent, IJstNode jstNode) {
        this.m_parent = parent;
        this.m_jstNode = jstNode;
    }

    VjoModelElement(VjoModelElement parent, String name) {
        this.m_parent = parent;
        this.m_name = name;
    }

    public boolean exists() {
        return this.m_jstNode != null;
    }

    public void accept(IModelElementVisitor visitor) throws ModelException {
    }

    public IModelElement getAncestor(int ancestorType) {
        VjoModelElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public String getElementName() {
        String name = this.m_jstNode instanceof IJstType ? ((IJstType)this.m_jstNode).getName() : (this.m_jstNode instanceof IJstProperty ? ((IJstProperty)this.m_jstNode).getName().getName() : (this.m_jstNode instanceof IJstMethod ? ((IJstMethod)this.m_jstNode).getName().getName() : this.m_name));
        return name;
    }

    public String getHandleIdentifier() {
        return this.getHandleMemento();
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer();
        this.getHandleMemento(buff);
        return buff.toString();
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((VjoModelElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
    }

    protected abstract char getHandleMementoDelimiter();

    protected void escapeMementoName(StringBuffer buffer, String mementoName) {
        int i = 0;
        int length = mementoName.length();
        while (i < length) {
            char character = mementoName.charAt(i);
            switch (character) {
                case '!': 
                case '#': 
                case '/': 
                case '<': 
                case '=': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '~': {
                    buffer.append('\\');
                }
            }
            buffer.append(character);
            ++i;
        }
    }

    public IScriptModel getModel() {
        VjoModelElement current = this;
        do {
            if (!(current instanceof IScriptModel)) continue;
            return (IScriptModel)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public IOpenable getOpenable() {
        return this.getOpenableParent();
    }

    public IOpenable getOpenableParent() {
        return (IOpenable)this.m_parent;
    }

    public IModelElement getParent() {
        return this.m_parent;
    }

    public IModelElement getPrimaryElement() {
        return this.getPrimaryElement(true);
    }

    public IModelElement getPrimaryElement(boolean checkOwner) {
        return this;
    }

    public IScriptProject getScriptProject() {
        VjoModelElement current = this;
        do {
            if (!(current instanceof IScriptProject)) continue;
            return (IScriptProject)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ModelException newNotPresentException() {
        return new ModelException((IModelStatus)new ModelStatus(969, (IModelElement)this));
    }

    public ISourceModule getSourceModule() {
        return null;
    }

    public IJstNode getJstNode() {
        return this.m_jstNode;
    }
}

