/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.validation;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoSemanticRule;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoSemanticRuleSet;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoGroupRulesCache;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticRulePolicy;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class DefaultValidator {
    private static VjoSemanticRuleRepo ruleRepo;
    private VjoGroupRulesCache m_projectRulesCache = VjoGroupRulesCache.getInstance();
    public static DefaultValidator validator;

    static {
        validator = null;
    }

    private DefaultValidator() {
        this.loadRuleRepo();
    }

    public static synchronized DefaultValidator getValidator() {
        if (validator == null) {
            return new DefaultValidator();
        }
        return validator;
    }

    public Set<IResource> deriveResources(Object object) {
        return null;
    }

    private void loadRuleRepo() {
        if (ruleRepo == null) {
            ruleRepo = VjoSemanticRuleRepo.getInstance();
            this.loadCustomedValue();
            this.loadCustomedPrjoectValue();
        }
    }

    private void loadCustomedPrjoectValue() {
        if (ruleRepo == null) {
            return;
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IProject project = null;
        IProjectNature nature = null;
        int i = 0;
        while (i < projects.length) {
            block6: {
                project = projects[i];
                if (project != null) {
                    try {
                        nature = project.getNature("org.eclipse.vjet.core.nature");
                    }
                    catch (CoreException coreException) {
                        break block6;
                    }
                    if (nature != null) {
                        this.innerClearCustomedProjectValue(project);
                        this.innerLoadProjectPreference(project);
                    }
                }
            }
            ++i;
        }
    }

    private void innerLoadProjectPreference(IProject project) {
        ProjectScope projectContext = new ProjectScope(project);
        if (!projectContext.getLocation().toFile().exists()) {
            return;
        }
        String groupName = project.getName();
        IEclipsePreferences prefs = projectContext.getNode("org.eclipse.vjet.eclipse.core");
        if (prefs == null) {
            return;
        }
        try {
            if (prefs.keys().length != 0) {
                this.loadProjectPre(groupName, prefs);
            }
        }
        catch (BackingStoreException backingStoreException) {
            return;
        }
    }

    private void loadProjectPre(String groupName, IEclipsePreferences prefs) {
        String ruleSetName = "";
        String propertyValue = null;
        for (IVjoSemanticRuleSet ruleSet : ruleRepo.getRuleSets()) {
            ruleSetName = ruleSet.getRuleSetName();
            propertyValue = prefs.get(ruleSetName, null);
            for (IVjoSemanticRule rule : ruleSet.getRules()) {
                if (propertyValue == null) continue;
                VjoSemanticRulePolicy policy = this.getRulePolicy(propertyValue);
                if (policy == null) {
                    rule.setGroupRulePolicy(groupName, rule.getDefaultPolicy());
                    continue;
                }
                rule.setGroupRulePolicy(groupName, policy);
            }
        }
    }

    private void loadCustomedValue() {
        Preferences preferenceStore = VjetPlugin.getDefault().getPluginPreferences();
        String ruleSetName = "";
        String propertyValue = null;
        for (IVjoSemanticRuleSet ruleSet : ruleRepo.getRuleSets()) {
            ruleSetName = ruleSet.getRuleSetName();
            propertyValue = preferenceStore.getString(ruleSetName);
            if (propertyValue.equalsIgnoreCase("default")) {
                for (IVjoSemanticRule rule : ruleSet.getRules()) {
                    rule.setGlobalPolicy(rule.getDefaultPolicy());
                }
                continue;
            }
            for (IVjoSemanticRule rule : ruleSet.getRules()) {
                rule.setGlobalPolicy(this.getRulePolicy(propertyValue));
            }
        }
    }

    private VjoSemanticRulePolicy getRulePolicy(String severity) {
        if ("error".equalsIgnoreCase(severity)) {
            return VjoSemanticRulePolicy.GLOBAL_ERROR_POLICY;
        }
        if ("warning".equalsIgnoreCase(severity)) {
            return VjoSemanticRulePolicy.GLOBAL_WARNING_POLICY;
        }
        if ("ignore".equalsIgnoreCase(severity)) {
            return VjoSemanticRulePolicy.GLOBAL_IGNORE_POLICY;
        }
        return null;
    }

    public void ruleChanged(String groupName) {
        if (groupName == null) {
            VjoSemanticRuleRepo.getInstance().restoreDefaultPolicies();
            this.loadCustomedValue();
        } else {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(groupName);
            if (project == null) {
                return;
            }
            this.innerClearCustomedProjectValue(project);
            this.innerLoadProjectPreference(project);
        }
    }

    public void innerClearCustomedProjectValue(IProject project) {
        ProjectScope projectContext = new ProjectScope(project);
        if (!projectContext.getLocation().toFile().exists()) {
            return;
        }
        String groupName = project.getName();
        if (groupName != null) {
            this.m_projectRulesCache.clearGroupCache(groupName);
        }
    }
}

