/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.ts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKContentTypeManager;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.Model;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.vjet.dsf.ts.event.ISourceEvent;
import org.eclipse.vjet.dsf.ts.event.group.RemoveGroupEvent;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.PiggyBackClassPathUtil;
import org.eclipse.vjet.eclipse.core.VjoLanguageToolkit;
import org.eclipse.vjet.eclipse.core.builder.TypeSpaceBuilder;
import org.eclipse.vjet.eclipse.core.ts.TypeSpaceGroupLoadJob;
import org.eclipse.vjet.eclipse.core.ts.TypeSpaceRefreshJob;
import org.eclipse.vjet.eclipse.core.ts.TypeSpaceReloadJob;
import org.eclipse.vjet.eclipse.core.ts.TypeSpaceTracer;
import org.eclipse.vjet.vjo.tool.typespace.GroupInfo;
import org.eclipse.vjet.vjo.tool.typespace.ITypeSpaceLoader;
import org.eclipse.vjet.vjo.tool.typespace.SourcePathInfo;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class EclipseTypeSpaceLoader
implements ITypeSpaceLoader,
IResourceChangeListener {
    private List<SourceTypeName> m_types = new ArrayList<SourceTypeName>();
    private IDLTKLanguageToolkit m_toolkit = VjoLanguageToolkit.getDefault();
    private ModelManager m_manager = ModelManager.getModelManager();
    private TypeSpaceRefreshJob m_refreshJob = new TypeSpaceRefreshJob();
    private TypeSpaceReloadJob m_reloadJob = new TypeSpaceReloadJob();
    private List<SourceTypeName> m_changedTypes = new ArrayList<SourceTypeName>();
    private TypeSpaceMgr m_tsmgr = TypeSpaceMgr.getInstance();
    private boolean m_started = false;
    private Map<String, List<String>> m_groupDependency;

    public EclipseTypeSpaceLoader() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this);
        workspace.addResourceChangeListener((IResourceChangeListener)this, 6);
    }

    public List<SourceTypeName> getTypes() {
        this.m_types.clear();
        this.createWorkspaceTypes();
        this.createWorkspaceLibrariesTypes();
        return this.m_types;
    }

    private void createWorkspaceLibrariesTypes() {
        try {
            IScriptProject[] projects;
            Model model = this.m_manager.getModel();
            IScriptProject[] iScriptProjectArray = projects = model.getScriptProjects("org.eclipse.vjet.core.nature");
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IScriptProject project = iScriptProjectArray[n2];
                this.loadLibrariesTypes(project);
                ++n2;
            }
        }
        catch (Exception e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    private void loadLibrariesTypes(IScriptProject project) throws IOException, CoreException {
        IBuildpathEntry[] entries;
        IBuildpathEntry[] iBuildpathEntryArray = entries = project.getResolvedBuildpath(true);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path;
            String strPath;
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            if (entry.getEntryKind() == 1 && CodeassistUtils.isBinaryPath(strPath = (path = entry.getPath()).toString().toLowerCase())) {
                ZipFile jarFile = this.m_manager.getZipFile(path);
                Enumeration<? extends ZipEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry elem = enumeration.nextElement();
                    if (elem.isDirectory()) continue;
                    this.createType(path, jarFile, elem);
                }
            }
            ++n2;
        }
    }

    private void createType(IPath path, ZipFile jarFile, ZipEntry elem) throws IOException {
        Path path2 = new Path(path.segment(0));
        path2 = path2.addTrailingSeparator();
        path2 = path2.append(elem.getName());
        Workspace ws = (Workspace)ResourcesPlugin.getWorkspace();
        IFile file = (IFile)ws.newResource((IPath)path2, 1);
        if (this.isValidFile(file)) {
            byte[] bs = this.getContent(jarFile, elem);
            this.createSourceTypeName(file, bs);
        }
    }

    private byte[] getContent(ZipFile jarFile, ZipEntry elem) throws IOException {
        InputStream stream = jarFile.getInputStream(elem);
        byte[] bs = new byte[stream.available()];
        stream.read(bs);
        stream.close();
        return bs;
    }

    private void createWorkspaceTypes() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            this.createProjectTypes(project);
            ++i;
        }
    }

    private void createProjectTypes(IProject project) {
        if (project.isAccessible()) {
            try {
                IProjectNature nature = project.getNature("org.eclipse.vjet.core.nature");
                if (nature != null) {
                    IResource[] resources = project.members();
                    this.createResourcesTypes(resources);
                }
            }
            catch (CoreException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
        }
    }

    private void createResourcesTypes(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IContainer) {
                IContainer container = (IContainer)resource;
                this.loadResources(container);
            }
            if (resource instanceof IFile) {
                this.createType(resource);
            }
            ++n2;
        }
    }

    private void createType(IResource resource) {
        IFile file = (IFile)resource;
        if (this.isValidFile(file)) {
            SourceTypeName name = this.createSourceTypeName(file);
            this.m_types.add(name);
        }
    }

    private SourceTypeName createSourceTypeName(IFile file) {
        byte[] content = SourceTypeName.EMPTY_CONTENT;
        content = this.getFileContent(file);
        return this.createSourceTypeName(file, content);
    }

    private void refresh(IFile file) {
        try {
            file.refreshLocal(2, null);
        }
        catch (CoreException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    private SourceTypeName createSourceTypeName(IFile file, byte[] bs) {
        String group = file.getProject().getName();
        String source = new String(bs);
        String name = CodeassistUtils.getClassName(file);
        SourceTypeName typeName = new SourceTypeName(group, name, source);
        return typeName;
    }

    private byte[] getFileContent(IFile file) {
        byte[] bs = SourceTypeName.EMPTY_CONTENT;
        try {
            bs = this.doGetFileContent(file);
        }
        catch (IOException e) {
            this.logError(e);
        }
        catch (ResourceException resourceException) {
            this.refresh(file);
            try {
                bs = this.doGetFileContent(file);
            }
            catch (Exception e1) {
                this.logError(e1);
            }
        }
        catch (CoreException e) {
            this.logError((Exception)((Object)e));
        }
        return bs;
    }

    private void logError(Exception e1) {
        DLTKCore.error((String)e1.getMessage(), (Throwable)e1);
    }

    private byte[] doGetFileContent(IFile file) throws CoreException, IOException {
        InputStream stream = file.getContents();
        int available = stream.available();
        byte[] bs = new byte[available];
        stream.read(bs);
        stream.close();
        return bs;
    }

    private boolean isValidFile(IFile file) {
        return this.isValidName(file) && PiggyBackClassPathUtil.isInSourceFolder((IResource)file);
    }

    private boolean isValidName(IFile file) {
        boolean isValid = false;
        try {
            isValid = DLTKContentTypeManager.isValidFileNameForContentType((IDLTKLanguageToolkit)this.m_toolkit, (IPath)file.getLocation());
        }
        catch (Exception e) {
            DLTKCore.error((String)e.getMessage(), (Throwable)e);
        }
        return isValid;
    }

    private void loadResources(IContainer container) {
        try {
            this.createResourcesTypes(container.members());
        }
        catch (CoreException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    public List<SourceTypeName> getTypes(String group) {
        this.m_types.clear();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(group);
        if (project != null) {
            this.createProjectTypes(project);
        }
        return this.m_types;
    }

    public Map<String, List<String>> getGroupDepends() {
        if (this.m_groupDependency != null) {
            return this.m_groupDependency;
        }
        try {
            Thread.sleep(3000L);
            this.updateGroupDepends();
        }
        catch (InterruptedException interruptedException) {}
        return this.m_groupDependency;
    }

    private void updateGroupDepends(IProject project) {
        this.m_groupDependency = new HashMap<String, List<String>>();
        try {
            this.createDepends(this.m_groupDependency, DLTKCore.create((IProject)project));
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
    }

    private void updateGroupDepends() {
        this.m_groupDependency = new HashMap<String, List<String>>();
        Model model = this.m_manager.getModel();
        try {
            IScriptProject[] projects;
            IScriptProject[] iScriptProjectArray = projects = model.getScriptProjects("org.eclipse.vjet.core.nature");
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IScriptProject project = iScriptProjectArray[n2];
                this.createDepends(this.m_groupDependency, project);
                ++n2;
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    private IBuildpathEntry[] createDepends(Map<String, List<String>> groups, IScriptProject project) throws ModelException {
        List<String> list = this.getDependsProjects(groups, project.getElementName());
        IBuildpathEntry[] entries = TypeSpaceBuilder.getSerFileGroupDepends(project, list);
        groups.put(project.getElementName(), list);
        return entries;
    }

    private List<String> getDependsProjects(Map<String, List<String>> groups, String group) {
        List<String> list = groups.get(group);
        if (list == null) {
            list = new ArrayList<String>();
            groups.put(group, list);
        }
        return list;
    }

    public List<SourceTypeName> getChangedTypes() {
        return this.m_changedTypes;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        int type = event.getType();
        IProject project = this.getProject(event);
        if (type == 2 || type == 4) {
            this.processCloseProject(project);
        }
    }

    private IProject getProject(IResourceChangeEvent event) {
        if (event.getDelta() != null && event.getDelta().getAffectedChildren().length > 0 && event.getDelta().getAffectedChildren()[0].getResource() != null) {
            return event.getDelta().getAffectedChildren()[0].getResource().getProject();
        }
        if (event.getResource() != null && event.getResource() instanceof IProject) {
            return event.getResource().getProject();
        }
        return null;
    }

    private void processChanges(IResourceChangeEvent event) {
        IResourceDelta[] resourceDeltas = event.getDelta().getAffectedChildren();
        ArrayList<GroupInfo> info = new ArrayList<GroupInfo>();
        this.m_changedTypes.clear();
        IResourceDelta[] iResourceDeltaArray = resourceDeltas;
        int n = resourceDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta resourceDelta = iResourceDeltaArray[n2];
            IProject project = resourceDelta.getResource().getProject();
            if (project.exists() && project.isOpen()) {
                if (this.m_tsmgr.existGroup(project.getName())) {
                    this.processDelta(resourceDelta);
                } else {
                    this.processAddGroup(info, project);
                }
            }
            ++n2;
        }
        if (!info.isEmpty()) {
            TypeSpaceGroupLoadJob groupLoadJob = new TypeSpaceGroupLoadJob(info);
            groupLoadJob.schedule();
        } else if (!this.m_changedTypes.isEmpty()) {
            TypeSpaceTracer.loadRefreshEvent(this.getChangedTypes());
            this.m_refreshJob.schedule();
        }
    }

    private void processAddGroup(List<GroupInfo> info, IProject project) {
        try {
            Model model = this.m_manager.getModel();
            IScriptProject scriptProject = model.getScriptProject(project.getName());
            if (scriptProject.exists()) {
                this.populateGroupInfos(info, scriptProject, this.getGroupDepends());
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.getMessage(), (Throwable)e);
        }
    }

    public IProject getProjectName(IResourceDelta delta) {
        return delta.getAffectedChildren()[0].getResource().getProject();
    }

    private void processCloseProject(IProject project) {
        String name = project.getName();
        RemoveGroupEvent removeGroupEvent = new RemoveGroupEvent(name, name);
        this.m_tsmgr.processEvent((ISourceEvent)removeGroupEvent);
    }

    public static boolean isBildPathChangedEvent(IResourceDelta delta) {
        boolean isBuildPathCnahgedEvent = false;
        IResource resource = delta.getResource();
        if (resource.getName().equals(".buildpath")) {
            boolean bl = isBuildPathCnahgedEvent = delta.getKind() == 4;
        }
        if (resource instanceof IProject && delta.getAffectedChildren().length == 0) {
            return true;
        }
        if (!isBuildPathCnahgedEvent) {
            IResourceDelta[] deltas;
            IResourceDelta[] iResourceDeltaArray = deltas = delta.getAffectedChildren();
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta resourceDelta = iResourceDeltaArray[n2];
                isBuildPathCnahgedEvent = EclipseTypeSpaceLoader.isBildPathChangedEvent(resourceDelta);
                if (isBuildPathCnahgedEvent) break;
                ++n2;
            }
        }
        return isBuildPathCnahgedEvent;
    }

    public static boolean isBootstrapChangedEvent(IResourceDelta delta) {
        boolean bootstrapPathChange = false;
        IResource resource = delta.getResource();
        if (resource.getName().equals("bootstrap.js")) {
            boolean bl = bootstrapPathChange = delta.getKind() == 4;
        }
        if (!bootstrapPathChange) {
            IResourceDelta[] deltas;
            IResourceDelta[] iResourceDeltaArray = deltas = delta.getAffectedChildren();
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta resourceDelta = iResourceDeltaArray[n2];
                bootstrapPathChange = EclipseTypeSpaceLoader.isBootstrapChangedEvent(resourceDelta);
                if (bootstrapPathChange) break;
                ++n2;
            }
        }
        return bootstrapPathChange;
    }

    private void processDelta(IResourceDelta delta) {
        block9: {
            IResource resource;
            block8: {
                resource = delta.getResource();
                if (!(resource instanceof IFile)) break block8;
                switch (delta.getKind()) {
                    case 4: {
                        if ((delta.getFlags() & 0xFFFCFFFF) != 0) {
                            this.loadFile(delta, resource);
                            break;
                        }
                        break block9;
                    }
                    case 1: {
                        this.loadFile(delta, resource);
                        break;
                    }
                    case 2: {
                        this.loadFile(delta, resource);
                        break;
                    }
                }
                break block9;
            }
            if (PiggyBackClassPathUtil.isInSourceFolder(resource) || resource instanceof IProject) {
                IResourceDelta[] deltas;
                IResourceDelta[] iResourceDeltaArray = deltas = delta.getAffectedChildren();
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta resourceDelta = iResourceDeltaArray[n2];
                    this.processDelta(resourceDelta);
                    ++n2;
                }
            }
        }
    }

    private void loadFile(IResourceDelta delta, IResource resource) {
        IFile file = (IFile)resource;
        if (this.isValidFile(file)) {
            this.loadVjoFile(delta, file);
        }
    }

    private void loadVjoFile(IResourceDelta delta, IFile file) {
        SourceTypeName name = file.exists() ? this.createSourceTypeName(file) : this.createSourceTypeName(file, SourceTypeName.EMPTY_CONTENT);
        String typeName = CodeassistUtils.getClassName(file);
        switch (delta.getKind()) {
            case 1: {
                if (this.m_tsmgr.existType(file.getProject().getName(), typeName)) break;
                name.setAction(1);
                this.m_changedTypes.add(name);
                if (!file.exists()) break;
                this.m_tsmgr.getController().parseAndResolve(name.groupName(), file.getLocation().toFile());
                break;
            }
            case 4: {
                if (!this.m_tsmgr.existType(file.getProject().getName(), typeName)) break;
                name.setAction(4);
                this.m_changedTypes.add(name);
                break;
            }
            case 2: {
                if (!this.m_tsmgr.existType(file.getProject().getName(), typeName)) break;
                name.setAction(2);
                this.m_changedTypes.add(name);
                break;
            }
        }
    }

    private boolean canModify(IResourceDelta delta, IFile file, String typeName) {
        return delta.getKind() != 1 || !this.m_tsmgr.existType(file.getProject().getName(), typeName);
    }

    public int getRefreshJobState() {
        return this.m_refreshJob.getState();
    }

    public int getReloadJobState() {
        return this.m_reloadJob.getState();
    }

    public List<GroupInfo> getGroupInfo() {
        return this.getScriptProjectEntries();
    }

    public List<GroupInfo> getGroupInfo(String group) {
        ArrayList<GroupInfo> info = new ArrayList<GroupInfo>();
        Map<String, List<String>> groupDependency = this.getGroupDepends();
        IScriptProject p = this.m_manager.getModel().getScriptProject(group);
        try {
            this.populateGroupInfos(info, p, groupDependency);
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return info;
    }

    private List<GroupInfo> getScriptProjectEntries() {
        Model model = this.m_manager.getModel();
        ArrayList<GroupInfo> info = new ArrayList<GroupInfo>();
        try {
            IScriptProject[] projects = model.getScriptProjects("org.eclipse.vjet.core.nature");
            this.populateGroupInfos(info, projects);
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return info;
    }

    private void populateGroupInfos(List<GroupInfo> info, IScriptProject[] projects) throws ModelException {
        Map<String, List<String>> groupDependency = this.getGroupDepends();
        IScriptProject[] iScriptProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IScriptProject project = iScriptProjectArray[n2];
            this.populateGroupInfos(info, project, groupDependency);
            ++n2;
        }
    }

    private void populateGroupInfos(List<GroupInfo> info, IScriptProject project, Map<String, List<String>> groupDependency) throws ModelException {
        if (!PiggyBackClassPathUtil.ifScriptProjectInitializedFromJavaProject(project)) {
            PiggyBackClassPathUtil.initializeScriptProjectFromJavProject(project);
        }
        ArrayList<String> classPaths = new ArrayList<String>();
        List<URL> urls = PiggyBackClassPathUtil.getProjectDependantJars_DLTK(project);
        ArrayList<String> groupDepends = new ArrayList<String>();
        TypeSpaceBuilder.getSerFileGroupDepends(project, groupDepends);
        IBuildpathEntry bootstrapPath = TypeSpaceBuilder.getBootstrapDir(project);
        for (URL u : urls) {
            File file = new File(u.getFile());
            String fileName = file.getName();
            if (this.m_tsmgr.existGroup(fileName) || classPaths.contains(fileName)) continue;
            SourcePathInfo srcPathInfo = new SourcePathInfo();
            srcPathInfo.addSourcePath(file.getPath());
            info.add(new GroupInfo(file.getName(), file.getAbsolutePath(), srcPathInfo, null, groupDependency.get(file.getName())));
            classPaths.add(fileName);
            System.out.println("ScriptProject<" + project.getElementName() + "> depends on :" + u);
        }
        SourcePathInfo srcPathInfo = PiggyBackClassPathUtil.getProjectSrcPath_DLTK(project);
        srcPathInfo.getSourcePaths();
        String name = project.getProject().getName();
        File groupPath = project.getProject().getLocation().toFile();
        ArrayList<String> bootstrapDirs = new ArrayList<String>();
        if (bootstrapPath != null) {
            String portableString = "";
            portableString = this.getRelativeProjectPath(project, bootstrapPath);
            bootstrapDirs.add(portableString);
        }
        info.add(new GroupInfo(name, groupPath.getAbsolutePath(), srcPathInfo, classPaths, groupDependency.get(name), bootstrapDirs));
    }

    private String getRelativeProjectPath(IScriptProject project, IBuildpathEntry bootstrap) {
        String name = project.getElementName();
        String bootstrapPath = bootstrap.getPath().toPortableString();
        if (bootstrapPath.lastIndexOf(name) != -1) {
            bootstrapPath = bootstrapPath.equals(name) ? "" : bootstrapPath.substring(bootstrapPath.indexOf(name) + name.length());
        }
        return bootstrapPath;
    }

    public boolean isStarted() {
        return this.m_started;
    }

    public void setStarted(boolean isStarted) {
        this.m_started = isStarted;
    }
}

