/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.xml;

import java.io.IOException;
import java.io.Writer;

public interface IIndenter {
    public static final IIndenter COMPACT = new IIndenter(){

        @Override
        public void indent(Writer writer, int level) {
        }
    };

    public void indent(Writer var1, int var2) throws IOException;

    public static class LineBreak
    implements IIndenter {
        private int numWrites = 0;

        @Override
        public void indent(Writer writer, int level) throws IOException {
            if (this.numWrites++ > 0) {
                writer.write(10);
            }
        }
    }

    public static class Pretty
    implements IIndenter {
        private int numWrites = 0;

        @Override
        public void indent(Writer writer, int level) throws IOException {
            if (this.numWrites++ > 0) {
                writer.write(10);
            }
            int i = 0;
            while (i < level) {
                writer.write(32);
                ++i;
            }
        }
    }
}

