/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.introspect;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.vjet.dsf.common.trace.introspect.DefaultTraceIntrospector;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.common.xml.XmlEncoder;

public class JavaBeanTraceIntrospector
extends DefaultTraceIntrospector {
    private static JavaBeanTraceIntrospector s_default = new JavaBeanTraceIntrospector();
    private static Logger s_logger = Logger.getLogger(JavaBeanTraceIntrospector.class.getName());
    private static final String[] getterPrefixes = new String[]{"get", "is", "has"};
    private static final String GetterException = "getter-exception";
    protected static final List<String> s_terminationTypes = new ArrayList<String>(10);
    protected static final List<String> s_terminationPkgs;

    static {
        s_terminationTypes.add("java.lang.Class");
        s_terminationTypes.add("java.util.Locale");
        s_terminationPkgs = new ArrayList<String>(10);
        s_terminationPkgs.add("java.lang.reflect");
        s_terminationPkgs.add("org.eclipse.vjet.dsf.dom");
        s_terminationPkgs.add("org.eclipse.vjet.dsf.html.dom");
        s_terminationPkgs.add("org.eclipse.vjet.dsf.resource");
        s_terminationPkgs.add("com.ebay.shared.resources");
    }

    public static JavaBeanTraceIntrospector getDefault() {
        return s_default;
    }

    public JavaBeanTraceIntrospector() {
    }

    public JavaBeanTraceIntrospector(int maxDepth) {
        if (maxDepth > 0 && maxDepth < 10) {
            this.m_maxDepth = maxDepth;
        }
    }

    @Override
    public void writeState(Object obj, IXmlStreamWriter writer) {
        try {
            this.m_objs.clear();
            this.writeObjectValue(obj, writer, 0);
        }
        catch (Throwable t) {
            s_logger.log(Level.SEVERE, "could not write ", t);
        }
    }

    private boolean isTerminated(Object obj) {
        Class<?> type = obj.getClass();
        if (type.getPackage() != null) {
            for (String pkg : s_terminationPkgs) {
                if (!type.getPackage().getName().startsWith(pkg)) continue;
                return true;
            }
        }
        return false;
    }

    private String getClassTag(Class clz) {
        String s = clz.getSimpleName();
        while (s == null || "".equals(s)) {
            Class<?> enclosingClass = clz.getEnclosingClass();
            if (enclosingClass == null) break;
            s = enclosingClass.getSimpleName();
        }
        if ("".equals(s)) {
            s = null;
        }
        return s;
    }

    private void writeObjectValue(Object obj, IXmlStreamWriter writer, int curDepth) throws IntrospectionException {
        Object it;
        if (obj == null) {
            if (curDepth <= 0) {
                writer.writeStartElement("NULL");
                writer.writeEndElement();
            } else {
                writer.writeRaw("null");
            }
            return;
        }
        Class<?> type = obj.getClass();
        if (curDepth >= this.m_maxDepth) {
            writer.writeStartElement("CHILD_CUTOFF");
            writer.writeEndElement();
            return;
        }
        if (this.isTerminated(obj)) {
            String s = this.getClassTag(type);
            if (s == null) {
                return;
            }
            writer.writeStartElement(s);
            writer.writeCharacters("INTROSPECT_CUTOFF");
            writer.writeEndElement();
            return;
        }
        if (type.isPrimitive() || s_primitiveTypes.contains(type) || s_terminationTypes.contains(type.getName())) {
            writer.writeStartElement(type.getSimpleName());
            writer.writeCharacters(XmlEncoder.encode(obj.toString()));
            writer.writeEndElement();
            return;
        }
        if (this.m_objs.contains(obj)) {
            writer.writeRaw("CROSS_REF");
            return;
        }
        this.m_objs.add(obj);
        if (obj.getClass().isArray()) {
            writer.writeStartElement("Array");
        } else {
            String s = this.getClassTag(type);
            if (s == null) {
                return;
            }
            writer.writeStartElement(s);
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            writer.writeAttribute("size", String.valueOf(len));
            int i = 0;
            while (i < len) {
                if (i > 50) {
                    writer.writeCharacters("...");
                    break;
                }
                Object entry = Array.get(obj, i);
                this.writeObjectValue(entry, writer, curDepth + 1);
                ++i;
            }
        } else if (Iterable.class.isAssignableFrom(type)) {
            it = (Iterable)obj;
            if (List.class.isAssignableFrom(type)) {
                int size = ((List)obj).size();
                writer.writeAttribute("size", String.valueOf(size));
            }
            int counter = 0;
            Iterator iterator = it.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (counter > 50) {
                    writer.writeCharacters("...");
                    break;
                }
                this.writeObjectValue(item, writer, curDepth + 1);
                ++counter;
            }
        } else if (Map.class.isAssignableFrom(type)) {
            Map map = (Map)obj;
            int size = map.size();
            int counter = 0;
            writer.writeAttribute("size", String.valueOf(size));
            for (Map.Entry entry : map.entrySet()) {
                if (counter > 50) {
                    writer.writeCharacters("...");
                    break;
                }
                writer.writeStartElement("Entry");
                this.writeObjectValue(entry.getKey(), writer, curDepth + 1);
                this.writeObjectValue(entry.getValue(), writer, curDepth + 1);
                writer.writeEndElement();
                ++counter;
            }
        } else if (Iterator.class.isAssignableFrom(type)) {
            it = (Iterator)obj;
            int counter = 0;
            while (it.hasNext()) {
                Object entry = it.next();
                if (counter > 50) {
                    writer.writeCharacters("...");
                    break;
                }
                this.writeObjectValue(entry, writer, curDepth + 1);
                ++counter;
            }
        } else if (Enumeration.class.isAssignableFrom(type)) {
            it = (Enumeration)obj;
            int counter = 0;
            while (it.hasMoreElements()) {
                Object entry = it.nextElement();
                if (counter > 50) {
                    writer.writeCharacters("...");
                    break;
                }
                this.writeObjectValue(entry, writer, curDepth + 1);
                ++counter;
            }
        } else {
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass(), Object.class);
            MethodDescriptor[] mdArray = beanInfo.getMethodDescriptors();
            if (mdArray != null) {
                MethodDescriptor[] methodDescriptorArray = mdArray;
                int n = mdArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object returnObj;
                    MethodDescriptor md = methodDescriptorArray[n2];
                    Method m = md.getMethod();
                    Class<?>[] paramTypes = m.getParameterTypes();
                    if ((paramTypes == null || paramTypes.length <= 0) && this.isGetterMethod(m.getName()) && Modifier.isPublic(m.getModifiers()) && !((returnObj = this.doInvocation(writer, obj, m, null)) instanceof Throwable)) {
                        writer.writeStartElement(m.getName());
                        this.writeObjectValue(returnObj, writer, curDepth + 1);
                        writer.writeEndElement();
                    }
                    ++n2;
                }
            }
        }
        writer.writeEndElement();
    }

    public Object doInvocation(IXmlStreamWriter writer, Object obj, Method m, Object[] params) {
        Object returnObj = null;
        try {
            returnObj = m.invoke(obj, params);
        }
        catch (IllegalAccessException e1) {
            returnObj = e1;
        }
        catch (Exception e2) {
            returnObj = e2;
            writer.writeStartElement(m.getName());
            String err = "getter-exception:" + e2.toString();
            writer.writeRaw(err);
            writer.writeEndElement();
        }
        return returnObj;
    }

    private boolean isGetterMethod(String methodName) {
        int i = 0;
        while (i < getterPrefixes.length) {
            if (methodName.toLowerCase().startsWith(getterPrefixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

