/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.trace.filter;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.vjet.dsf.common.exceptions.DsfExceptionHelper;
import org.eclipse.vjet.dsf.common.trace.event.TraceType;

public final class TraceTypeMapping
implements Cloneable {
    public static final TraceTypeMapping DEFAULT = new TraceTypeMapping();
    private final Map<TraceType, Level> m_levelMap = new HashMap<TraceType, Level>(10);

    static {
        DEFAULT.setMapping(TraceType.ENTER_METHOD, Level.FINE);
        DEFAULT.setMapping(TraceType.EXIT_METHOD, Level.FINE);
        DEFAULT.setMapping(TraceType.OBJECT_TYPE, Level.FINER);
        DEFAULT.setMapping(TraceType.OBJECT_STATE, Level.FINER);
    }

    public TraceTypeMapping clone() {
        TraceTypeMapping copy = new TraceTypeMapping();
        for (Map.Entry<TraceType, Level> entry : this.m_levelMap.entrySet()) {
            copy.setMapping(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public void setMapping(TraceType type, Level level) {
        if (type == null) {
            DsfExceptionHelper.chuck("type is null");
        }
        if (level == null) {
            DsfExceptionHelper.chuck("level is null");
        }
        this.m_levelMap.put(type, level);
    }

    public Level getLevel(TraceType type) {
        if (type == null) {
            DsfExceptionHelper.chuck("type is null");
        }
        return this.m_levelMap.get(type);
    }
}

