/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.parser.bootstrap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.generate.JsrGenerator;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jstojava.parser.bootstrap.Utils;
import org.eclipse.vjet.vjo.lib.LibManager;

public class GenJsNativeJsr {
    private static final String COM_EBAY_JSNATIVE_JSR = "org.eclipse.vjet.dsf.jsnative.jsr";

    public static void main(String[] args) throws FileNotFoundException {
        String outputDir = args[0];
        IJstLib lib = LibManager.getInstance().getJsNativeGlobalLib();
        List types = lib.getAllTypes(true);
        JstCache.getInstance().addLib(lib);
        for (IJstType type : types) {
            try {
                JstPackage package1 = type.getPackage();
                if (package1 == null) {
                    package1 = new JstPackage(COM_EBAY_JSNATIVE_JSR);
                }
                IJstType type2 = type;
                JstType type3 = null;
                if (type2 instanceof JstType) {
                    type3 = (JstType)type2;
                    type3.setImpliedImport(true);
                    type3.clearMixins();
                    if (type3.getName().contains("Function")) {
                        type3.removeExtend(type3.getExtend());
                        type3.removeMethod("call", true);
                        type3.removeMethod("apply", true);
                        type3.removeProperty("arguments", true);
                        type3.removeProperty("prototype", true);
                        type3.removeProperty("caller", true);
                        type3.removeProperty("length", true);
                        type3.removeProperty("name", true);
                    }
                }
                if ((type3 = Utils.removeGuts(type3)).getPackage() != null) continue;
                File jsrFile = GenJsNativeJsr.createJsrFile(outputDir, package1, type.getSimpleName());
                PrintWriter pw2 = new PrintWriter(jsrFile);
                pw2.append("package " + package1.getName() + ";");
                JsrGenerator gen2 = Utils.createGenerator(pw2);
                gen2.writeJsr((IJstType)type3);
                pw2.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static File createJsrFile(String outputDir, JstPackage package1, String simpleName) {
        File dir;
        String packageURI = "";
        if (package1 != null) {
            packageURI = package1.getName().replace('.', File.separatorChar);
        }
        if (!(dir = new File(String.valueOf(outputDir) + File.separatorChar + packageURI + File.separatorChar)).exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, String.valueOf(simpleName) + "Jsr.java");
        return file;
    }

    private static File createFile(String outputDir, JstPackage package1, String simpleName) {
        File dir;
        String packageURI = "";
        if (package1 != null) {
            packageURI = package1.getName().replace('.', File.separatorChar);
        }
        if (!(dir = new File(String.valueOf(outputDir) + File.separatorChar + packageURI + File.separatorChar)).exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, String.valueOf(simpleName) + ".js");
        return file;
    }
}

