/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.stmt;

import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.token.IBoolExpr;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class WhileStmt
extends BlockStmt
implements IStmt {
    private static final long serialVersionUID = 1L;
    private IBoolExpr m_condition;

    public WhileStmt setCondition(IBoolExpr condition) {
        assert (condition != null) : "condition cannot be null";
        this.removeChild(this.m_condition);
        this.addChild(condition);
        this.m_condition = condition;
        return this;
    }

    public IBoolExpr getCondition() {
        return this.m_condition;
    }

    public WhileStmt addStmt(IStmt stmt) {
        assert (stmt != null) : "stmt cannot be null";
        this.getBody().addStmt(stmt);
        return this;
    }

    @Override
    public String toStmtText() {
        StringBuilder sb = new StringBuilder("while (");
        if (this.m_condition != null) {
            sb.append(this.m_condition.toBoolExprText());
        }
        sb.append(")");
        sb.append(this.getBody().toBlockText());
        return sb.toString();
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return this.toStmtText();
    }
}

