/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst;

import java.io.Serializable;
import org.eclipse.vjet.dsf.common.Z;

public class JstSource
implements Serializable {
    private static final long serialVersionUID = 4870713462710132633L;
    public static final int JAVA = 0;
    public static final int VJO = 1;
    public static final int JS = 2;
    public static final String ARG = "args";
    private int m_type;
    private String m_name;
    private transient IBinding m_binding;
    private int m_row;
    private int m_col;
    private int m_length;
    private int m_endOffset;
    private int m_startOffset;

    public JstSource(IBinding binding) {
        this(0, binding, -1, -1);
    }

    public JstSource(int row, int col) {
        this(0, null, row, col);
    }

    public JstSource(IBinding binding, int row, int col) {
        this(0, binding, row, col);
    }

    public JstSource(int type, IBinding binding, int row, int col) {
        this(type, binding, row, col, 0, 0, 0);
    }

    public JstSource(int type, int row, int col, int length, int startOffset, int endOffset) {
        this(type, null, row, col, length, startOffset, endOffset);
    }

    public JstSource(int type, IBinding binding, int row, int col, int length, int startOffset, int endOffset) {
        this.m_type = type;
        this.m_binding = binding;
        this.m_row = row;
        this.m_col = col;
        this.m_length = length;
        this.m_startOffset = startOffset;
        this.m_endOffset = endOffset;
    }

    public int getType() {
        return this.m_type;
    }

    public int getLength() {
        return this.m_length;
    }

    public int getStartOffSet() {
        return this.m_startOffset;
    }

    public int getEndOffSet() {
        return this.m_endOffset;
    }

    public IBinding getBinding() {
        return this.m_binding;
    }

    public void setBinding(IBinding binding) {
        this.m_binding = binding;
    }

    public int getRow() {
        return this.m_row;
    }

    public int getColumn() {
        return this.m_col;
    }

    public String toString() {
        Z z = new Z();
        z.format("m_type", this.m_type);
        z.format("m_name", (Object)this.m_name);
        if (this.m_binding != null) {
            z.format("m_binding", (Object)this.m_binding.getClass().getName());
        } else {
            z.format("m_binding", null);
        }
        z.format("m_row", this.m_row);
        z.format("m_col", this.m_col);
        z.format("m_startOffset", this.m_startOffset);
        z.format("m_endOffset", this.m_endOffset);
        return z.toString();
    }

    public static interface IBinding {
        public String getName();

        public String toText();
    }
}

