/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.vjo;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.jsgen.shared.generate.CodeStyle;
import org.eclipse.vjet.dsf.jsgen.shared.generate.SourceGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.BodyGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.ExprGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.FragmentGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorCtx;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.JsClientGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.JsCoreGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.JsDocGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.MtdGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.StmtGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.VjoGenerator;

public class GeneratorProvider {
    private Map<Class, SourceGenerator> m_generators = new HashMap<Class, SourceGenerator>(5);

    public GeneratorProvider(GeneratorCtx ctx) {
        assert (ctx != null) : "ctx cannot be null";
        this.m_generators.put(JsCoreGenerator.class, new JsCoreGenerator(ctx));
        this.m_generators.put(JsClientGenerator.class, new JsClientGenerator(ctx));
        this.m_generators.put(VjoGenerator.class, new VjoGenerator(ctx));
        this.m_generators.put(MtdGenerator.class, new MtdGenerator(ctx));
        this.m_generators.put(BodyGenerator.class, new BodyGenerator(ctx));
        this.m_generators.put(StmtGenerator.class, new StmtGenerator(ctx));
        this.m_generators.put(ExprGenerator.class, new ExprGenerator(ctx));
        this.m_generators.put(FragmentGenerator.class, new FragmentGenerator(ctx));
        this.m_generators.put(JsDocGenerator.class, new JsDocGenerator(ctx));
    }

    public void setStyle(CodeStyle style) {
        for (SourceGenerator generator : this.m_generators.values()) {
            generator.setStyle(style);
        }
    }

    public void setNewline(String newline) {
        for (SourceGenerator generator : this.m_generators.values()) {
            generator.setNewline(newline);
        }
    }

    public SourceGenerator getGenerator(Class srcType) {
        assert (srcType != null) : "srcType cannot be null";
        return this.m_generators.get(srcType);
    }

    public JsCoreGenerator getJsCoreGenerator() {
        return (JsCoreGenerator)this.getGenerator(JsCoreGenerator.class);
    }

    public JsClientGenerator getJsClientGenerator() {
        return (JsClientGenerator)this.getGenerator(JsClientGenerator.class);
    }

    public VjoGenerator getTypeGenerator() {
        return (VjoGenerator)this.getGenerator(VjoGenerator.class);
    }

    public MtdGenerator getMtdGenerator() {
        return (MtdGenerator)this.getGenerator(MtdGenerator.class);
    }

    public BodyGenerator getBodyGenerator() {
        return (BodyGenerator)this.getGenerator(BodyGenerator.class);
    }

    public StmtGenerator getStmtGenerator() {
        return (StmtGenerator)this.getGenerator(StmtGenerator.class);
    }

    public ExprGenerator getExprGenerator() {
        return (ExprGenerator)this.getGenerator(ExprGenerator.class);
    }

    public FragmentGenerator getFragmentGenerator() {
        return (FragmentGenerator)this.getGenerator(FragmentGenerator.class);
    }

    public JsDocGenerator getJsDocGenerator() {
        return (JsDocGenerator)this.getGenerator(JsDocGenerator.class);
    }
}

