/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationRuntimeException;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.VjoConstants;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.EVjoSymbolType;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.IVjoSymbol;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.VjoSymbol;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.VjoSymbolTable;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;

public class JstTypeSymbolLoadUtil {
    private static IJstMethod s_valuesMtd;
    private static IJstType s_vjoClazzType;

    public static void loadCompleteJstTypeSymbols(VjoValidationCtx ctx, IJstType jstType) {
        IJstType typeSpaceType = ctx.getTypeSpaceType(jstType);
        if (JstTypeSymbolLoadUtil.hasCircularInheritanceChain(ctx, typeSpaceType, new HashSet<IJstType>())) {
            throw new VjoValidationRuntimeException(new IllegalArgumentException("circular inheritance chain detected: " + typeSpaceType.getName()));
        }
        JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, typeSpaceType, typeSpaceType, new HashSet<DuplicateLoadProtectionKey>());
    }

    public static void unloadCompleteJstTypeSymbols(VjoValidationCtx ctx, IJstType jstType) {
        IJstType typeSpaceType = ctx.getTypeSpaceType(jstType);
        if (JstTypeSymbolLoadUtil.hasCircularInheritanceChain(ctx, typeSpaceType, new HashSet<IJstType>())) {
            throw new VjoValidationRuntimeException(new IllegalArgumentException("circular inheritance chain detected: " + typeSpaceType.getName()));
        }
        JstTypeSymbolLoadUtil.recursiveUnloadCompleteJstTypesSymbols(ctx, typeSpaceType, typeSpaceType, new HashSet<IJstType>());
    }

    public static void loadCompleteJstTypeSymbols(VjoValidationCtx ctx, IJstType jstType, int modifier) {
        IJstType typeSpaceType = ctx.getTypeSpaceType(jstType);
        if (JstTypeSymbolLoadUtil.hasCircularInheritanceChain(ctx, typeSpaceType, new HashSet<IJstType>())) {
            throw new VjoValidationRuntimeException(new IllegalArgumentException("circular inheritance chain detected: " + typeSpaceType.getName()));
        }
        JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, typeSpaceType, typeSpaceType, modifier, new HashSet<DuplicateLoadProtectionKey>());
    }

    public static void unloadCompleteJstTypeSymbols(VjoValidationCtx ctx, IJstType jstType, int modifier) {
        IJstType typeSpaceType = ctx.getTypeSpaceType(jstType);
        if (JstTypeSymbolLoadUtil.hasCircularInheritanceChain(ctx, typeSpaceType, new HashSet<IJstType>())) {
            throw new VjoValidationRuntimeException(new IllegalArgumentException("circular inheritance chain detected: " + typeSpaceType.getName()));
        }
        JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, typeSpaceType, typeSpaceType, modifier, new HashSet<DuplicateLoadProtectionKey>());
    }

    private static boolean hasCircularInheritanceChain(VjoValidationCtx ctx, IJstType root, Set<IJstType> protect) {
        IJstType rootInTypeSpace = ctx.getTypeSpaceType(root);
        if (protect.contains(rootInTypeSpace)) {
            return true;
        }
        if (rootInTypeSpace.getExtendsRef().size() == 0) {
            return false;
        }
        protect.add(rootInTypeSpace);
        for (IJstType ext : rootInTypeSpace.getExtends()) {
            if (!JstTypeSymbolLoadUtil.hasCircularInheritanceChain(ctx, ext, protect)) continue;
            return true;
        }
        return false;
    }

    private static void recursiveLoadCompleteJstTypesSymbols(VjoValidationCtx ctx, IJstType scope, IJstType jstType, Set<DuplicateLoadProtectionKey> dupProtect) {
        DuplicateLoadProtectionKey dupKey = new DuplicateLoadProtectionKey(scope, jstType, 1);
        if (dupProtect.contains(dupKey)) {
            return;
        }
        dupProtect.add(dupKey);
        HashSet<String> dupNameProtect = new HashSet<String>();
        for (IJstType extendType : jstType.getExtends()) {
            extendType = ctx.getTypeSpaceType(extendType);
            dupNameProtect.add(extendType.getName());
            if (jstType.isInterface() && !extendType.isInterface()) continue;
            JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, scope, extendType, 4, dupProtect);
            JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, extendType, extendType, 12, dupProtect);
        }
        for (IJstType satisfyType : jstType.getSatisfies()) {
            satisfyType = ctx.getTypeSpaceType(satisfyType);
            dupNameProtect.add(satisfyType.getName());
            if (!satisfyType.isInterface()) continue;
            JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, scope, satisfyType, 1, dupProtect);
        }
        for (IJstType expectType : jstType.getExpects()) {
            expectType = ctx.getTypeSpaceType(expectType);
            dupNameProtect.add(expectType.getName());
            if (!expectType.isInterface()) continue;
            JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, scope, expectType, 1, dupProtect);
        }
        for (IJstTypeReference mixinTypeRef : jstType.getMixinsRef()) {
            IJstType mixinType = mixinTypeRef.getReferencedType();
            if (mixinType == null) continue;
            mixinType = ctx.getTypeSpaceType(mixinType);
            dupNameProtect.add(mixinType.getName());
            JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, scope, mixinType, 12, dupProtect);
        }
        for (IJstType importedType : jstType.getImports()) {
            IVjoSymbol instancePropertySymbol;
            if (dupNameProtect.contains((importedType = ctx.getTypeSpaceType(importedType)).getName())) continue;
            dupNameProtect.add(importedType.getName());
            for (IJstProperty instanceProperty : importedType.getAllPossibleProperties(true, false)) {
                if (!JstTypeSymbolLoadUtil.isDefault(instanceProperty.getModifiers(), instanceProperty) || (instancePropertySymbol = ctx.getSymbolTable().getSymbolInScope((IJstNode)importedType, instanceProperty.getName().getName(), EVjoSymbolType.INSTANCE_VARIABLE)) == null) continue;
                instancePropertySymbol.setVisible(JstTypeSymbolLoadUtil.withinSamePackage(jstType.getOwnerType(), importedType.getOwnerType()));
            }
            for (IJstProperty staticProperty : importedType.getAllPossibleProperties(false, false)) {
                if (!JstTypeSymbolLoadUtil.isDefault(staticProperty.getModifiers(), staticProperty) || (instancePropertySymbol = ctx.getSymbolTable().getSymbolInScope((IJstNode)importedType, staticProperty.getName().getName(), EVjoSymbolType.INSTANCE_VARIABLE)) == null) continue;
                instancePropertySymbol.setVisible(JstTypeSymbolLoadUtil.withinSamePackage(jstType.getOwnerType(), importedType.getOwnerType()));
            }
            for (IJstMethod instanceMethod : importedType.getMethods(true, false)) {
                if (!JstTypeSymbolLoadUtil.isDefault(instanceMethod.getModifiers(), instanceMethod) || (instancePropertySymbol = ctx.getSymbolTable().getSymbolInScope((IJstNode)importedType, instanceMethod.getName().getName(), EVjoSymbolType.INSTANCE_VARIABLE)) == null) continue;
                instancePropertySymbol.setVisible(JstTypeSymbolLoadUtil.withinSamePackage(jstType.getOwnerType(), importedType.getOwnerType()));
            }
            for (IJstMethod staticMethod : importedType.getMethods(false, false)) {
                if (!JstTypeSymbolLoadUtil.isDefault(staticMethod.getModifiers(), staticMethod) || (instancePropertySymbol = ctx.getSymbolTable().getSymbolInScope((IJstNode)importedType, staticMethod.getName().getName(), EVjoSymbolType.INSTANCE_VARIABLE)) == null) continue;
                instancePropertySymbol.setVisible(JstTypeSymbolLoadUtil.withinSamePackage(jstType.getOwnerType(), importedType.getOwnerType()));
            }
        }
        JstTypeSymbolLoadUtil.loadSingleJstTypeSymbols(ctx, (IJstNode)scope, dupProtect, jstType, 2, null);
    }

    private static void recursiveUnloadCompleteJstTypesSymbols(VjoValidationCtx ctx, IJstType scope, IJstType jstType, Set<IJstType> dupProtect) {
        if (dupProtect.contains(jstType)) {
            return;
        }
        dupProtect.add(jstType);
        for (IJstType extendType : jstType.getExtends()) {
            extendType = ctx.getTypeSpaceType(extendType);
            JstTypeSymbolLoadUtil.recursiveUnloadCompleteJstTypesSymbols(ctx, scope, extendType, 4, dupProtect);
            JstTypeSymbolLoadUtil.recursiveUnloadCompleteJstTypesSymbols(ctx, extendType, extendType, 4, dupProtect);
        }
        for (IJstType satisfyType : jstType.getSatisfies()) {
            if (!(satisfyType = ctx.getTypeSpaceType(satisfyType)).isInterface()) continue;
            JstTypeSymbolLoadUtil.recursiveUnloadCompleteJstTypesSymbols(ctx, scope, satisfyType, 4, dupProtect);
        }
        for (IJstTypeReference mixinTypeRef : jstType.getMixinsRef()) {
            IJstType mixinType = mixinTypeRef.getReferencedType();
            if (mixinType == null) continue;
            mixinType = ctx.getTypeSpaceType(mixinType);
            JstTypeSymbolLoadUtil.recursiveUnloadCompleteJstTypesSymbols(ctx, scope, mixinType, 4, dupProtect);
        }
        JstTypeSymbolLoadUtil.unloadSingleJstTypeSymbols(ctx, scope, jstType, 4);
    }

    private static void recursiveLoadCompleteJstTypesSymbols(VjoValidationCtx ctx, IJstType scope, IJstType jstType, int modifier, Set<DuplicateLoadProtectionKey> dupProtect) {
        DuplicateLoadProtectionKey dupKey = new DuplicateLoadProtectionKey(scope, jstType, 1);
        if (dupProtect.contains(dupKey)) {
            return;
        }
        dupProtect.add(dupKey);
        HashSet<String> dupNameProtect = new HashSet<String>();
        for (IJstType extendType : jstType.getExtends()) {
            extendType = ctx.getTypeSpaceType(extendType);
            dupNameProtect.add(extendType.getName());
            if (jstType.isInterface() && !extendType.isInterface()) continue;
            JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, scope, extendType, modifier & 0xFFFFFFF7, dupProtect);
            JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, extendType, extendType, modifier | 8, dupProtect);
        }
        for (IJstType satisfyType : jstType.getSatisfies()) {
            satisfyType = ctx.getTypeSpaceType(satisfyType);
            dupNameProtect.add(satisfyType.getName());
            if (!satisfyType.isInterface()) continue;
            JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, scope, satisfyType, modifier & 0xFFFFFFF7, dupProtect);
        }
        for (IJstType expectType : jstType.getExpects()) {
            expectType = ctx.getTypeSpaceType(expectType);
            dupNameProtect.add(expectType.getName());
            if (!expectType.isInterface()) continue;
            JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, scope, expectType, modifier & 0xFFFFFFF7, dupProtect);
        }
        for (IJstTypeReference mixinTypeRef : jstType.getMixinsRef()) {
            IJstType mixinType = mixinTypeRef.getReferencedType();
            if (mixinType == null) continue;
            mixinType = ctx.getTypeSpaceType(mixinType);
            dupNameProtect.add(mixinType.getName());
            JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, scope, mixinType, modifier | 8, dupProtect);
        }
        for (IJstType importedType : jstType.getImports()) {
            IVjoSymbol instancePropertySymbol;
            if (dupNameProtect.contains((importedType = ctx.getTypeSpaceType(importedType)).getName())) continue;
            dupNameProtect.add(importedType.getName());
            for (IJstProperty instanceProperty : importedType.getAllPossibleProperties(true, false)) {
                if (!JstTypeSymbolLoadUtil.isDefault(instanceProperty.getModifiers(), instanceProperty) || (instancePropertySymbol = ctx.getSymbolTable().getSymbolInScope((IJstNode)importedType, instanceProperty.getName().getName(), EVjoSymbolType.INSTANCE_VARIABLE)) == null) continue;
                instancePropertySymbol.setVisible(JstTypeSymbolLoadUtil.withinSamePackage(jstType.getOwnerType(), importedType.getOwnerType()));
            }
            for (IJstProperty staticProperty : importedType.getAllPossibleProperties(false, false)) {
                if (!JstTypeSymbolLoadUtil.isDefault(staticProperty.getModifiers(), staticProperty) || (instancePropertySymbol = ctx.getSymbolTable().getSymbolInScope((IJstNode)importedType, staticProperty.getName().getName(), EVjoSymbolType.INSTANCE_VARIABLE)) == null) continue;
                instancePropertySymbol.setVisible(JstTypeSymbolLoadUtil.withinSamePackage(jstType.getOwnerType(), importedType.getOwnerType()));
            }
            for (IJstMethod instanceMethod : importedType.getMethods(true, false)) {
                if (!JstTypeSymbolLoadUtil.isDefault(instanceMethod.getModifiers(), instanceMethod) || (instancePropertySymbol = ctx.getSymbolTable().getSymbolInScope((IJstNode)importedType, instanceMethod.getName().getName(), EVjoSymbolType.INSTANCE_VARIABLE)) == null) continue;
                instancePropertySymbol.setVisible(JstTypeSymbolLoadUtil.withinSamePackage(jstType.getOwnerType(), importedType.getOwnerType()));
            }
            for (IJstMethod staticMethod : importedType.getMethods(false, false)) {
                if (!JstTypeSymbolLoadUtil.isDefault(staticMethod.getModifiers(), staticMethod) || (instancePropertySymbol = ctx.getSymbolTable().getSymbolInScope((IJstNode)importedType, staticMethod.getName().getName(), EVjoSymbolType.INSTANCE_VARIABLE)) == null) continue;
                instancePropertySymbol.setVisible(JstTypeSymbolLoadUtil.withinSamePackage(jstType.getOwnerType(), importedType.getOwnerType()));
            }
        }
        JstTypeSymbolLoadUtil.loadSingleJstTypeSymbols(ctx, (IJstNode)scope, dupProtect, jstType, modifier, null);
    }

    private static void recursiveUnloadCompleteJstTypesSymbols(VjoValidationCtx ctx, IJstType scope, IJstType jstType, int modifier, Set<IJstType> dupProtect) {
        if (dupProtect.contains(jstType)) {
            return;
        }
        dupProtect.add(jstType);
        for (IJstType extendType : jstType.getExtends()) {
            extendType = ctx.getTypeSpaceType(extendType);
            JstTypeSymbolLoadUtil.recursiveUnloadCompleteJstTypesSymbols(ctx, scope, extendType, modifier, dupProtect);
            JstTypeSymbolLoadUtil.recursiveUnloadCompleteJstTypesSymbols(ctx, extendType, extendType, modifier, dupProtect);
        }
        for (IJstType satisfyType : jstType.getSatisfies()) {
            satisfyType = ctx.getTypeSpaceType(satisfyType);
            JstTypeSymbolLoadUtil.recursiveUnloadCompleteJstTypesSymbols(ctx, scope, satisfyType, modifier, dupProtect);
        }
        for (IJstTypeReference mixinTypeRef : jstType.getMixinsRef()) {
            IJstType mixinType = mixinTypeRef.getReferencedType();
            if (mixinType == null) continue;
            mixinType = ctx.getTypeSpaceType(mixinType);
            JstTypeSymbolLoadUtil.recursiveUnloadCompleteJstTypesSymbols(ctx, scope, mixinType, modifier, dupProtect);
        }
        JstTypeSymbolLoadUtil.unloadSingleJstTypeSymbols(ctx, scope, jstType, modifier);
    }

    public static void loadSingleJstTypeSymbols(VjoValidationCtx ctx, IJstType jstType) {
        IJstType typeSpaceType = ctx.getTypeSpaceType(jstType);
        JstTypeSymbolLoadUtil.loadSingleJstTypeSymbols(ctx, (IJstNode)typeSpaceType, new HashSet<DuplicateLoadProtectionKey>(), typeSpaceType, 1, null);
    }

    public static void unloadSingleJstTypeSymbols(VjoValidationCtx ctx, IJstType jstType) {
        IJstType typeSpaceType = ctx.getTypeSpaceType(jstType);
        JstTypeSymbolLoadUtil.unloadSingleJstTypeSymbols(ctx, typeSpaceType, typeSpaceType, 1);
    }

    public static void loadSingleJstTypeSymbols(VjoValidationCtx ctx, IJstType jstType, int modifier) {
        IJstType typeSpaceType = ctx.getTypeSpaceType(jstType);
        JstTypeSymbolLoadUtil.loadSingleJstTypeSymbols(ctx, (IJstNode)typeSpaceType, new HashSet<DuplicateLoadProtectionKey>(), typeSpaceType, modifier, null);
    }

    public static void unloadSingleJstTypeSymbols(VjoValidationCtx ctx, IJstType jstType, int modifier) {
        IJstType typeSpaceType = ctx.getTypeSpaceType(jstType);
        JstTypeSymbolLoadUtil.unloadSingleJstTypeSymbols(ctx, typeSpaceType, typeSpaceType, modifier);
    }

    public static void loadSingleJstTypeSymbols(VjoValidationCtx ctx, IJstNode scope, Set<DuplicateLoadProtectionKey> dupProtect, IJstType jstType, int modifier, EVjoSymbolType symbolType) {
        IJstType typeSpaceType = ctx.getTypeSpaceType(jstType);
        JstModifiers jstModifier = new JstModifiers(modifier);
        VjoSymbolTable symbolTable = ctx.getSymbolTable();
        if (typeSpaceType.isEnum()) {
            JstType vjoEnumType;
            for (IJstProperty enumProperty : typeSpaceType.getEnumValues()) {
                JstTypeSymbolLoadUtil.symbolizeProperty(scope, typeSpaceType, symbolType, jstModifier, ctx, enumProperty);
            }
            if (s_valuesMtd == null && (vjoEnumType = JstCache.getInstance().getType("vjo.Enum")) != null) {
                IJstMethod valuesMtd;
                s_valuesMtd = valuesMtd = vjoEnumType.getMethod("values", true);
            }
            if (s_valuesMtd != null) {
                JstTypeSymbolLoadUtil.symbolizeMethod((IJstNode)typeSpaceType, symbolType, jstModifier, symbolTable, s_valuesMtd);
            }
        }
        for (IJstType innerType : typeSpaceType.getEmbededTypes()) {
            JstTypeSymbolLoadUtil.recursiveLoadCompleteJstTypesSymbols(ctx, innerType, innerType, 2, dupProtect);
            JstTypeSymbolLoadUtil.symbolizeInnerClass(scope, typeSpaceType, innerType, jstModifier, symbolTable);
        }
        for (IJstProperty jstProperty : typeSpaceType.getProperties()) {
            JstTypeSymbolLoadUtil.symbolizeProperty(scope, typeSpaceType, symbolType, jstModifier, ctx, jstProperty);
        }
        for (IJstMethod jstMethod : typeSpaceType.getMethods()) {
            JstTypeSymbolLoadUtil.symbolizeMethod(scope, symbolType, jstModifier, symbolTable, jstMethod);
        }
        if (typeSpaceType.getConstructor() != null) {
            JstTypeSymbolLoadUtil.symbolizeMethod(scope, symbolType, jstModifier, symbolTable, typeSpaceType.getConstructor());
        }
        JstTypeSymbolLoadUtil.symbolizeClazzProperty(ctx, scope, symbolTable);
    }

    protected static void symbolizeClazzProperty(VjoValidationCtx ctx, IJstNode scope, VjoSymbolTable symbolTable) {
        IVjoSymbol clazzSymbol;
        if (s_vjoClazzType == null && (s_vjoClazzType = JstCache.getInstance().getType("vjo.Class")) instanceof IJstRefType) {
            s_vjoClazzType = ((IJstRefType)s_vjoClazzType).getReferencedNode();
        }
        if ((clazzSymbol = symbolTable.getSymbolInScope(scope, "clazz", EVjoSymbolType.STATIC_VARIABLE)) == null) {
            clazzSymbol = new VjoSymbol();
            clazzSymbol.setDeclareType(s_vjoClazzType);
            clazzSymbol.setSymbolType(EVjoSymbolType.STATIC_VARIABLE);
            clazzSymbol.setName("clazz");
            symbolTable.addSymbolInScope(scope, clazzSymbol);
        }
    }

    private static void symbolizeInnerClass(IJstNode scope, IJstType jstType, IJstType innerClzType, JstModifiers jstModifier, VjoSymbolTable symbolTable) {
        IVjoSymbol symbol4InnerClass = symbolTable.getSymbolInScope(scope, innerClzType.getName(), innerClzType.getModifiers().isStatic() ? EVjoSymbolType.STATIC_VARIABLE : EVjoSymbolType.INSTANCE_VARIABLE);
        if (symbol4InnerClass == null) {
            boolean isStaticInnerType = innerClzType.getModifiers().isStatic();
            symbol4InnerClass = new VjoSymbol().setName(innerClzType.getSimpleName()).setSymbolType(isStaticInnerType ? EVjoSymbolType.STATIC_VARIABLE : EVjoSymbolType.INSTANCE_VARIABLE).setDeclareType((IJstType)JstTypeHelper.getJstTypeRefType((IJstType)innerClzType));
            symbolTable.addSymbolInScope(scope, symbol4InnerClass);
        }
        if (innerClzType.getModifiers().isNone()) {
            symbol4InnerClass.setVisible(true);
        } else if (jstType.isInterface()) {
            symbol4InnerClass.setVisible(true);
        } else if (jstModifier.isPublic() && (innerClzType.getModifiers().isProtected() || innerClzType.getModifiers().isPrivate()) || jstModifier.isProtected() && innerClzType.getModifiers().isPrivate() || JstTypeSymbolLoadUtil.isDefault(innerClzType.getModifiers()) && !JstTypeSymbolLoadUtil.withinSamePackage(scope.getOwnerType(), innerClzType.getOwnerType())) {
            symbol4InnerClass.setVisible(false);
        } else {
            symbol4InnerClass.setVisible(true);
        }
        symbol4InnerClass.setDeclareNode((IJstNode)innerClzType);
        symbol4InnerClass.setStaticReference(true);
    }

    private static void symbolizeProperty(IJstNode scope, IJstType jstType, EVjoSymbolType symbolType, JstModifiers jstModifier, VjoValidationCtx ctx, IJstProperty jstProperty) {
        VjoSymbolTable symbolTable = ctx.getSymbolTable();
        if (jstProperty.isStatic() && jstProperty.getOwnerType() != scope && !jstModifier.isStatic()) {
            return;
        }
        IVjoSymbol symbol4Property = symbolTable.getSymbolInScope(scope, jstProperty.getName().getName(), symbolType != null ? symbolType : (jstProperty.isStatic() ? EVjoSymbolType.STATIC_VARIABLE : EVjoSymbolType.INSTANCE_VARIABLE));
        if (symbol4Property == null) {
            symbol4Property = new VjoSymbol().setName(jstProperty.getName().getName()).setSymbolType(symbolType != null ? symbolType : (jstProperty.isStatic() ? EVjoSymbolType.STATIC_VARIABLE : EVjoSymbolType.INSTANCE_VARIABLE));
            symbolTable.addSymbolInScope(scope, symbol4Property);
        }
        if (jstProperty.getModifiers().isNone() || jstType.isInterface()) {
            symbol4Property.setVisible(true);
        } else if (jstModifier.isPublic() && (jstProperty.getModifiers().isProtected() || jstProperty.getModifiers().isPrivate()) || jstModifier.isProtected() && jstProperty.getModifiers().isPrivate() || JstTypeSymbolLoadUtil.isDefault(jstProperty.getModifiers(), jstProperty) && !JstTypeSymbolLoadUtil.withinSamePackage(scope.getOwnerType(), jstProperty.getOwnerType())) {
            symbol4Property.setVisible(false);
        } else {
            symbol4Property.setVisible(true);
        }
        symbol4Property.setDeclareNode((IJstNode)jstProperty);
        IJstType propertyType = jstProperty.getType() == null || "Object".equals(jstProperty.getType().getSimpleName()) && !"vjo.Object".equals(jstProperty.getType().getName()) ? VjoConstants.ARBITARY : jstProperty.getType();
        symbol4Property.setDeclareType(propertyType);
        symbol4Property.setStaticReference(false);
    }

    private static void symbolizeMethod(IJstNode scope, EVjoSymbolType symbolType, JstModifiers jstModifier, VjoSymbolTable symbolTable, IJstMethod jstMethod) {
        if (jstMethod.isStatic() && jstMethod.getOwnerType() != scope && !jstModifier.isStatic()) {
            return;
        }
        IVjoSymbol symbol4Method = symbolTable.getSymbolInScope(scope, jstMethod.getName().getName(), symbolType != null ? symbolType : (jstMethod.isStatic() ? EVjoSymbolType.STATIC_FUNCTION : EVjoSymbolType.INSTANCE_FUNCTION), true);
        if (symbol4Method == null) {
            symbol4Method = new VjoSymbol().setName(jstMethod.getName().getName()).setSymbolType(symbolType != null ? symbolType : (jstMethod.isStatic() ? EVjoSymbolType.STATIC_FUNCTION : EVjoSymbolType.INSTANCE_FUNCTION));
            symbolTable.addSymbolInScope(scope, symbol4Method);
        } else {
            IJstMethod mtd;
            IJstType methodType = symbol4Method.getAssignedType();
            if (methodType != null && methodType instanceof JstFunctionRefType && (mtd = ((JstFunctionRefType)methodType).getMethodRef()) != null && mtd instanceof JstMethod && jstMethod instanceof JstMethod && !jstMethod.equals(mtd) && mtd.getParentNode() != jstMethod.getParentNode()) {
                symbol4Method = new VjoSymbol().setName(jstMethod.getName().getName()).setSymbolType(symbolType != null ? symbolType : (jstMethod.isStatic() ? EVjoSymbolType.STATIC_FUNCTION : EVjoSymbolType.INSTANCE_FUNCTION));
                symbolTable.addSymbolInScope(scope, symbol4Method);
            }
        }
        if (jstModifier.isPublic() && (jstMethod.getModifiers().isProtected() || jstMethod.getModifiers().isPrivate()) || jstModifier.isProtected() && jstMethod.getModifiers().isPrivate() || JstTypeSymbolLoadUtil.isDefault(jstMethod.getModifiers(), jstMethod) && !JstTypeSymbolLoadUtil.withinSamePackage(scope.getOwnerType(), jstMethod.getOwnerType())) {
            symbol4Method.setVisible(false);
        } else {
            symbol4Method.setVisible(true);
        }
        symbol4Method.setDeclareNode((IJstNode)jstMethod);
        symbol4Method.setDeclareType((IJstType)new JstFunctionRefType(jstMethod));
    }

    private static boolean isDefault(JstModifiers jstModifiers) {
        return !jstModifiers.isPublic() && !jstModifiers.isProtected() && !jstModifiers.isPrivate();
    }

    private static boolean isDefault(JstModifiers jstModifiers, IJstMethod mtd) {
        return !jstModifiers.isPublic() && !jstModifiers.isProtected() && !jstModifiers.isPrivate() && mtd.getRtnType() != null;
    }

    private static boolean isDefault(JstModifiers jstModifiers, IJstProperty pty) {
        return !jstModifiers.isPublic() && !jstModifiers.isProtected() && !jstModifiers.isPrivate() && pty.getType() != null;
    }

    private static boolean withinSamePackage(IJstType type1, IJstType type2) {
        String type1Name = type1.getName();
        String type2Name = type2.getName();
        if (type1Name == null || type2Name == null) {
            return false;
        }
        int type1LastDotIndex = type1Name.lastIndexOf(46);
        int type2LastDotIndex = type2Name.lastIndexOf(46);
        String type1PackageName = type1LastDotIndex >= 0 ? type1Name.substring(0, type1LastDotIndex) : type1Name;
        String type2PackageName = type2LastDotIndex >= 0 ? type2Name.substring(0, type2LastDotIndex) : type2Name;
        return type1PackageName.equals(type2PackageName);
    }

    private static void unloadSingleJstTypeSymbols(VjoValidationCtx ctx, IJstType scope, IJstType jstType, int modifier) {
        JstModifiers jstModifier = new JstModifiers(modifier);
        VjoSymbolTable symbolTable = ctx.getSymbolTable();
        if (!jstType.isInterface()) {
            for (IJstProperty jstProperty : jstType.getProperties()) {
                IVjoSymbol symbol4Property = symbolTable.getSymbolInScope((IJstNode)scope, jstProperty.getName().getName(), jstProperty.isStatic() ? EVjoSymbolType.STATIC_VARIABLE : EVjoSymbolType.INSTANCE_VARIABLE);
                if (symbol4Property == null || (!jstModifier.isPrivate() || !jstProperty.getModifiers().isPrivate()) && (!jstModifier.isProtected() || !jstProperty.getModifiers().isProtected() && !jstProperty.getModifiers().isPrivate()) && !jstModifier.isPublic()) continue;
                symbol4Property.setVisible(false);
            }
        }
        for (IJstMethod jstMethod : jstType.getMethods()) {
            IVjoSymbol symbol4Method = symbolTable.getSymbolInScope((IJstNode)scope, jstMethod.getName().getName(), jstMethod.isStatic() ? EVjoSymbolType.STATIC_FUNCTION : EVjoSymbolType.INSTANCE_FUNCTION);
            if (symbol4Method == null || (!jstModifier.isPrivate() || !jstMethod.getModifiers().isPrivate()) && (!jstModifier.isProtected() || !jstMethod.getModifiers().isProtected() && !jstMethod.getModifiers().isPrivate()) && !jstModifier.isPublic()) continue;
            symbol4Method.setVisible(false);
        }
    }

    private static final class DuplicateLoadProtectionKey {
        private IJstType scope;
        private IJstType source;
        private int modifiers = 0;

        public DuplicateLoadProtectionKey() {
        }

        public DuplicateLoadProtectionKey(IJstType scope, IJstType source, int modifiers) {
            this.setScope(scope);
            this.setSource(source);
            this.setModifiers(modifiers);
        }

        public IJstType getScope() {
            return this.scope;
        }

        public void setScope(IJstType scope) {
            this.scope = scope;
        }

        public IJstType getSource() {
            return this.source;
        }

        public void setSource(IJstType source) {
            this.source = source;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
        }

        public boolean equals(Object target) {
            if (target == null || !(target instanceof DuplicateLoadProtectionKey)) {
                return false;
            }
            DuplicateLoadProtectionKey key = (DuplicateLoadProtectionKey)target;
            return key.scope == this.scope && key.source == this.source && key.modifiers == this.modifiers;
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.scope != null) {
                hashCode += this.scope.hashCode() << 6;
            }
            if (this.source != null) {
                hashCode += this.scope.hashCode() << 4;
            }
            return hashCode += this.modifiers << 2;
        }
    }
}

