/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.EVjoSymbolType;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.VjoSymbol;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.VjoSymbolTable;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util.JstTypeSymbolLoadUtil;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.dsf.ts.group.GroupSymbolMapTable;
import org.eclipse.vjet.dsf.ts.group.IGroup;

public class JstGlobalScopeUtil {
    private static final String CLASS_SCOPE = "Class";
    private static final String ENUM_SCOPE = "Enum";
    private static final String VJO_CLASS_TYPE = "vjo.Class";
    private static final String VJO_ENUM_TYPE = "vjo.Enum";
    private static final String VJO_OBJECT_TYPE = "vjo.Object";
    private static final String VJO_TYPE = "vjo";
    private static final String OPTION_SCOPE = "Option";
    private static final String HTMLOPTION_ELEMENT_TYPE = "HTMLOptionElement";
    private static final String IMAGE_SCOPE = "Image";
    private static final String HTMLIMAGE_ELEMENT_TYPE = "HTMLImageElement";
    private static final String OBJECT_TYPE = "Object";
    private static final String FUNCTION_TYPE = "Function";
    private static final String WINDOW_SCOPE = "window";
    private static final String GLOBAL_TYPE = "Global";
    private static final String WINDOW_TYPE = "Window";
    private static final String GLOBAL_SCOPE = "global";

    public static final IJstType getGlobal(VjoValidationCtx ctx, JstTypeSpaceMgr typeSpaceMgr) {
        JstObjectLiteralType global = new JstObjectLiteralType(GLOBAL_SCOPE);
        ctx.setGlobal((IJstType)global);
        return global;
    }

    private static void updateGlobalWithGroup(VjoValidationCtx ctx, IJstType global, IJstType vjoNativeType, String groupName, JstTypeSpaceMgr typeSpaceMgr) {
        HashSet<IJstType> dupProtect = new HashSet<IJstType>();
        IGroup group = typeSpaceMgr.getTypeSpace().getGroup(groupName);
        if (group == null) {
            return;
        }
        VjoSymbolTable symbolTable = ctx.getSymbolTable();
        for (Map.Entry entry : group.getEntities().entrySet()) {
            String nativeSymbolName = (String)entry.getKey();
            IJstType nativeType = (IJstType)entry.getValue();
            if (nativeType == null || dupProtect.contains(nativeType)) continue;
            dupProtect.add(nativeType);
            VjoSymbol globalTypeSymbol = new VjoSymbol();
            globalTypeSymbol.setName(nativeSymbolName);
            globalTypeSymbol.setDeclareType((IJstType)JstTypeHelper.getJstTypeRefType((IJstType)nativeType));
            globalTypeSymbol.setStaticReference(true);
            globalTypeSymbol.setSymbolType(EVjoSymbolType.LOCAL_VARIABLE);
            symbolTable.addSymbolInScope((IJstNode)global, globalTypeSymbol);
            JstTypeSymbolLoadUtil.loadCompleteJstTypeSymbols(ctx, nativeType);
            if (WINDOW_TYPE.equals(nativeSymbolName) || GLOBAL_TYPE.equals(nativeSymbolName)) {
                VjoSymbol windowSymbol = new VjoSymbol();
                windowSymbol.setName(WINDOW_SCOPE);
                windowSymbol.setDeclareType(nativeType);
                windowSymbol.setSymbolType(EVjoSymbolType.LOCAL_VARIABLE);
                windowSymbol.setStaticReference(false);
                if (symbolTable.getSymbolInScope((IJstNode)global, WINDOW_SCOPE, EVjoSymbolType.LOCAL_VARIABLE) == null) {
                    symbolTable.addSymbolInScope((IJstNode)global, windowSymbol);
                }
            } else if (HTMLIMAGE_ELEMENT_TYPE.equals(nativeSymbolName)) {
                VjoSymbol imageSymbol = new VjoSymbol();
                imageSymbol.setName(IMAGE_SCOPE);
                imageSymbol.setDeclareType((IJstType)JstTypeHelper.getJstTypeRefType((IJstType)nativeType));
                imageSymbol.setSymbolType(EVjoSymbolType.LOCAL_VARIABLE);
                imageSymbol.setStaticReference(true);
                symbolTable.addSymbolInScope((IJstNode)global, imageSymbol);
            } else if (HTMLOPTION_ELEMENT_TYPE.equals(nativeSymbolName)) {
                VjoSymbol optionSymbol = new VjoSymbol();
                optionSymbol.setName(OPTION_SCOPE);
                optionSymbol.setDeclareType((IJstType)JstTypeHelper.getJstTypeRefType((IJstType)nativeType));
                optionSymbol.setSymbolType(EVjoSymbolType.LOCAL_VARIABLE);
                optionSymbol.setStaticReference(true);
                if (symbolTable.getSymbolInScope((IJstNode)global, OPTION_SCOPE, EVjoSymbolType.LOCAL_VARIABLE) == null) {
                    symbolTable.addSymbolInScope((IJstNode)global, optionSymbol);
                }
            }
            if (WINDOW_TYPE.equals(nativeSymbolName) || GLOBAL_TYPE.equals(nativeSymbolName)) {
                for (IJstMethod nativeMtd : nativeType.getMethods()) {
                    VjoSymbol methodSymbol = new VjoSymbol();
                    methodSymbol.setName(nativeMtd.getName().getName());
                    methodSymbol.setDeclareType((IJstType)new JstFunctionRefType(nativeMtd));
                    methodSymbol.setStaticReference(false);
                    methodSymbol.setSymbolType(EVjoSymbolType.LOCAL_FUNCTION);
                    symbolTable.addSymbolInScope((IJstNode)global, methodSymbol);
                }
                for (IJstProperty nativePty : nativeType.getProperties()) {
                    VjoSymbol propertySymbol = new VjoSymbol();
                    propertySymbol.setName(nativePty.getName().getName());
                    propertySymbol.setDeclareType(nativePty.getType());
                    propertySymbol.setStaticReference(false);
                    propertySymbol.setSymbolType(EVjoSymbolType.LOCAL_VARIABLE);
                    symbolTable.addSymbolInScope((IJstNode)global, propertySymbol);
                }
            }
            if (VJO_TYPE.equals(nativeSymbolName)) {
                nativeType = vjoNativeType;
                for (IJstType importedType : nativeType.getImports()) {
                    JstTypeSymbolLoadUtil.loadCompleteJstTypeSymbols(ctx, importedType);
                }
                continue;
            }
            if (VJO_OBJECT_TYPE.equals(nativeSymbolName)) {
                VjoSymbol vjoObjectSymbol = new VjoSymbol();
                vjoObjectSymbol.setName(OBJECT_TYPE);
                vjoObjectSymbol.setDeclareType((IJstType)JstTypeHelper.getJstTypeRefType((IJstType)nativeType));
                vjoObjectSymbol.setStaticReference(true);
                vjoObjectSymbol.setSymbolType(EVjoSymbolType.STATIC_VARIABLE);
                symbolTable.addSymbolInScope((IJstNode)vjoNativeType, vjoObjectSymbol);
                continue;
            }
            if (VJO_ENUM_TYPE.equals(nativeSymbolName)) {
                VjoSymbol vjoEnumSymbol = new VjoSymbol();
                vjoEnumSymbol.setName(ENUM_SCOPE);
                vjoEnumSymbol.setDeclareType((IJstType)JstTypeHelper.getJstTypeRefType((IJstType)nativeType));
                vjoEnumSymbol.setStaticReference(true);
                vjoEnumSymbol.setSymbolType(EVjoSymbolType.STATIC_VARIABLE);
                symbolTable.addSymbolInScope((IJstNode)vjoNativeType, vjoEnumSymbol);
                continue;
            }
            if (!VJO_CLASS_TYPE.equals(nativeSymbolName)) continue;
            VjoSymbol vjoClassSymbol = new VjoSymbol();
            vjoClassSymbol.setName(CLASS_SCOPE);
            vjoClassSymbol.setDeclareType((IJstType)JstTypeHelper.getJstTypeRefType((IJstType)nativeType));
            vjoClassSymbol.setStaticReference(true);
            vjoClassSymbol.setSymbolType(EVjoSymbolType.STATIC_VARIABLE);
            symbolTable.addSymbolInScope((IJstNode)vjoNativeType, vjoClassSymbol);
        }
    }

    private static void addPropsToScope(IJstType global, VjoSymbolTable symbolTable, List<? extends IJstNode> props) {
        for (IJstNode iJstNode : props) {
            if (!(iJstNode instanceof IJstProperty)) continue;
            VjoSymbol propertySymbol = new VjoSymbol();
            propertySymbol.setName(((IJstProperty)iJstNode).getName().getName());
            propertySymbol.setDeclareType(((IJstProperty)iJstNode).getType());
            propertySymbol.setStaticReference(false);
            propertySymbol.setSymbolType(EVjoSymbolType.STATIC_VARIABLE);
            symbolTable.addSymbolInScope((IJstNode)global, propertySymbol);
        }
    }

    private static void addTypesToScope(IJstType global, VjoSymbolTable symbolTable, List<GroupSymbolMapTable.GlobalSymbolMapEntry> props, VjoValidationCtx ctx) {
        for (GroupSymbolMapTable.GlobalSymbolMapEntry nativePty : props) {
            VjoSymbol typeSymbol = new VjoSymbol();
            typeSymbol.setName(nativePty.getName());
            IJstType node = (IJstType)nativePty.getNode();
            typeSymbol.setDeclareType(node);
            typeSymbol.setStaticReference(false);
            typeSymbol.setSymbolType(EVjoSymbolType.LOCAL_VARIABLE);
            symbolTable.addSymbolInScope((IJstNode)global, typeSymbol);
            JstTypeSymbolLoadUtil.loadCompleteJstTypeSymbols(ctx, node);
        }
    }

    private static void addMethodsToScope(IJstType global, VjoSymbolTable symbolTable, List<? extends IJstNode> methods) {
        for (IJstNode iJstNode : methods) {
            if (!(iJstNode instanceof IJstMethod)) continue;
            VjoSymbol methodSymbol = new VjoSymbol();
            IJstMethod method = (IJstMethod)iJstNode;
            methodSymbol.setName(((IJstMethod)iJstNode).getName().getName());
            methodSymbol.setDeclareType((IJstType)new JstFunctionRefType((IJstMethod)iJstNode));
            methodSymbol.setStaticReference(method.isStatic());
            methodSymbol.setSymbolType(EVjoSymbolType.LOCAL_FUNCTION);
            symbolTable.addSymbolInScope((IJstNode)global, methodSymbol);
        }
    }
}

