/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.VjoMethodControlFlowTable;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.stmt.BreakStmt;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.stmt.SwitchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ThrowStmt;
import org.eclipse.vjet.dsf.jst.token.IStmt;

public class VjoSwitchStmtValidator
extends VjoSemanticValidator
implements IVjoValidationPostAllChildrenListener {
    private static List<Class<? extends IJstNode>> s_targetTypes = new ArrayList<Class<? extends IJstNode>>();

    static {
        s_targetTypes.add(SwitchStmt.class);
    }

    @Override
    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
        return s_targetTypes;
    }

    @Override
    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof SwitchStmt)) {
            return;
        }
        SwitchStmt switchStmt = (SwitchStmt)jstNode;
        if (switchStmt.getBody() == null) {
            return;
        }
        JstMethod mtd = this.lookUpMethod((IJstNode)switchStmt);
        if (mtd == null) {
            return;
        }
        this.verifySwitchFlowControl(ctx, switchStmt, mtd);
    }

    private void verifySwitchFlowControl(VjoValidationCtx ctx, SwitchStmt switchStmt, JstMethod mtd) {
        VjoMethodControlFlowTable mtdCtrlFlowTable = ctx.getMethodControlFlowTable();
        List<IStmt> stmts = this.lookUpStmts(switchStmt);
        IStmt pseudoBlock = null;
        boolean hasDefault = false;
        boolean caseClosed = true;
        for (IStmt stmt : stmts) {
            if (stmt instanceof SwitchStmt.CaseStmt) {
                SwitchStmt.CaseStmt caseStmt;
                if (pseudoBlock == null) {
                    pseudoBlock = stmt;
                }
                if ((caseStmt = (SwitchStmt.CaseStmt)stmt).getExpr() == null) {
                    hasDefault = true;
                }
                if (!caseClosed) continue;
                mtdCtrlFlowTable.addBranch((IJstMethod)mtd, (IJstNode)pseudoBlock);
                caseClosed = false;
                continue;
            }
            if (caseClosed) {
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)stmt, ctx.getGroupId(), new String[]{mtd.getName().getName(), stmt.toStmtText()});
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().STMT_SHOULD_BE_REACHABLE, ruleCtx);
                continue;
            }
            if (stmt instanceof RtnStmt) {
                mtdCtrlFlowTable.addStmt((IJstMethod)mtd, (RtnStmt)stmt);
            } else if (stmt instanceof ThrowStmt) {
                mtdCtrlFlowTable.addStmt((IJstMethod)mtd, (ThrowStmt)stmt);
            } else if (!(stmt instanceof BreakStmt)) continue;
            if (pseudoBlock == null) continue;
            mtdCtrlFlowTable.endBranch((IJstMethod)mtd, (IJstNode)pseudoBlock);
            pseudoBlock = null;
            caseClosed = true;
        }
        if (pseudoBlock != null) {
            mtdCtrlFlowTable.endBranch((IJstMethod)mtd, (IJstNode)pseudoBlock);
        } else if (!hasDefault) {
            mtdCtrlFlowTable.addBranch((IJstMethod)mtd, null);
            mtdCtrlFlowTable.endBranch((IJstMethod)mtd, null);
        }
    }

    private List<IStmt> lookUpStmts(SwitchStmt switchStmt) {
        ArrayList<IStmt> caseStmts = new ArrayList<IStmt>();
        for (IJstNode node : switchStmt.getBody().getChildren()) {
            if (!(node instanceof IStmt)) continue;
            caseStmts.add((IStmt)node);
        }
        return caseStmts;
    }
}

