/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jsgen.shared.util.JstDisplayUtils;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticValidator;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationRuntimeException;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.rulectx.BaseVjoSemanticRuleCtx;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.AccessControlUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.TypeCheckUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.EVjoSymbolType;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.VjoSymbol;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.symbol.VjoSymbolTable;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.validator.VjoSemanticValidatorRepo;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util.MixinValidationUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util.VjoValidationVisitorCtxUpdateUtil;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostAllChildrenListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationPostChildListener;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.visitor.IVjoValidationVisitorEvent;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IInferred;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.JstVariantType;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.JstProxyIdentifier;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;

public class VjoMtdInvocationExprValidator
extends VjoSemanticValidator
implements IVjoValidationPostChildListener,
IVjoValidationPostAllChildrenListener {
    private static final String VJO_ETYPE1 = "vjo.etype1";
    private static final String VALUES = "values";
    private static List<Class<? extends IJstNode>> s_targetTypes = new ArrayList<Class<? extends IJstNode>>();

    static {
        s_targetTypes.add(MtdInvocationExpr.class);
    }

    @Override
    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
        return s_targetTypes;
    }

    @Override
    public void onPostChildEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        IJstNode child = event.getVisitChildNode();
        if (!(jstNode instanceof MtdInvocationExpr)) {
            return;
        }
        if (jstNode.getParentNode() != null && jstNode.getParentNode() instanceof ObjCreationExpr) {
            return;
        }
        MtdInvocationExpr expr = (MtdInvocationExpr)jstNode;
        if (child != expr.getQualifyExpr()) {
            return;
        }
        IExpr qualifier = expr.getQualifyExpr();
        IJstType qualifierType = qualifier.getResultType();
        if (qualifierType == null) {
            return;
        }
        this.validateVjoMake(ctx, expr, this.getTargetType(qualifierType));
        this.validateVjoMixin(ctx, expr, this.getTargetType(qualifierType));
    }

    @Override
    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
        VjoValidationCtx ctx = event.getValidationCtx();
        IJstNode jstNode = event.getVisitNode();
        if (!(jstNode instanceof MtdInvocationExpr)) {
            return;
        }
        MtdInvocationExpr expr = (MtdInvocationExpr)jstNode;
        IExpr qualifier = expr.getQualifyExpr();
        IExpr identifier = expr.getMethodIdentifier();
        List args = expr.getArgs();
        VjoSemanticRuleRepo ruleRepo = VjoSemanticRuleRepo.getInstance();
        if (jstNode.getParentNode() != null && jstNode.getParentNode() instanceof ObjCreationExpr) {
            JstIdentifier mtdIdentifier;
            IJstNode mtdBinding;
            if (identifier instanceof FieldAccessExpr) {
                identifier = ((FieldAccessExpr)identifier).getName();
            }
            if (identifier != null && identifier instanceof JstIdentifier && (mtdBinding = (mtdIdentifier = (JstIdentifier)identifier).getJstBinding()) instanceof JstConstructor) {
                JstConstructor cons = (JstConstructor)mtdBinding;
                String[] arguments = new String[]{cons.getName().getName(), expr.toExprText()};
                this.validateBoundMethod(ctx, expr, identifier, args, (IJstNode)cons, ruleRepo, arguments);
            }
            return;
        }
        if (qualifier != null) {
            IJstType qualifierType = qualifier.getResultType();
            if (qualifierType == null) {
                return;
            }
            if (identifier != null && identifier instanceof JstIdentifier) {
                JstIdentifier mtdIdentifier = (JstIdentifier)identifier;
                IJstNode mtdBinding = mtdIdentifier.getJstBinding();
                String mtdName = mtdIdentifier.getName();
                String[] arguments = new String[]{mtdName != null ? mtdName : "NULL", expr.toExprText()};
                if (mtdBinding != null && !(mtdBinding instanceof IJstMethod) && !VjoMtdInvocationExprValidator.validateMtdBinding(mtdBinding)) {
                    this.satisfyRule(ctx, ruleRepo.FUNCTION_SHOULD_BE_DEFINED, new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), arguments));
                    return;
                }
                if (mtdBinding == null) {
                    if (qualifierType instanceof IInferred) {
                        return;
                    }
                    if (!("Object".equals(qualifierType.getName()) || "ERROR_UNDEFINED_TYPE".equals(qualifierType.getName()) || qualifierType.getModifiers().isDynamic())) {
                        if (qualifierType instanceof IJstRefType) {
                            if (qualifierType.getMethod(mtdName, false, true) != null) {
                                this.satisfyRule(ctx, ruleRepo.NONE_STATIC_METHOD_SHOULD_NOT_BE_ACCESSED_FROM_STATIC_SCOPE, new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), arguments));
                                return;
                            }
                        } else if (qualifierType.getMethod(mtdName, true, true) != null) {
                            this.satisfyRule(ctx, ruleRepo.STATIC_METHOD_SHOULD_NOT_BE_ACCESSED_FROM_NONE_STATIC_SCOPE, new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), arguments));
                            return;
                        }
                        if (qualifierType instanceof JstObjectLiteralType && "ObjLiteral".equals(qualifierType.getSimpleName())) {
                            return;
                        }
                        if (!(ctx.getMissingImportTypes().contains(qualifierType) || qualifierType instanceof JstVariantType || qualifierType instanceof JstMixedType)) {
                            this.satisfyRule(ctx, ruleRepo.METHOD_SHOULD_BE_DEFINED, new BaseVjoSemanticRuleCtx((IJstNode)identifier, ctx.getGroupId(), arguments));
                        }
                    }
                    return;
                }
                this.validateBoundMethod(ctx, expr, identifier, args, mtdBinding, ruleRepo, arguments);
                this.validateVjoGetType(ctx, expr, qualifierType);
            }
        } else if (identifier != null && identifier instanceof JstIdentifier) {
            JstIdentifier mtdIdentifier = (JstIdentifier)identifier;
            IJstNode mtdBinding = mtdIdentifier.getJstBinding();
            String mtdName = mtdIdentifier.getName();
            String[] arguments = new String[]{mtdName != null ? mtdName : "NULL", expr.toExprText()};
            if (mtdBinding != null && !(mtdBinding instanceof IJstMethod) && !VjoMtdInvocationExprValidator.validateMtdBinding(mtdBinding)) {
                this.satisfyRule(ctx, ruleRepo.FUNCTION_SHOULD_BE_DEFINED, new BaseVjoSemanticRuleCtx((IJstNode)expr, ctx.getGroupId(), arguments));
                return;
            }
            if (mtdBinding == null) {
                if (!(mtdIdentifier instanceof JstProxyIdentifier)) {
                    this.satisfyRule(ctx, ruleRepo.FUNCTION_SHOULD_BE_DEFINED, new BaseVjoSemanticRuleCtx((IJstNode)identifier, ctx.getGroupId(), arguments));
                }
            } else {
                this.checkArgsOfMethod(ctx, mtdBinding, (List<IExpr>)args, expr);
            }
        }
    }

    private static boolean validateMtdBinding(IJstNode mtdBinding) {
        IJstType resultType = null;
        if (mtdBinding instanceof IJstProperty) {
            resultType = ((IJstProperty)mtdBinding).getType();
        } else if (mtdBinding instanceof JstVars) {
            resultType = ((JstVars)mtdBinding).getType();
        } else if (mtdBinding instanceof JstArg) {
            resultType = ((JstArg)mtdBinding).getType();
        }
        if (resultType == null) {
            return true;
        }
        if (resultType instanceof IInferred) {
            return true;
        }
        if (resultType instanceof JstProxyType) {
            resultType = ((JstProxyType)resultType).getType();
        }
        if (resultType instanceof JstFunctionRefType) {
            return true;
        }
        return resultType != null && ("Function".equals(resultType.getName()) || "Object".equals(resultType.getName()));
    }

    private void validateBoundMethod(VjoValidationCtx ctx, MtdInvocationExpr expr, IExpr identifier, List<IExpr> args, IJstNode mtdBinding, VjoSemanticRuleRepo ruleRepo, String[] arguments) {
        if (mtdBinding instanceof JstMethod && !(expr.getParentNode() instanceof ObjCreationExpr)) {
            JstMethod method = (JstMethod)mtdBinding;
            JstType callerType = expr.getOwnerType();
            JstType mtdOwnerType = method.getOwnerType();
            boolean visible = AccessControlUtil.isVisible((IJstMethod)method, (IJstType)mtdOwnerType, (IJstType)callerType);
            if (!visible) {
                this.satisfyRule(ctx, ruleRepo.METHOD_SHOULD_BE_VISIBLE, new BaseVjoSemanticRuleCtx((IJstNode)identifier, ctx.getGroupId(), arguments));
                return;
            }
        }
        if (mtdBinding instanceof JstMethod && args.size() > 0) {
            IExpr valuesExprArgs = args.get(0);
            JstMethod method = (JstMethod)mtdBinding;
            this.checkETypeValuesArgs(ctx, valuesExprArgs, method);
        }
        this.checkArgsOfMethod(ctx, mtdBinding, args, expr);
        if (mtdBinding instanceof JstMethod) {
            ctx.getMethodInvocationTable().reference(this.getDispatcher(mtdBinding));
        }
    }

    private IJstMethod getDispatcher(IJstNode mtdBinding) {
        if (mtdBinding instanceof IJstMethod) {
            IJstMethod parentMtd;
            IJstMethod mtd = (IJstMethod)mtdBinding;
            if (mtd.isDispatcher()) {
                return mtd;
            }
            IJstNode parent = mtd.getParentNode();
            if (parent instanceof IJstMethod && (parentMtd = (IJstMethod)parent).isDispatcher() && parentMtd.getOverloaded().contains(mtd)) {
                return parentMtd;
            }
            return mtd;
        }
        return null;
    }

    private IJstType getParameterType(VjoValidationCtx ctx, IJstMethod method, JstArg param, IJstType qualifierType) {
        Object argType = param.getType();
        if (qualifierType != null) {
            if (argType instanceof JstParamType) {
                JstParamType paramType = (JstParamType)argType;
                if (method.getParamTypes().contains(paramType)) {
                    IJstType resolvedType = ctx.getResolvedTypeByParamType(paramType);
                    argType = resolvedType != null ? resolvedType : paramType;
                }
            }
            if (qualifierType instanceof JstTypeWithArgs) {
                if (argType instanceof JstParamType) {
                    argType = ((JstTypeWithArgs)qualifierType).getParamArgType((JstParamType)argType);
                }
            } else if (qualifierType instanceof JstParamType) {
                IJstType realQualifierType;
                JstParamType qualifierParamType = (JstParamType)qualifierType;
                if (qualifierParamType.getBounds().size() > 0 && (realQualifierType = (IJstType)qualifierParamType.getBounds().get(0)) instanceof JstTypeWithArgs && argType instanceof JstParamType) {
                    argType = ((JstTypeWithArgs)realQualifierType).getParamArgType((JstParamType)argType);
                }
            } else {
                argType = JstTypeHelper.resolveJstArgType((JstArg)param, (IJstType)qualifierType);
            }
        }
        return argType;
    }

    protected boolean checkArgsOfMethod(VjoValidationCtx ctx, IJstNode node, List<IExpr> actualArgs, MtdInvocationExpr expr) {
        if (node instanceof IJstMethod) {
            if (((IJstMethod)node).isTypeFactoryEnabled()) {
                return true;
            }
            return this.checkArgsOfMethod(ctx, (IJstMethod)node, actualArgs, expr);
        }
        if (node instanceof JstArg) {
            IJstTypeReference tr = ((JstArg)node).getTypeRef();
            IJstType t = null;
            if (tr != null && (t = tr.getReferencedType()) != null && t instanceof JstFunctionRefType) {
                return this.checkArgsOfMethod(ctx, ((JstFunctionRefType)t).getMethodRef(), actualArgs, expr);
            }
        }
        return false;
    }

    protected boolean checkArgsOfMethod(VjoValidationCtx ctx, IJstMethod method, List<IExpr> arguments, MtdInvocationExpr expr) {
        if (arguments == null) {
            arguments = new ArrayList<IExpr>(0);
        }
        LinkedList<IJstMethod> candidates = new LinkedList<IJstMethod>();
        IJstMethod dispatcher = this.getDispatcher((IJstNode)method);
        if (dispatcher.isDispatcher()) {
            candidates.addAll(dispatcher.getOverloaded());
        } else {
            candidates.add(dispatcher);
        }
        int argumentsLength = arguments.size();
        HashMap<IJstMethod, List<JstArg>> overloads2ParamsMap = new HashMap<IJstMethod, List<JstArg>>(candidates.size());
        VjoMtdInvocationExprValidator.initOverloadsWithCorrectParamSize(candidates, argumentsLength, overloads2ParamsMap);
        if (overloads2ParamsMap.size() == 0) {
            String[] messages = new String[]{String.valueOf(expr.getArgs() == null ? 0 : expr.getArgs().size()), this.determineMaxArgs(dispatcher), expr.toExprText()};
            BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)expr.getMethodIdentifier(), ctx.getGroupId(), messages);
            this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().METHOD_WRONG_NUMBER_OF_ARGS, ruleCtx);
            return false;
        }
        IJstType qualifierType = null;
        if (expr instanceof MtdInvocationExpr) {
            IExpr qualiferExpr = expr.getQualifyExpr();
            qualifierType = qualiferExpr != null ? qualiferExpr.getResultType() : null;
            IExpr idExpr = expr.getMethodIdentifier();
            if (qualiferExpr == null && idExpr.getResultType() instanceof JstTypeRefType) {
                qualifierType = expr.getResultType();
            }
        }
        int argIt = 0;
        while (argIt < argumentsLength) {
            IExpr argAtIt = arguments.get(argIt);
            LinkedHashMap<IJstMethod, IJstType> badEntries = new LinkedHashMap<IJstMethod, IJstType>();
            IJstType argumentType = argAtIt.getResultType();
            if (argumentType != null) {
                for (Map.Entry overloadEntry : overloads2ParamsMap.entrySet()) {
                    IJstMethod overloadMethod = (IJstMethod)overloadEntry.getKey();
                    List overloadParams = (List)overloadEntry.getValue();
                    JstArg parameter = (JstArg)overloadParams.get(argIt);
                    IJstType parameterType = this.getParameterType(ctx, dispatcher, parameter, qualifierType);
                    if (TypeCheckUtil.isAssignable(parameterType, argumentType)) continue;
                    badEntries.put(overloadMethod, parameterType);
                }
                if (overloads2ParamsMap.size() <= badEntries.size()) {
                    String[] ruleCtxArgs = new String[]{String.valueOf(argIt + 1), this.getSemanticTypeName(argumentType), this.buildParameterTypes(badEntries.values())};
                    BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)argAtIt, ctx.getGroupId(), ruleCtxArgs);
                    this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().METHOD_ARGS_TYPE_SHOULD_MATCH, ruleCtx);
                    return false;
                }
                for (Map.Entry badKey : badEntries.entrySet()) {
                    overloads2ParamsMap.remove(badKey.getKey());
                }
            }
            ++argIt;
        }
        return true;
    }

    private String buildParameterTypes(Collection<IJstType> parameterTypes) {
        StringBuilder sb = new StringBuilder();
        if (parameterTypes.size() > 1) {
            sb.append('{');
        }
        Iterator<IJstType> it = parameterTypes.iterator();
        while (it.hasNext()) {
            IJstType parameterType = it.next();
            sb.append(this.getSemanticTypeName(parameterType));
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        if (parameterTypes.size() > 1) {
            sb.append('}');
        }
        return sb.toString();
    }

    private String getSemanticTypeName(IJstType parameterType) {
        if (parameterType == null) {
            return "NULL";
        }
        if (parameterType instanceof JstFuncType) {
            IJstMethod function = ((JstFuncType)parameterType).getFunction();
            if (!function.isDispatcher()) {
                return JstDisplayUtils.getFullMethodString(function, function.getOwnerType(), false);
            }
            return "expected function signature";
        }
        return parameterType.getName();
    }

    public static void initOverloadsWithCorrectParamSize(List<IJstMethod> overloads, int argumentsLength, Map<IJstMethod, List<JstArg>> overloads2ParamsMap) {
        for (IJstMethod overload : overloads) {
            if (!VjoMtdInvocationExprValidator.preCheckOverloadParamSize(argumentsLength, overload)) continue;
            overloads2ParamsMap.put(overload, VjoMtdInvocationExprValidator.paddingParams(overload.getArgs(), argumentsLength));
        }
    }

    private static boolean preCheckOverloadParamSize(int argumentsLength, IJstMethod overload) {
        List parameters = overload.getArgs();
        return parameters.size() == argumentsLength || parameters.size() < argumentsLength && parameters.size() > 0 && ((JstArg)parameters.get(parameters.size() - 1)).isVariable() || parameters.size() == argumentsLength + 1 && ((JstArg)parameters.get(parameters.size() - 1)).isVariable();
    }

    private static List<JstArg> paddingParams(List<JstArg> params, int argumentsLength) {
        int paramsLength = params.size();
        if (paramsLength >= argumentsLength) {
            return params;
        }
        JstArg lastParam = paramsLength > 0 ? params.get(paramsLength - 1) : null;
        ArrayList<JstArg> paddingParams = new ArrayList<JstArg>(argumentsLength);
        paddingParams.addAll(params);
        JstArg paddingParam = lastParam != null && lastParam.isVariable() ? new JstArg(lastParam.getType(), "proxy", true) : new JstArg((IJstType)JstCache.getInstance().getType("Object"), "proxy", false);
        int i = paramsLength;
        while (i < argumentsLength) {
            paddingParams.add(paddingParam);
            ++i;
        }
        return paddingParams;
    }

    private String determineMaxArgs(IJstMethod method) {
        int count = method.getArgs().size();
        List mtds = JstTypeHelper.getSignatureMethods((IJstMethod)method);
        for (IJstMethod m : mtds) {
            int size = m.getArgs().size();
            if (size <= count) continue;
            count = size;
        }
        return String.valueOf(count);
    }

    private void validateVjoMake(final VjoValidationCtx ctx, MtdInvocationExpr expr, IJstType qualifierType) {
        IExpr identifier = expr.getMethodIdentifier();
        if (identifier != null && identifier instanceof JstIdentifier) {
            String mtdId = ((JstIdentifier)identifier).getName();
            IJstType ownerType = ctx.getScope().getClosestTypeScopeNode();
            IJstNode ownerScope = ctx.getScope().getClosestScopeNode();
            if (this.isVjoType(qualifierType) && "make".equals(mtdId)) {
                List vjoMakeArgs;
                JstObjectLiteralType anonymousType = new JstObjectLiteralType("$anonymous_vjo_make$");
                ctx.setMakeParentType((IJstType)anonymousType, ownerType);
                if (ownerScope instanceof JstMethod) {
                    anonymousType.getModifiers().setStatic(((JstMethod)ownerScope).getModifiers().isStatic());
                }
                if ((vjoMakeArgs = expr.getArgs()).size() < 2) {
                    return;
                }
                IExpr scopeArg = (IExpr)vjoMakeArgs.get(0);
                IExpr sourceArg = (IExpr)vjoMakeArgs.get(1);
                ArrayList<IExpr> sourceTypeConstructorArgs = new ArrayList<IExpr>(vjoMakeArgs.size() - 2);
                int i = 2;
                while (i < vjoMakeArgs.size()) {
                    sourceTypeConstructorArgs.add((IExpr)vjoMakeArgs.get(i));
                    ++i;
                }
                MtdInvocationExpr implicitSourceTypeConstructorInvocation = new MtdInvocationExpr("constructs", new IExpr[0]);
                implicitSourceTypeConstructorInvocation.setSource(identifier.getSource());
                IVjoValidationPostAllChildrenListener postVjoMakeCtxArgListener = new IVjoValidationPostAllChildrenListener((IJstType)anonymousType){
                    private final /* synthetic */ IJstType val$anonymousType;
                    {
                        this.val$anonymousType = iJstType;
                    }

                    @Override
                    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) throws VjoValidationRuntimeException {
                        IJstType exprValue;
                        IJstNode visitNode = event.getVisitNode();
                        if (visitNode instanceof IExpr && (exprValue = ((IExpr)visitNode).getResultType()) != null) {
                            ctx.setMakeScopeType(this.val$anonymousType, exprValue);
                        }
                    }

                    @Override
                    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
                        return Collections.emptyList();
                    }

                    @Override
                    public void onEvent(IVjoValidationVisitorEvent event) throws VjoValidationRuntimeException {
                        this.onPostAllChildrenEvent(event);
                    }
                };
                VjoSemanticValidatorRepo.getInstance().appendPostAllChildrenListener((IJstNode)scopeArg, postVjoMakeCtxArgListener);
                IVjoValidationPostAllChildrenListener postVjoMakeSourceArgListener = new IVjoValidationPostAllChildrenListener((IJstType)anonymousType){
                    private final /* synthetic */ IJstType val$anonymousType;
                    {
                        this.val$anonymousType = iJstType;
                    }

                    @Override
                    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) throws VjoValidationRuntimeException {
                        IJstType exprValue;
                        IJstNode visitNode = event.getVisitNode();
                        if (visitNode instanceof IExpr && (exprValue = ((IExpr)visitNode).getResultType()) != null) {
                            ctx.setMakeSourceType(this.val$anonymousType, exprValue);
                        }
                    }

                    @Override
                    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
                        return Collections.emptyList();
                    }

                    @Override
                    public void onEvent(IVjoValidationVisitorEvent event) throws VjoValidationRuntimeException {
                        this.onPostAllChildrenEvent(event);
                    }
                };
                VjoSemanticValidatorRepo.getInstance().appendPostAllChildrenListener((IJstNode)sourceArg, postVjoMakeSourceArgListener);
                IVjoValidationPostAllChildrenListener postVjoMakeListener = new IVjoValidationPostAllChildrenListener((IJstType)anonymousType, expr, sourceTypeConstructorArgs, implicitSourceTypeConstructorInvocation){
                    private final /* synthetic */ IJstType val$anonymousType;
                    private final /* synthetic */ MtdInvocationExpr val$expr;
                    private final /* synthetic */ List val$sourceTypeConstructorArgs;
                    private final /* synthetic */ MtdInvocationExpr val$implicitSourceTypeConstructorInvocation;
                    {
                        this.val$anonymousType = iJstType;
                        this.val$expr = mtdInvocationExpr;
                        this.val$sourceTypeConstructorArgs = list;
                        this.val$implicitSourceTypeConstructorInvocation = mtdInvocationExpr2;
                    }

                    @Override
                    public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) throws VjoValidationRuntimeException {
                        VjoValidationVisitorCtxUpdateUtil.updateCtxBeforeType(ctx, this.val$anonymousType);
                        BaseJstNode exprParent = this.val$expr.getParentNode();
                        if (exprParent != null && exprParent instanceof MtdInvocationExpr) {
                            VjoSymbolTable symbolTable = ctx.getSymbolTable();
                            do {
                                MtdInvocationExpr mtdExprParent;
                                if (!((mtdExprParent = (MtdInvocationExpr)exprParent).getMethodIdentifier() instanceof JstIdentifier)) continue;
                                JstIdentifier mtdIdExprParent = (JstIdentifier)mtdExprParent.getMethodIdentifier();
                                if ("protos".equals(mtdIdExprParent.getName())) {
                                    IExpr argExpr;
                                    List args = mtdExprParent.getArgs();
                                    if (args.size() <= 0 || !((argExpr = (IExpr)args.get(0)) instanceof ObjLiteral)) continue;
                                    ObjLiteral argObjLiteral = (ObjLiteral)argExpr;
                                    ctx.setMakeTypeForObjLiteral(argObjLiteral, this.val$anonymousType);
                                    for (NV nv : argObjLiteral.getNVs()) {
                                        String name = nv.getName();
                                        IExpr value = nv.getValue();
                                        VjoSymbol propertySymbol = new VjoSymbol();
                                        propertySymbol.setName(name);
                                        if (value instanceof FuncExpr) {
                                            propertySymbol.setSymbolType(EVjoSymbolType.INSTANCE_FUNCTION);
                                            propertySymbol.setDeclareType((IJstType)new JstFunctionRefType((IJstMethod)((FuncExpr)value).getFunc()));
                                        } else {
                                            propertySymbol.setSymbolType(EVjoSymbolType.INSTANCE_VARIABLE);
                                        }
                                        propertySymbol.setDeclareNode((IJstNode)value);
                                        propertySymbol.setStaticReference(false);
                                        symbolTable.addSymbolInScope((IJstNode)this.val$anonymousType, propertySymbol);
                                    }
                                } else {
                                    if (!"endType".equals(mtdIdExprParent.getName())) break;
                                    IVjoValidationPostAllChildrenListener postEndTypeListner = new IVjoValidationPostAllChildrenListener(){

                                        @Override
                                        public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) throws VjoValidationRuntimeException {
                                            VjoValidationVisitorCtxUpdateUtil.updateCtxAfterType(ctx, val$anonymousType);
                                        }

                                        @Override
                                        public List<Class<? extends IJstNode>> getTargetNodeTypes() {
                                            return s_targetTypes;
                                        }

                                        @Override
                                        public void onEvent(IVjoValidationVisitorEvent event) throws VjoValidationRuntimeException {
                                            this.onPostAllChildrenEvent(event);
                                        }
                                    };
                                    VjoSemanticValidatorRepo.getInstance().appendPostAllChildrenListener((IJstNode)mtdExprParent, postEndTypeListner);
                                    break;
                                }
                            } while ((exprParent = exprParent.getParentNode()) != null && exprParent instanceof MtdInvocationExpr && ((MtdInvocationExpr)exprParent).getMethodIdentifier() instanceof JstIdentifier);
                        }
                        if (ctx.getMakeSourceType(this.val$anonymousType) != null && ctx.getMakeSourceType(this.val$anonymousType).getConstructor() != null) {
                            VjoMtdInvocationExprValidator.this.checkArgsOfMethod(ctx, ctx.getMakeSourceType(this.val$anonymousType).getConstructor(), (List<IExpr>)this.val$sourceTypeConstructorArgs, this.val$implicitSourceTypeConstructorInvocation);
                        }
                    }

                    @Override
                    public List<Class<? extends IJstNode>> getTargetNodeTypes() {
                        return s_targetTypes;
                    }

                    @Override
                    public void onEvent(IVjoValidationVisitorEvent event) throws VjoValidationRuntimeException {
                        this.onPostAllChildrenEvent(event);
                    }
                };
                VjoSemanticValidatorRepo.getInstance().appendPostAllChildrenListener((IJstNode)expr, postVjoMakeListener);
            }
        }
    }

    private void validateVjoMixin(final VjoValidationCtx ctx, MtdInvocationExpr expr, IJstType qualifierType) {
        IExpr identifier = expr.getMethodIdentifier();
        if (identifier != null && identifier instanceof JstIdentifier) {
            List args;
            String mtdId = ((JstIdentifier)identifier).getName();
            if (this.isVjoType(qualifierType) && "mixin".equals(mtdId) && (args = expr.getArgs()).size() == 2) {
                final IExpr targetArg = (IExpr)args.get(0);
                final IExpr mixinArg = (IExpr)args.get(1);
                if (targetArg instanceof SimpleLiteral && mixinArg instanceof SimpleLiteral) {
                    String targetValue = ((SimpleLiteral)targetArg).getValue();
                    String mixinValue = ((SimpleLiteral)mixinArg).getValue();
                    if (targetValue != null && mixinValue != null) {
                        this.validateVjoMixin(ctx, ctx.getCacheType(targetValue), ctx.getCacheType(mixinValue), false);
                    }
                } else if (mixinArg instanceof FieldAccessExpr) {
                    IVjoValidationPostAllChildrenListener postAllListener = new IVjoValidationPostAllChildrenListener(){

                        @Override
                        public void onPostAllChildrenEvent(IVjoValidationVisitorEvent event) {
                            IJstType targetValue = targetArg.getResultType();
                            IJstType mixinValue = mixinArg.getResultType();
                            if (targetValue != null && mixinValue != null && mixinValue instanceof IJstRefType) {
                                VjoMtdInvocationExprValidator.this.validateVjoMixin(ctx, targetValue, mixinValue, !(targetValue instanceof IJstRefType));
                            }
                        }

                        @Override
                        public List<Class<? extends IJstNode>> getTargetNodeTypes() {
                            return s_targetTypes;
                        }

                        @Override
                        public void onEvent(IVjoValidationVisitorEvent event) throws VjoValidationRuntimeException {
                            this.onPostAllChildrenEvent(event);
                        }
                    };
                    VjoSemanticValidatorRepo.getInstance().registerPostAllChildrenListener((IJstNode)expr, postAllListener);
                }
            }
        }
    }

    private void validateVjoMixin(VjoValidationCtx ctx, IJstType targetType, IJstType mixinType, boolean instanceMixin) {
        if (!MixinValidationUtil.validateMixin(ctx, this, targetType, mixinType, instanceMixin)) {
            return;
        }
    }

    private void validateVjoGetType(VjoValidationCtx ctx, MtdInvocationExpr expr, IJstType qualifierType) {
        IExpr arg;
        String mtdId = ((JstIdentifier)expr.getMethodIdentifier()).getName();
        if (this.isVjoType(qualifierType) && "getType".equals(mtdId) && expr.getArgs().size() > 0 && (arg = (IExpr)expr.getArgs().get(0)) instanceof SimpleLiteral) {
            SimpleLiteral sl = (SimpleLiteral)arg;
            JstType exprOwnerType = expr.getOwnerType();
            if (exprOwnerType == null) {
                List<IJstType> scopes = ctx.getScope().getTypeScopeNodes();
                for (IJstType scopeType : scopes) {
                    if (scopeType == null || scopeType instanceof JstObjectLiteralType) continue;
                    exprOwnerType = scopeType;
                    break;
                }
            }
            VjoMtdInvocationExprValidator.validateTypeResolution(this, ctx, (IJstType)exprOwnerType, ctx.getDependencyVerifier((IJstType)exprOwnerType), (IExpr)sl, sl.getValue());
        }
    }

    private boolean isVjoType(IJstType type) {
        JstType vjoType = JstCache.getInstance().getType("vjo");
        if (vjoType == null) {
            return false;
        }
        if (type instanceof JstProxyType) {
            return vjoType.equals(((JstProxyType)type).getType());
        }
        return vjoType.equals(type);
    }

    private void checkETypeValuesArgs(VjoValidationCtx ctx, IExpr valuesExprArgs, JstMethod method) {
        List nVs;
        if (method.getName().toString().equalsIgnoreCase(VALUES) && method.getRtnType().getName().equalsIgnoreCase(VJO_ETYPE1) && valuesExprArgs instanceof ObjLiteral && (nVs = ((ObjLiteral)valuesExprArgs).getNVs()).size() > 0) {
            for (NV nv : nVs) {
                if (nv.getValue() instanceof JstArrayInitializer) continue;
                BaseVjoSemanticRuleCtx ruleCtx = new BaseVjoSemanticRuleCtx((IJstNode)nv, ctx.getGroupId(), new String[0]);
                this.satisfyRule(ctx, VjoSemanticRuleRepo.getInstance().ETYPE_VALUES_MUST_BE_ARRAY, ruleCtx);
                return;
            }
        }
    }

    protected static class MatchMethodArgsResult {
        private boolean m_numberMatched;
        private boolean m_typeMatched;
        private List<IJstType> m_expectedMatches;
        private BaseVjoSemanticRuleCtx m_ruleCtx;

        protected MatchMethodArgsResult() {
        }

        public List<IJstType> getExpectedMatches() {
            if (this.m_expectedMatches == null) {
                this.m_expectedMatches = new ArrayList<IJstType>();
            }
            return this.m_expectedMatches;
        }

        public void setExpectedMatches(List<IJstType> expectedMatches) {
            this.m_expectedMatches = expectedMatches;
        }

        public void addExpectedMatch(IJstType type) {
            this.getExpectedMatches().add(type);
        }

        public boolean isNumberMatched() {
            return this.m_numberMatched;
        }

        public void setNumberMatched(boolean matched) {
            this.m_numberMatched = matched;
        }

        public boolean isTypeMatched() {
            return this.m_typeMatched;
        }

        public void setTypeMatched(boolean matched) {
            this.m_typeMatched = matched;
        }

        public BaseVjoSemanticRuleCtx getParamTypeMismatchRuleCtx() {
            return this.m_ruleCtx;
        }

        public void setParamTypeMismatchRuleCtx(BaseVjoSemanticRuleCtx ruleCtx) {
            this.m_ruleCtx = ruleCtx;
        }
    }
}

