/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.VjoConstants;
import org.eclipse.vjet.dsf.jst.IInferred;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.datatype.JstReservedTypes;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstExtendedType;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.JstVariantType;
import org.eclipse.vjet.dsf.jst.declaration.JstWildcardType;
import org.eclipse.vjet.dsf.jst.declaration.SynthOlType;

public class TypeCheckUtil {
    public static IJstType getFunctionNativeType() {
        return JstCache.getInstance().getType("Function");
    }

    public static IJstType getObjectNativeType() {
        return JstCache.getInstance().getType("Object");
    }

    public static boolean equals(IJstType one, IJstType two) {
        if (one == null || two == null) {
            return false;
        }
        if (one.equals(two)) {
            return true;
        }
        String name1 = one.getName();
        String name2 = two.getName();
        if (name1 != null) {
            if (name1.equals(name2)) {
                return true;
            }
            return !(!"Object".equals(name1) && !"(obj literal)".equals(name1) || !"Object".equals(name2) && !"(obj literal)".equals(name2));
        }
        return false;
    }

    protected static IJstType toJsNativeType(IJstType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof SynthOlType) {
            return null;
        }
        IJstType[] iJstTypeArray = VjoConstants.NativeTypes.getJstNativeTypes();
        int n = iJstTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJstType jsNativeType = iJstTypeArray[n2];
            if (TypeCheckUtil.equals(jsNativeType, type)) {
                return jsNativeType;
            }
            ++n2;
        }
        if (TypeCheckUtil.equals((IJstType)JstReservedTypes.JavaPrimitive.BOOLEAN, type)) {
            return VjoConstants.NativeTypes.getPrimitiveBooleanJstType();
        }
        if (TypeCheckUtil.equals((IJstType)JstReservedTypes.JavaPrimitive.BYTE, type)) {
            return VjoConstants.NativeTypes.getNumberJstType();
        }
        if (TypeCheckUtil.equals((IJstType)JstReservedTypes.JavaPrimitive.CHAR, type)) {
            return VjoConstants.NativeTypes.getStringJstType();
        }
        if (TypeCheckUtil.equals((IJstType)JstReservedTypes.JavaPrimitive.DOUBLE, type) || TypeCheckUtil.equals((IJstType)JstReservedTypes.JavaPrimitive.FLOAT, type)) {
            return VjoConstants.NativeTypes.getDoubleJstType();
        }
        if (TypeCheckUtil.equals((IJstType)JstReservedTypes.JavaPrimitive.INT, type) || TypeCheckUtil.equals((IJstType)JstReservedTypes.JavaPrimitive.SHORT, type) || TypeCheckUtil.equals((IJstType)JstReservedTypes.JavaPrimitive.LONG, type)) {
            return VjoConstants.NativeTypes.getIntJstType();
        }
        if (TypeCheckUtil.equals((IJstType)JstReservedTypes.Other.VOID, type)) {
            return JstReservedTypes.Other.VOID;
        }
        if (type instanceof JstFunctionRefType || "Function".equals(type.getSimpleName())) {
            return TypeCheckUtil.getFunctionNativeType();
        }
        if (type instanceof JstArray || "Array".equals(type.getSimpleName())) {
            return VjoConstants.NativeTypes.getArrayJstType();
        }
        return null;
    }

    protected static boolean isAssignableJsNativeType(IJstType lhs, IJstType rhs) {
        if (TypeCheckUtil.equals(VjoConstants.NativeTypes.getObjectJstType(), lhs)) {
            return true;
        }
        if (VjoConstants.NativeTypes.getPrimitiveBooleanJstType().equals(lhs)) {
            return VjoConstants.NativeTypes.getPrimitiveBooleanJstType().equals(rhs);
        }
        if (VjoConstants.NativeTypes.getAliasBooleanJstType().equals(lhs)) {
            return VjoConstants.NativeTypes.getBooleanJstType().equals(rhs);
        }
        if (VjoConstants.NativeTypes.getNumberJstType().equals(lhs) || VjoConstants.NativeTypes.getAliasNumberJstType().equals(lhs)) {
            return VjoConstants.NativeTypes.getNumberJstType().equals(rhs) || VjoConstants.NativeTypes.getPrimitiveBooleanJstType().equals(rhs) || VjoConstants.NativeTypes.getIntJstType().equals(rhs) || VjoConstants.NativeTypes.getDoubleJstType().equals(rhs);
        }
        if (VjoConstants.NativeTypes.getIntJstType().equals(lhs)) {
            return VjoConstants.NativeTypes.getNumberJstType().equals(rhs) || VjoConstants.NativeTypes.getPrimitiveBooleanJstType().equals(rhs) || VjoConstants.NativeTypes.getIntJstType().equals(rhs);
        }
        if (VjoConstants.NativeTypes.getDoubleJstType().equals(lhs)) {
            return VjoConstants.NativeTypes.getNumberJstType().equals(rhs) || VjoConstants.NativeTypes.getDoubleJstType().equals(rhs);
        }
        if (VjoConstants.NativeTypes.getStringJstType().equals(lhs)) {
            return VjoConstants.NativeTypes.getRegExpJstType().equals(rhs) || VjoConstants.NativeTypes.getStringJstType().equals(rhs);
        }
        if (VjoConstants.NativeTypes.getAliasStringJstType().equals(lhs)) {
            return VjoConstants.NativeTypes.getRegExpJstType().equals(rhs) || VjoConstants.NativeTypes.getStringJstType().equals(rhs);
        }
        if (VjoConstants.NativeTypes.getAliasDateJstType().equals(lhs)) {
            return VjoConstants.NativeTypes.getDateJstType().equals(rhs);
        }
        if (VjoConstants.NativeTypes.getAliasArrayJstType().equals(lhs)) {
            return VjoConstants.NativeTypes.getArrayJstType().equals(rhs);
        }
        if (VjoConstants.NativeTypes.getRegExpJstType().equals(lhs)) {
            return VjoConstants.NativeTypes.getRegExpJstType().equals(rhs) || VjoConstants.NativeTypes.getStringJstType().equals(rhs);
        }
        if (lhs != null) {
            return TypeCheckUtil.equals(lhs, rhs);
        }
        return false;
    }

    protected static boolean isAssignableVjoType(IJstType lhs, IJstType rhs) {
        block9: {
            block8: {
                JstParamType paramType;
                if (lhs instanceof JstExtendedType) {
                    lhs = ((JstExtendedType)lhs).getTargetType();
                }
                if (rhs instanceof JstExtendedType) {
                    rhs = ((JstExtendedType)rhs).getTargetType();
                }
                if (lhs == rhs) {
                    return true;
                }
                if (lhs instanceof JstParamType && (paramType = (JstParamType)lhs).getType() == rhs) {
                    return true;
                }
                if (TypeCheckUtil.isAssignableVjoGenericType(lhs, rhs)) {
                    return true;
                }
                for (IJstType inheritedType : rhs.getExtends()) {
                    if (TypeCheckUtil.equals(VjoConstants.NativeTypes.getObjectJstType(), inheritedType) || !TypeCheckUtil.isAssignableVjoType(lhs, inheritedType)) continue;
                    return true;
                }
                if (!lhs.isInterface()) break block8;
                for (IJstType interfaceType : rhs.getSatisfies()) {
                    if (!TypeCheckUtil.isAssignableVjoType(lhs, interfaceType)) continue;
                    return true;
                }
                break block9;
            }
            if (!lhs.isMixin()) break block9;
            for (IJstTypeReference mixinTypeRef : rhs.getMixinsRef()) {
                if (!TypeCheckUtil.isAssignableVjoType(lhs, mixinTypeRef.getReferencedType())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAssignableVjoGenericType(IJstType one, IJstType two) {
        if (one instanceof JstParamType && two instanceof JstParamType) {
            IJstType oneParentType = one.getExtend();
            IJstType twoParentType = two.getExtend();
            if (oneParentType != null && twoParentType != null && TypeCheckUtil.isObject(oneParentType) && TypeCheckUtil.isObject(twoParentType)) {
                return true;
            }
        }
        if (one instanceof JstWildcardType) {
            one = ((JstWildcardType)one).getType();
            return TypeCheckUtil.isAssignable(one, two);
        }
        if (two instanceof JstWildcardType) {
            two = ((JstWildcardType)two).getType();
            return TypeCheckUtil.isAssignable(one, two);
        }
        if (one instanceof JstTypeWithArgs) {
            if (two instanceof JstTypeWithArgs) {
                return TypeCheckUtil.isAssignableVjoTypeWithArgs(null, null, (JstTypeWithArgs)one, (JstTypeWithArgs)two);
            }
            return TypeCheckUtil.isAssignableVjoGenericType((JstTypeWithArgs)one, two);
        }
        if (two instanceof JstTypeWithArgs) {
            return TypeCheckUtil.isAssignableVjoGenericType((JstTypeWithArgs)two, one);
        }
        return false;
    }

    private static boolean isAssignableVjoGenericType(JstTypeWithArgs one, IJstType two) {
        return TypeCheckUtil.isAssignable(one.getType(), two);
    }

    private static boolean isAssignableVjoTypeWithArgs(JstTypeWithArgs typeWithArgsOne, JstTypeWithArgs typeWithArgsTwo, JstTypeWithArgs one, JstTypeWithArgs two) {
        block14: {
            if (!TypeCheckUtil.isAssignable(one.getType(), two.getType())) break block14;
            List oneArgTypes = one.getArgTypes();
            List twoArgTypes = two.getArgTypes();
            if (oneArgTypes.size() != twoArgTypes.size()) break block14;
            int i = 0;
            int len = oneArgTypes.size();
            while (i < len) {
                block15: {
                    IJstType argType;
                    IJstType twoArgType2;
                    IJstType oneArgType2;
                    IJstType twoArgType;
                    IJstType oneArgType;
                    block18: {
                        block17: {
                            block16: {
                                oneArgType = (IJstType)oneArgTypes.get(i);
                                if (oneArgType == (twoArgType = (IJstType)twoArgTypes.get(i))) break block15;
                                if (!(oneArgType instanceof JstTypeWithArgs) || !(twoArgType instanceof JstTypeWithArgs)) break block16;
                                if (!TypeCheckUtil.isAssignableVjoTypeWithArgs(typeWithArgsOne, typeWithArgsTwo, (JstTypeWithArgs)oneArgType, (JstTypeWithArgs)twoArgType)) {
                                    return false;
                                }
                                break block15;
                            }
                            if (!(oneArgType instanceof JstWildcardType) || !(twoArgType instanceof JstWildcardType)) break block17;
                            if (!TypeCheckUtil.isSuperType(((JstWildcardType)twoArgType).isUpperBound(), ((JstWildcardType)oneArgType).isUpperBound(), TypeCheckUtil.getWildCardType((JstWildcardType)twoArgType), TypeCheckUtil.getWildCardType((JstWildcardType)oneArgType))) {
                                return false;
                            }
                            break block15;
                        }
                        if (oneArgType instanceof JstParamType && TypeCheckUtil.isSuperType(twoArgType.getOwnerType(), oneArgType.getOwnerType())) break block15;
                        oneArgType2 = null;
                        twoArgType2 = twoArgType;
                        if (!(oneArgType instanceof JstWildcardType)) break block18;
                        oneArgType2 = ((JstWildcardType)oneArgType).getType();
                        if ("?".equals(oneArgType2.getName())) {
                            oneArgType2 = JstCache.getInstance().getType("Object");
                        }
                        if (((JstWildcardType)oneArgType).isLowerBound() && TypeCheckUtil.isSuperType(twoArgType2, oneArgType2) || ((JstWildcardType)oneArgType).isUpperBound() && TypeCheckUtil.isSuperType(oneArgType2, twoArgType2)) break block15;
                    }
                    if (twoArgType instanceof JstWildcardType) {
                        twoArgType2 = ((JstWildcardType)twoArgType).getType();
                    }
                    if (oneArgType2 instanceof JstParamType && typeWithArgsOne != null && (argType = typeWithArgsOne.getParamArgType((JstParamType)oneArgType2)) != null) {
                        oneArgType2 = argType;
                    }
                    if (twoArgType2 instanceof JstParamType && typeWithArgsTwo != null && (argType = typeWithArgsTwo.getParamArgType((JstParamType)twoArgType2)) != null) {
                        twoArgType2 = argType;
                    }
                    if (!(oneArgType2 != null && (((JstWildcardType)oneArgType).isUpperBound() && TypeCheckUtil.isAssignable(twoArgType2, oneArgType2) || ((JstWildcardType)oneArgType).isLowerBound() && TypeCheckUtil.isAssignable(oneArgType2, twoArgType2)))) {
                        if (JstWildcardType.class.isAssignableFrom(oneArgType.getClass())) {
                            IJstType assignableType;
                            JstWildcardType wildCardType = (JstWildcardType)oneArgType;
                            IJstType iJstType = assignableType = JstWildcardType.class.isAssignableFrom(twoArgType.getClass()) ? ((JstWildcardType)twoArgType).getType() : twoArgType;
                            if (wildCardType.isLowerBound() ? !TypeCheckUtil.isAssignable(wildCardType.getType(), assignableType) : wildCardType.isUpperBound() && !TypeCheckUtil.isAssignable(assignableType, wildCardType.getType())) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                    }
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static IJstType getWildCardType(JstWildcardType type) {
        IJstType actualType = type.getType();
        if ("?".equals(actualType.getName())) {
            return JstCache.getInstance().getType("Object");
        }
        return actualType;
    }

    public static IJstType assign(IJstType assignTo, IJstType assignFrom) {
        IJstType assignToTransformed = TypeCheckUtil.toJsNativeType(assignTo);
        if (assignToTransformed != null && VjoConstants.NativeTypes.getStringJstType().equals(assignToTransformed)) {
            return assignTo;
        }
        if (TypeCheckUtil.isAssignable(assignTo, assignFrom)) {
            return assignFrom;
        }
        return assignTo;
    }

    public static boolean isAssignable(List<IJstType> assignToList, List<IJstType> assignFromList) {
        if (assignToList == null || assignFromList == null || assignToList.size() <= 0 || assignFromList.size() <= 0) {
            return false;
        }
        for (IJstType assignFrom : assignFromList) {
            for (IJstType assignTo : assignToList) {
                if (!TypeCheckUtil.isAssignable(assignTo, assignFrom)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignable(IJstType assignTo, List<IJstType> assignFromList) {
        if (assignTo == null || assignFromList == null || assignFromList.size() <= 0) {
            return false;
        }
        for (IJstType assignFrom : assignFromList) {
            if (!TypeCheckUtil.isAssignable(assignTo, assignFrom)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignable(JstTypeWithArgs typeWithArgsTo, JstTypeWithArgs typeWithArgsFrom, JstTypeWithArgs assignTo, JstTypeWithArgs assignFrom) {
        return TypeCheckUtil.isAssignableVjoTypeWithArgs(typeWithArgsTo, typeWithArgsFrom, assignTo, assignFrom);
    }

    public static boolean isAssignable(IJstType assignTo, IJstType assignFrom) {
        Boolean checkFunction;
        if (assignTo instanceof IInferred || assignFrom instanceof IInferred) {
            return true;
        }
        if (TypeCheckUtil.isObject(assignTo)) {
            return true;
        }
        if (assignTo instanceof IJstRefType && assignTo.isFType()) {
            assignTo = ((IJstRefType)assignTo).getReferencedNode();
        }
        if (assignFrom instanceof IJstRefType && assignFrom.isFType()) {
            assignFrom = ((IJstRefType)assignFrom).getReferencedNode();
        }
        if (assignTo instanceof JstAttributedType && (assignTo = TypeCheckUtil.getAttributedType((JstAttributedType)assignTo)) == null) {
            return true;
        }
        if (assignFrom instanceof JstAttributedType && (assignFrom = TypeCheckUtil.getAttributedType((JstAttributedType)assignFrom)) == null) {
            return true;
        }
        if (assignTo instanceof JstExtendedType) {
            assignTo = ((JstExtendedType)assignTo).getTargetType();
        }
        if (assignFrom instanceof JstExtendedType) {
            assignFrom = ((JstExtendedType)assignFrom).getTargetType();
        }
        if (assignFrom instanceof JstVariantType) {
            for (IJstType vType : ((JstVariantType)assignFrom).getVariantTypes()) {
                if (!TypeCheckUtil.isAssignable(assignTo, vType)) continue;
                return true;
            }
            return false;
        }
        if (assignTo instanceof JstVariantType) {
            for (IJstType vType : ((JstVariantType)assignTo).getVariantTypes()) {
                if (!TypeCheckUtil.isAssignable(vType, assignFrom)) continue;
                return true;
            }
            return false;
        }
        if (assignTo instanceof JstMixedType) {
            for (IJstType mType : ((JstMixedType)assignTo).getMixedTypes()) {
                if (!TypeCheckUtil.isAssignable(mType, assignFrom)) continue;
                return true;
            }
            return false;
        }
        if (assignFrom instanceof JstMixedType) {
            for (IJstType mType : ((JstMixedType)assignFrom).getMixedTypes()) {
                if (!TypeCheckUtil.isAssignable(assignTo, mType)) continue;
                return true;
            }
            return false;
        }
        IJstType fromType = assignFrom;
        IJstType toType = assignTo;
        if (assignTo instanceof IJstRefType) {
            if (!(assignFrom instanceof IJstRefType)) {
                return false;
            }
            toType = ((IJstRefType)assignTo).getReferencedNode();
        }
        if (assignFrom instanceof IJstRefType) {
            if ("Function".equals(assignTo.getName())) {
                return true;
            }
            if (!(assignTo instanceof IJstRefType)) {
                return false;
            }
            fromType = ((IJstRefType)assignFrom).getReferencedNode();
        }
        if ((checkFunction = TypeCheckUtil.checkFunction(assignTo, assignFrom)) != null) {
            return checkFunction;
        }
        Boolean checkObjLiteral = TypeCheckUtil.checkObjLiteral(assignTo, assignFrom);
        if (checkObjLiteral != null) {
            return checkObjLiteral;
        }
        if (toType == fromType) {
            return true;
        }
        if (toType == null || fromType == null) {
            return false;
        }
        if (VjoConstants.ARBITARY.equals(toType) || VjoConstants.ARBITARY.equals(fromType)) {
            return true;
        }
        if (VjoConstants.NULL.equals(fromType) || VjoConstants.UNDEFINED.equals(fromType) || VjoConstants.NULL.equals(toType) || VjoConstants.UNDEFINED.equals(toType)) {
            return true;
        }
        IJstType assignToTransformed = TypeCheckUtil.toJsNativeType(toType);
        IJstType assignFromTransformed = TypeCheckUtil.toJsNativeType(fromType);
        if (!(fromType instanceof SynthOlType) && TypeCheckUtil.equals(VjoConstants.NativeTypes.getObjectJstType(), fromType)) {
            if (toType instanceof JstTypeWithArgs) {
                return TypeCheckUtil.isObject(assignTo);
            }
            return true;
        }
        if (assignToTransformed != null) {
            return TypeCheckUtil.isAssignableJsNativeType(assignToTransformed, assignFromTransformed);
        }
        return TypeCheckUtil.isAssignableVjoType(toType, fromType);
    }

    private static Boolean checkObjLiteral(IJstType assignTo, IJstType assignFrom) {
        if (assignTo instanceof IJstType && "ObjLiteral".equals(assignTo.getSimpleName()) || assignTo instanceof SynthOlType && ((SynthOlType)assignTo).getResolvedOTypes() == null) {
            return assignFrom instanceof IJstType && "ObjLiteral".equals(assignFrom.getSimpleName()) || assignFrom instanceof SynthOlType || assignFrom instanceof JstObjectLiteralType ? Boolean.TRUE : Boolean.FALSE;
        }
        if (assignTo instanceof JstObjectLiteralType) {
            if (assignFrom instanceof JstObjectLiteralType) {
                return TypeCheckUtil.isAssignable((JstObjectLiteralType)assignTo, (JstObjectLiteralType)assignFrom) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (assignFrom instanceof SynthOlType) {
                if (((SynthOlType)assignFrom).getResolvedOTypes() != null) {
                    SynthOlType syntType = (SynthOlType)assignFrom;
                    boolean isOTypeAssignable = false;
                    for (IJstType otype : syntType.getResolvedOTypes()) {
                        if (otype == null || !(isOTypeAssignable = (TypeCheckUtil.isAssignable((IJstType)((JstObjectLiteralType)assignTo), otype) ? Boolean.TRUE : Boolean.FALSE).booleanValue())) continue;
                        return true;
                    }
                } else {
                    return Boolean.TRUE;
                }
            }
        }
        return null;
    }

    private static boolean isAssignable(JstObjectLiteralType lhs, JstObjectLiteralType rhs) {
        if (lhs == rhs) {
            return true;
        }
        for (IJstProperty lhsPty : lhs.getProperties()) {
            IJstProperty rhsPty = rhs.getProperty(lhsPty.getName().getName());
            if (rhsPty != null && !TypeCheckUtil.isAssignable(lhsPty.getType(), rhsPty.getType())) {
                return false;
            }
            if (lhs.isOptionalField(lhsPty)) continue;
            return false;
        }
        return true;
    }

    private static Boolean checkFunction(IJstType assignTo, IJstType assignFrom) {
        if (assignTo instanceof JstFuncType && assignFrom instanceof JstFuncType) {
            return TypeCheckUtil.isAssignable(((JstFuncType)assignTo).getFunction(), ((JstFuncType)assignFrom).getFunction());
        }
        if (assignTo instanceof JstFunctionRefType && assignFrom instanceof JstFunctionRefType) {
            return TypeCheckUtil.isAssignable(((JstFunctionRefType)assignTo).getMethodRef(), ((JstFunctionRefType)assignFrom).getMethodRef());
        }
        if (assignTo instanceof JstFuncType && assignFrom instanceof JstFunctionRefType) {
            return TypeCheckUtil.isAssignable(((JstFuncType)assignTo).getFunction(), ((JstFunctionRefType)assignFrom).getMethodRef());
        }
        if (assignTo instanceof JstFunctionRefType && assignFrom instanceof JstFuncType) {
            return TypeCheckUtil.isAssignable(((JstFunctionRefType)assignTo).getMethodRef(), ((JstFuncType)assignFrom).getFunction());
        }
        if (assignTo instanceof JstFuncType && assignFrom != null && assignFrom.isFType()) {
            IJstMethod invoke = assignFrom.getMethod("_invoke_", true);
            if (invoke == null) {
                return Boolean.FALSE;
            }
            return TypeCheckUtil.isAssignable(((JstFuncType)assignTo).getFunction(), invoke);
        }
        if (assignTo instanceof JstFunctionRefType && assignFrom != null && assignFrom.isFType()) {
            IJstMethod invoke = assignFrom.getMethod("_invoke_", true);
            if (invoke == null) {
                return Boolean.FALSE;
            }
            return TypeCheckUtil.isAssignable(((JstFunctionRefType)assignTo).getMethodRef(), invoke);
        }
        return null;
    }

    public static boolean isAssignable(IJstMethod lhsMethod, IJstMethod rhsMethod) {
        LinkedList<IJstMethod> lhsMethods = new LinkedList<IJstMethod>();
        LinkedList<IJstMethod> rhsMethods = new LinkedList<IJstMethod>();
        if (lhsMethod.isDispatcher()) {
            lhsMethods.addAll(lhsMethod.getOverloaded());
        } else {
            lhsMethods.add(lhsMethod);
        }
        if (rhsMethod.isDispatcher()) {
            rhsMethods.addAll(rhsMethod.getOverloaded());
        } else {
            rhsMethods.add(rhsMethod);
        }
        block0: for (IJstMethod lhsIter : lhsMethods) {
            for (IJstMethod rhsIter : rhsMethods) {
                if (TypeCheckUtil.isAssignableNoOverload(lhsIter, rhsIter)) continue block0;
            }
            return false;
        }
        return true;
    }

    private static boolean isAssignableNoOverload(IJstMethod lhsMethod, IJstMethod rhsMethod) {
        List<JstArg> rhsParams;
        int rhsParamsLength;
        if (lhsMethod == null || rhsMethod == null) {
            throw new IllegalArgumentException("method must not be null");
        }
        IJstType lhsRtnType = lhsMethod.getRtnType();
        IJstType rhsRtnType = rhsMethod.getRtnType();
        if (lhsRtnType != null && rhsRtnType != null && !"void".equals(lhsRtnType.getName()) && !TypeCheckUtil.isAssignable(lhsRtnType, rhsRtnType)) {
            return false;
        }
        List lhsParams = lhsMethod.getArgs();
        int lhsParamsLength = lhsParams.size();
        if (lhsParamsLength != (rhsParamsLength = (rhsParams = TypeCheckUtil.paddingRhsParams(rhsMethod, lhsParamsLength)).size())) {
            return false;
        }
        Iterator lhsIt = lhsParams.iterator();
        Iterator<JstArg> rhsIt = rhsParams.iterator();
        while (lhsIt.hasNext() && rhsIt.hasNext()) {
            JstArg lhsParam = (JstArg)lhsIt.next();
            JstArg rhsParam = rhsIt.next();
            if (lhsParam == null || rhsParam == null) {
                throw new IllegalArgumentException("method argument should not be null");
            }
            if (lhsParam.isVariable() && !rhsParam.isVariable()) {
                return false;
            }
            if (TypeCheckUtil.isAssignable(rhsParam.getType(), lhsParam.getType())) continue;
            return false;
        }
        return true;
    }

    private static List<JstArg> paddingRhsParams(IJstMethod rhsMethod, int lhsParamsLength) {
        JstArg lastRhsParam;
        List rhsParams = rhsMethod.getArgs();
        int rhsParamsLength = rhsParams.size();
        JstArg jstArg = lastRhsParam = rhsParamsLength > 0 ? (JstArg)rhsParams.get(rhsParamsLength - 1) : null;
        if (lhsParamsLength > rhsParamsLength) {
            if (lastRhsParam != null && lastRhsParam.isVariable()) {
                LinkedList<JstArg> paddingRhsParams = new LinkedList<JstArg>(rhsParams);
                int i = rhsParamsLength;
                while (i < lhsParamsLength) {
                    paddingRhsParams.add(lastRhsParam);
                    ++i;
                }
                return paddingRhsParams;
            }
            LinkedList<JstArg> paddingRhsParams = new LinkedList<JstArg>(rhsParams);
            int i = rhsParamsLength;
            while (i < lhsParamsLength) {
                paddingRhsParams.add(new JstArg((IJstType)JstCache.getInstance().getType("Object"), "proxy", true));
                ++i;
            }
            return paddingRhsParams;
        }
        if (lhsParamsLength == rhsParamsLength - 1 && lastRhsParam.isVariable()) {
            return rhsParams.subList(0, lhsParamsLength);
        }
        return rhsParams;
    }

    public static boolean isCastable(IJstType origin, IJstType castTo) {
        IJstType originTransformed = TypeCheckUtil.toJsNativeType(origin);
        if (originTransformed != null) {
            return TypeCheckUtil.isAssignableJsNativeType(originTransformed, TypeCheckUtil.toJsNativeType(castTo));
        }
        return TypeCheckUtil.isAssignableVjoType(origin, castTo) || TypeCheckUtil.isAssignableVjoType(castTo, origin);
    }

    public static boolean isArbitary(IJstType exprValue) {
        return exprValue != null && (VjoConstants.ARBITARY.equals(exprValue) || "Object".equals(exprValue.getName()));
    }

    public static boolean isBoolean(IJstType exprValue) {
        if (exprValue instanceof JstVariantType) {
            for (IJstType type : ((JstVariantType)exprValue).getVariantTypes()) {
                if (!TypeCheckUtil.isBoolean(type)) continue;
                return true;
            }
            return false;
        }
        if (exprValue instanceof JstMixedType) {
            for (IJstType type : ((JstMixedType)exprValue).getMixedTypes()) {
                if (!TypeCheckUtil.isBoolean(type)) continue;
                return true;
            }
            return false;
        }
        if (TypeCheckUtil.isArbitary(exprValue)) {
            return true;
        }
        return exprValue == null || VjoConstants.NativeTypes.getPrimitiveBooleanJstType().equals(TypeCheckUtil.toJsNativeType(exprValue));
    }

    public static boolean isObject(IJstType exprValue) {
        if (TypeCheckUtil.isArbitary(exprValue)) {
            return true;
        }
        return exprValue == null || TypeCheckUtil.equals(VjoConstants.NativeTypes.getObjectJstType(), TypeCheckUtil.toJsNativeType(exprValue));
    }

    public static boolean isVoid(IJstType exprValue) {
        return exprValue != null && TypeCheckUtil.equals((IJstType)JstReservedTypes.Other.VOID, TypeCheckUtil.toJsNativeType(exprValue));
    }

    public static boolean isNumber(IJstType exprValue) {
        if (exprValue instanceof JstVariantType) {
            for (IJstType type : ((JstVariantType)exprValue).getVariantTypes()) {
                if (!TypeCheckUtil.isNumber(type)) continue;
                return true;
            }
            return false;
        }
        if (exprValue instanceof JstMixedType) {
            for (IJstType type : ((JstMixedType)exprValue).getMixedTypes()) {
                if (!TypeCheckUtil.isNumber(type)) continue;
                return true;
            }
            return false;
        }
        if (TypeCheckUtil.isArbitary(exprValue)) {
            return true;
        }
        return exprValue == null || TypeCheckUtil.equals(VjoConstants.NativeTypes.getNumberJstType(), TypeCheckUtil.toJsNativeType(exprValue));
    }

    private static String getGroupName(IJstType type) {
        if (type == null) {
            return null;
        }
        JstPackage pkg = type.getPackage();
        if (pkg != null) {
            return pkg.getGroupName();
        }
        return null;
    }

    public static boolean isString(IJstType exprValue) {
        if (exprValue instanceof JstVariantType) {
            for (IJstType type : ((JstVariantType)exprValue).getVariantTypes()) {
                if (!TypeCheckUtil.isString(type)) continue;
                return true;
            }
            return false;
        }
        if (exprValue instanceof JstMixedType) {
            for (IJstType type : ((JstMixedType)exprValue).getMixedTypes()) {
                if (!TypeCheckUtil.isString(type)) continue;
                return true;
            }
            return false;
        }
        if (TypeCheckUtil.isArbitary(exprValue)) {
            return true;
        }
        return exprValue == null || TypeCheckUtil.equals(VjoConstants.NativeTypes.getStringJstType(), TypeCheckUtil.toJsNativeType(exprValue));
    }

    public static boolean isSuperType(boolean oneUpper, boolean secUpper, IJstType oneType, IJstType secType) {
        if (oneUpper && !secUpper) {
            return false;
        }
        return TypeCheckUtil.isSuperType(oneType, secType);
    }

    public static boolean isSuperType(IJstType fromType, IJstType toType) {
        if (fromType == null || toType == null || fromType.getName() == null || toType.getName() == null) {
            return false;
        }
        if (TypeCheckUtil.isObject(toType)) {
            return true;
        }
        ArrayList<String> list = new ArrayList<String>();
        IJstType stype = fromType.getExtend();
        while (stype != null && stype.getName() != null) {
            list.add(stype.getName());
            stype = stype.getExtend();
        }
        if (toType.getExtend() != null && toType.getExtend().getName() != null) {
            if (fromType.equals(toType.getExtend())) {
                return toType.getPackage() == null;
            }
            return list.contains(toType.getExtend().getName());
        }
        return false;
    }

    public static IJstType getAttributedType(JstAttributedType attributedType) {
        IJstNode attributedBinding = attributedType.getJstBinding();
        if (attributedBinding instanceof IJstProperty) {
            return ((IJstProperty)attributedBinding).getType();
        }
        if (attributedBinding instanceof IJstMethod) {
            return new JstFuncType((IJstMethod)attributedBinding);
        }
        return null;
    }
}

