/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CodeGenCleaner {
    public static final String ALL_OPT = "all";
    public static final String CSS_OPT = "css";
    public static final String JS_OPT = "js";
    private static final String JAVA_SUFFIX = ".java";
    private static final String JSR_SUFFIX = "Jsr.java";
    private static final String JS_SUFFIX = ".js";
    private static final String CCSR_SUFFIX = "Cssr.java";
    private static final String VJ_PKG_SPEC_SUFFIX = "VjPkgSpec.java";
    private static final String CODEGEN_STR = "@org.eclipse.vjet.dsf.resource.utils.CodeGen";
    private static final String CODEGEN_STR_V23 = "Generator: JsRefGenerator23";
    private static FilenameFilter s_cssFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(CodeGenCleaner.CCSR_SUFFIX);
        }
    };
    private static FilenameFilter s_jsFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(CodeGenCleaner.JS_SUFFIX);
        }
    };
    private static FilenameFilter s_allFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(CodeGenCleaner.JS_SUFFIX) || name.endsWith(CodeGenCleaner.CCSR_SUFFIX);
        }
    };
    private static Map<String, FilenameFilter> s_filterMap = new HashMap<String, FilenameFilter>();
    private static boolean s_initialized = false;

    public static void main(String ... args) {
        if (args.length < 1) {
            System.out.println("Usage: CodeGenCleaner all|js|css src_dir_path_1,src_dir_path_2,..,src_dir_path_n  [verbose]");
            System.exit(1);
        }
        CodeGenCleaner.init();
        if (!s_filterMap.containsKey(args[0])) {
            System.out.println("Unknow argument " + args[0]);
            System.exit(1);
        }
        ArrayList<String> srcDirs = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(args[1], ",");
        while (st.hasMoreTokens()) {
            srcDirs.add(st.nextToken());
        }
        boolean verbose = false;
        if (args.length == 3 && args[2].equalsIgnoreCase("verbose")) {
            verbose = true;
        }
        try {
            CodeGenCleaner.clean(args[0], srcDirs, verbose);
        }
        catch (Exception e) {
            System.out.println("Error - " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static int clean(String option, List<String> srcDirs, boolean verbose) {
        int deleted = 0;
        for (String dir : srcDirs) {
            ArrayList<File> answer;
            File f = new File(dir);
            if (!f.exists()) {
                throw new RuntimeException("Directory doesn't exists - " + dir);
            }
            if (!f.isDirectory()) {
                throw new RuntimeException("Not a directory - " + dir);
            }
            if (JS_OPT.equalsIgnoreCase(option) || ALL_OPT.equalsIgnoreCase(option)) {
                answer = new ArrayList<File>();
                CodeGenCleaner.getFiles(f, s_filterMap.get(JS_OPT), answer);
                deleted += CodeGenCleaner.deleteJsFiles(option, answer, verbose);
            }
            if (!CSS_OPT.equalsIgnoreCase(option) && !ALL_OPT.equalsIgnoreCase(option)) continue;
            answer = new ArrayList();
            CodeGenCleaner.getFiles(f, s_filterMap.get(CSS_OPT), answer);
            deleted += CodeGenCleaner.deleteCssrFiles(option, answer, verbose);
        }
        return deleted;
    }

    public static boolean isCodeGened(URL file) {
        return CodeGenCleaner.isCodeGened(file, true);
    }

    public static boolean isCodeGened(File file) {
        try {
            return CodeGenCleaner.isCodeGened(new FileInputStream(file), true);
        }
        catch (Exception e) {
            System.out.println("Error reading file - " + file);
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isCodeGened(File file, boolean checkWritable) {
        try {
            return CodeGenCleaner.isCodeGened(new FileInputStream(file), checkWritable);
        }
        catch (Exception e) {
            System.out.println("Error reading file - " + file);
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isCodeGened(URL file, boolean checkWritable) {
        try {
            return CodeGenCleaner.isCodeGened(file.openStream(), checkWritable);
        }
        catch (Exception e) {
            System.out.println("Error reading file - " + file);
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isCodeGened(InputStream stream, boolean checkWritable) throws IOException {
        BufferedReader br;
        block15: {
            block14: {
                br = null;
                try {
                    String line;
                    br = new BufferedReader(new InputStreamReader(stream));
                    boolean noContent = true;
                    while ((line = br.readLine()) != null) {
                        if (line.length() > 0) {
                            noContent = false;
                        }
                        if (!line.contains(CODEGEN_STR) && !line.contains(CODEGEN_STR_V23)) {
                            continue;
                        }
                        break block14;
                    }
                    if (!noContent) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (br == null) throw throwable;
                        br.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (br == null) return true;
                br.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
        }
        try {
            if (br == null) return false;
            br.close();
            return false;
        }
        catch (IOException iOException) {}
        return false;
    }

    private static int deleteCssrFiles(String option, List<File> list, boolean verbose) {
        int deleted = 0;
        for (File f : list) {
            try {
                if (!CodeGenCleaner.isCodeGened(f.toURI().toURL())) {
                    continue;
                }
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("Could not deleted file " + f);
            }
            deleted += CodeGenCleaner.delete(f, verbose);
        }
        return deleted;
    }

    private static int delete(File f, boolean verbose) {
        if (f.delete()) {
            if (verbose) {
                System.out.println("Deleted file " + f);
            }
            return 1;
        }
        if (verbose) {
            System.out.println("Could not deleted file " + f);
        }
        return 0;
    }

    private static int deleteJsFiles(String option, List<File> list, boolean verbose) {
        int deleted = 0;
        for (File f : list) {
            String pkgSpecPath;
            File jPkgSpec;
            String javaProxyPath;
            File jProxy;
            File jsr;
            int index = f.getAbsolutePath().lastIndexOf(JS_SUFFIX);
            if (index == -1) continue;
            String jsPath = f.getAbsolutePath().substring(0, index);
            String jsrPath = String.valueOf(jsPath) + JSR_SUFFIX;
            if (CodeGenCleaner.isCodeGened(f)) {
                deleted += CodeGenCleaner.delete(f, verbose);
                jsr = new File(jsrPath);
                if (!CodeGenCleaner.isCodeGened(jsr)) continue;
                deleted += CodeGenCleaner.delete(jsr, verbose);
                continue;
            }
            jsr = new File(jsrPath);
            if (CodeGenCleaner.isCodeGened(jsr)) {
                deleted += CodeGenCleaner.delete(jsr, verbose);
            }
            if (CodeGenCleaner.isCodeGened(jProxy = new File(javaProxyPath = String.valueOf(jsPath) + JAVA_SUFFIX))) {
                deleted += CodeGenCleaner.delete(jProxy, verbose);
            }
            if (!(jPkgSpec = new File(pkgSpecPath = CodeGenCleaner.createPkgSpecPath(jsPath))).exists() || jPkgSpec.isDirectory() || !jPkgSpec.canWrite()) continue;
            deleted += CodeGenCleaner.delete(jPkgSpec, verbose);
        }
        return deleted;
    }

    private static String createPkgSpecPath(String path) {
        int lastIndexOfPathSepertor2;
        String pkgName = path.trim();
        int lastIndexOfPathSepertor = pkgName.lastIndexOf(File.separator);
        if (lastIndexOfPathSepertor != -1) {
            pkgName = pkgName.substring(0, lastIndexOfPathSepertor);
        }
        if ((lastIndexOfPathSepertor2 = pkgName.lastIndexOf(File.separator)) != -1) {
            pkgName = pkgName.substring(lastIndexOfPathSepertor2 + 1);
        }
        pkgName = String.valueOf(pkgName.substring(0, 1).toUpperCase()) + pkgName.substring(1);
        if (lastIndexOfPathSepertor != -1) {
            pkgName = String.valueOf(path.substring(0, lastIndexOfPathSepertor + 1)) + "_" + pkgName + VJ_PKG_SPEC_SUFFIX;
        }
        return pkgName;
    }

    private static void getFiles(File src, FilenameFilter filter, List<File> answer) {
        File[] subDirs;
        File[] fileArray = subDirs = src.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        int n = subDirs.length;
        int n2 = 0;
        while (n2 < n) {
            File subDir = fileArray[n2];
            CodeGenCleaner.getFiles(subDir, filter, answer);
            ++n2;
        }
        File[] files = src.listFiles(filter);
        if (files != null) {
            File[] fileArray2 = files;
            int n3 = files.length;
            n = 0;
            while (n < n3) {
                File f = fileArray2[n];
                answer.add(f);
                ++n;
            }
        }
    }

    private static void init() {
        if (!s_initialized) {
            s_filterMap.put(ALL_OPT, s_allFilter);
            s_filterMap.put(JS_OPT, s_jsFilter);
            s_filterMap.put(CSS_OPT, s_cssFilter);
            s_initialized = true;
        }
    }
}

