/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsgen.shared.generate;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jsgen.shared.generate.IJsrTypeProvider;
import org.eclipse.vjet.dsf.jsgen.shared.generate.SimpleParam;
import org.eclipse.vjet.dsf.jsnative.anno.Alias;
import org.eclipse.vjet.dsf.jsnative.global.Object;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.JstWildcardType;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;

public class JsrTypeProvider
implements IJsrTypeProvider {
    private static final String JS_HANDLER_OBJECT_ENUM = "org.eclipse.vjet.vsf.resource.html.event.handler.JsHandlerObjectEnum";
    private static final String JSR = "Jsr";
    private static final String IDAPSVCCALLBACK = "org.eclipse.vjet.dsf.dap.svc.IDapSvcCallback";
    private static final String EVENTPACKAGE = "org.eclipse.vjet.dsf.jsnative.events";
    private static final String OPEN_ANGLE_BRACKET = "<";
    private static final String COMMA = ",";
    private static final String QUESTION_MARK = "?";
    private static final String CLOSE_ANGLE_BRACKET = ">";
    private static final String[] LITERALS = new String[]{"boolean", "byte", "char", "double", "int", "float", "long", "short"};
    Map<String, Mapping> jsToJavaMapping = new LinkedHashMap<String, Mapping>();
    private boolean m_init;
    private Map<String, String> jsToJsrPackageMap = new LinkedHashMap<String, String>();
    private IJstType m_currentType;
    private boolean m_dot;
    private boolean m_enableTypeMapping = true;

    private void initTypeMapping() {
        this.jsToJavaMapping.put("org.eclipse.vjet.dsf.jsnative.global.Boolean", this.createMapping("Boolean", "Boolean"));
        this.jsToJavaMapping.put("org.eclipse.vjet.dsf.jsnative.global.Number", this.createMapping("Number"));
        this.jsToJavaMapping.put("org.eclipse.vjet.dsf.jsnative.global.Date", this.createMapping("Date", "java.util.Date"));
        this.jsToJavaMapping.put("org.eclipse.vjet.dsf.jsnative.global.Object", this.createMapping("Object"));
        this.jsToJavaMapping.put("org.eclipse.vjet.dsf.jsnative.global.ObjLiteral", this.createMapping("Object"));
        this.jsToJavaMapping.put("org.eclipse.vjet.dsf.jsnative.global.String", this.createMapping("String"));
        this.jsToJavaMapping.put("vjo.dsf.Message", this.createMapping("vjo.dsf.MessageJsr"));
        this.jsToJavaMapping.put("vjo.Enum", this.createMapping("JsEnum", "org.eclipse.vjet.vsf.jsref.JsEnum"));
        this.jsToJavaMapping.put("Enum", this.createMapping("JsEnum", "org.eclipse.vjet.vsf.jsref.JsEnum"));
        this.jsToJavaMapping.put("org.eclipse.vjet.dsf.jsnative.HtmlElement", this.createMapping("org.eclipse.vjet.vsf.jsbrowser.jsr.HTMLElementJsr"));
        this.jsToJavaMapping.put("org.eclipse.vjet.dsf.jsnative.HtmlDocument", this.createMapping("org.eclipse.vjet.vsf.jsbrowser.jsr.HTMLDocumentJsr"));
        this.jsToJavaMapping.put("java.lang.Boolean", this.createMapping("Boolean", "Boolean"));
        this.jsToJavaMapping.put("java.lang.Number", this.createMapping("double"));
        this.jsToJavaMapping.put("java.util.Date", this.createMapping("Date", "java.util.Date"));
        this.jsToJavaMapping.put("java.lang.Object", this.createMapping("Object"));
        this.jsToJavaMapping.put("org.eclipse.vjet.dsf.dap.proxy.OL", this.createMapping("Object"));
        this.jsToJavaMapping.put("java.lang.String", this.createMapping("String"));
        this.jsToJavaMapping.put(IDAPSVCCALLBACK, this.createMapping(IDAPSVCCALLBACK));
        this.jsToJavaMapping.put("Boolean", this.createMapping("Boolean", "Boolean"));
        this.jsToJavaMapping.put("boolean", this.createMapping("boolean", "Boolean"));
        this.jsToJavaMapping.put("byte", this.createMapping("byte", "Byte"));
        this.jsToJavaMapping.put("char", this.createMapping("char", "Character"));
        this.jsToJavaMapping.put("double", this.createMapping("double", "Double"));
        this.jsToJavaMapping.put("int", this.createMapping("int", "Integer"));
        this.jsToJavaMapping.put("float", this.createMapping("float", "Float"));
        this.jsToJavaMapping.put("long", this.createMapping("long", "Long"));
        this.jsToJavaMapping.put("short", this.createMapping("short", "Short"));
        this.jsToJavaMapping.put("Date", this.createMapping("Date", "java.util.Date"));
        this.jsToJavaMapping.put("Number", this.createMapping("java.lang.Number"));
        this.jsToJavaMapping.put("Object", this.createMapping("Object"));
        this.jsToJavaMapping.put("vjo.Object", this.createMapping("Object"));
        this.jsToJavaMapping.put("ObjLiteral", this.createMapping("Object"));
        this.jsToJavaMapping.put("String", this.createMapping("String", "String"));
        this.jsToJavaMapping.put("void", this.createMapping("Void", "Void"));
    }

    private void initPackageMapping() {
        this.jsToJsrPackageMap.put("org.eclipse.vjet.dsf.jsnative.global", "org.eclipse.vjet.vsf.jsnative.jsr");
        this.jsToJsrPackageMap.put(EVENTPACKAGE, "org.eclipse.vjet.vsf.jsbrowser.jsr");
        this.jsToJsrPackageMap.put("org.eclipse.vjet.dsf.jsnative.file", "org.eclipse.vjet.vsf.jsbrowser.jsr");
        this.jsToJsrPackageMap.put("org.eclipse.vjet.dsf.jsnative", "org.eclipse.vjet.vsf.jsbrowser.jsr");
    }

    private Mapping createMapping(String both) {
        return this.createMapping(both, both);
    }

    private Mapping createMapping(String primitiveType, String wrapperType) {
        Mapping mapping = new Mapping();
        mapping.primitiveType = primitiveType;
        mapping.wrapperType = wrapperType;
        return mapping;
    }

    @Override
    public String getJavaTypeFullName(IJstType type, IJsrTypeProvider.Type ... t) {
        return this.getJavaFullName(type, true, t);
    }

    @Override
    public String getJavaTypeSimpleName(IJstType type, IJsrTypeProvider.Type ... t) {
        return this.getJavaFullName(type, false, t);
    }

    private String getJavaFullName(IJstType type, boolean isFull, IJsrTypeProvider.Type ... t) {
        boolean primitive = false;
        boolean qualified = false;
        boolean addParams = false;
        boolean ignoretypemap = false;
        IJsrTypeProvider.Type[] typeArray = t;
        int n = t.length;
        int n2 = 0;
        while (n2 < n) {
            IJsrTypeProvider.Type atype = typeArray[n2];
            if (atype != null) {
                if (atype == IJsrTypeProvider.Type.Qualified) {
                    qualified = true;
                }
                if (atype.equals((java.lang.Object)IJsrTypeProvider.Type.Primitive)) {
                    primitive = true;
                }
                if (atype.equals((java.lang.Object)IJsrTypeProvider.Type.IgnoreTypeMap)) {
                    ignoretypemap = true;
                }
                if (atype.equals((java.lang.Object)IJsrTypeProvider.Type.AddParams)) {
                    addParams = true;
                }
            }
            ++n2;
        }
        if (type == null || type.getAlias() == null) {
            if (primitive) {
                return "void";
            }
            return "Void";
        }
        return this.getJavaTypeName(type, isFull, qualified, primitive, ignoretypemap, addParams);
    }

    private String getJavaTypeName(IJstType type, boolean isFull, boolean isQualified, boolean isPrimitive, boolean ignoretypemap, boolean addParams) {
        JstWildcardType wctype;
        if (!this.m_init) {
            this.init();
        }
        String suffix = JSR;
        String typeName = type.getAlias();
        String simpleTypeName = type.getSimpleName();
        String arraySuffix = "";
        if (type instanceof JstMixedType) {
            return "Object";
        }
        if (type instanceof JstWildcardType && (wctype = (JstWildcardType)type).getType() instanceof JstParamType) {
            return type.getName();
        }
        if (type instanceof JstParamType) {
            if (isFull) {
                return typeName;
            }
            return simpleTypeName;
        }
        boolean isAry = false;
        if (type instanceof JstArray) {
            isAry = true;
            JstArray ary = (JstArray)type;
            int i = 0;
            while (i < ary.getDimensions()) {
                arraySuffix = String.valueOf(arraySuffix) + "[]";
                ++i;
            }
            IJsrTypeProvider.Type[] filters = new IJsrTypeProvider.Type[2];
            if (isPrimitive) {
                filters[0] = IJsrTypeProvider.Type.Primitive;
            }
            if (isQualified) {
                filters[1] = IJsrTypeProvider.Type.Qualified;
            }
            if (isFull) {
                return String.valueOf(this.getJavaTypeFullName(ary.getElementType(), filters)) + arraySuffix;
            }
            return String.valueOf(this.getJavaTypeSimpleName(ary.getElementType(), filters)) + arraySuffix;
        }
        Mapping mapping = this.jsToJavaMapping.get(typeName);
        String mappingType = this.determineType(isFull, isPrimitive, mapping);
        int typeNameIndexOfDot = typeName.lastIndexOf(".");
        if (!ignoretypemap) {
            String pkg;
            if (mappingType != null && !this.typeInNeeds(mapping)) {
                if (isPrimitive && simpleTypeName.equals("Boolean")) {
                    System.out.println("WARNING BOOLEAN USAGE IN " + this.m_currentType.getName());
                }
                if (isAry) {
                    return String.valueOf(mappingType) + arraySuffix;
                }
                return mappingType;
            }
            if (isFull) {
                pkg = "";
                if (typeNameIndexOfDot != -1) {
                    pkg = typeName.substring(0, typeNameIndexOfDot);
                }
                if (this.jsToJsrPackageMap.get(pkg) != null) {
                    simpleTypeName = this.simpleNameFromAlias(type);
                    return String.valueOf(this.jsToJsrPackageMap.get(pkg)) + "." + simpleTypeName + suffix;
                }
            } else {
                pkg = "";
                if (typeNameIndexOfDot != -1) {
                    pkg = typeName.substring(0, typeNameIndexOfDot);
                }
                if (this.jsToJsrPackageMap.get(pkg) != null) {
                    simpleTypeName = this.simpleNameFromAlias(type);
                    return String.valueOf(simpleTypeName) + suffix;
                }
            }
        }
        if (type instanceof JstParamType) {
            return type.getName();
        }
        if (type.isEmbededType()) {
            return this.determineEmbeddedJsrName(type, isFull, isQualified);
        }
        if (type instanceof JstObjectLiteralType) {
            return this.determineObjLiteralTypeName(type, isFull, isQualified);
        }
        if (type instanceof IJstRefType) {
            IJstRefType tempType = (IJstRefType)type;
            return this.determineTypeRefType(tempType, isAry, suffix, mappingType, typeNameIndexOfDot);
        }
        if (type instanceof JstFunctionRefType) {
            return this.determineFunctionRefType(type, isFull, isQualified);
        }
        if (addParams && type instanceof JstTypeWithArgs) {
            JstTypeWithArgs targs = (JstTypeWithArgs)type;
            return this.determineTypeWithArgs(targs, isFull, isQualified);
        }
        if (type instanceof JstType) {
            JstType jstType = (JstType)type;
            if (type.isClass() && jstType.getExtends().size() == 0) {
                return type.getName();
            }
        }
        return this.defaultJsr(isFull, suffix, typeName, simpleTypeName, typeNameIndexOfDot);
    }

    private String determineTypeWithArgs(JstTypeWithArgs templatedType, boolean isFull, boolean isQualified) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getJavaTypeName(templatedType.getType(), isFull, isQualified, false, false, true)).append(OPEN_ANGLE_BRACKET);
        int i = 0;
        for (IJstType p : templatedType.getArgTypes()) {
            if (i++ > 0) {
                sb.append(COMMA);
            }
            if (p instanceof JstWildcardType) {
                sb.append(QUESTION_MARK);
                if (QUESTION_MARK.equals(p.getSimpleName())) continue;
                if (((JstWildcardType)p).isUpperBound()) {
                    sb.append(" extends ").append(this.getJavaTypeName(p, isFull, isQualified, false, false, true));
                    continue;
                }
                if (!((JstWildcardType)p).isLowerBound()) continue;
                sb.append(" super ").append(this.getJavaTypeName(p, isFull, isQualified, false, false, true));
                continue;
            }
            if (p instanceof JstTypeWithArgs) {
                JstTypeWithArgs p2 = (JstTypeWithArgs)p;
                sb.append(this.determineTypeWithArgs(p2, isFull, isQualified));
                continue;
            }
            sb.append(this.getJavaTypeName(p, isFull, isQualified, false, false, true));
        }
        sb.append(CLOSE_ANGLE_BRACKET);
        return sb.toString();
    }

    private String simpleNameFromAlias(IJstType type) {
        if (type.getPackage() == null || type.getPackage().getName() == "") {
            return type.getSimpleName();
        }
        IJstAnnotation annotation = type.getAnnotation("Alias");
        if (annotation != null) {
            return ((IExpr)annotation.values().get(0)).toExprText().replace("\"", "");
        }
        return type.getSimpleName();
    }

    private boolean typeInNeeds(Mapping mapping) {
        if (this.m_currentType != null) {
            for (IJstType t : this.m_currentType.getInactiveImports()) {
                if (!t.getName().equals(mapping.wrapperType)) continue;
                return true;
            }
        }
        return false;
    }

    private String determineTypeRefType(IJstRefType tempType, boolean isFull, String suffix, String typeName, int typeNameIndexOfDot) {
        String simpleTypeName = tempType.getReferencedNode().getSimpleName();
        return "JsTypeRef<" + this.defaultJsr(isFull, suffix, typeName, simpleTypeName, typeNameIndexOfDot) + CLOSE_ANGLE_BRACKET;
    }

    private String determineFunctionRefType(IJstType type, boolean isFull, boolean isQualified) {
        JstFunctionRefType tempType = (JstFunctionRefType)type;
        IJstType jstType = (IJstType)tempType.getParentNode();
        String funcTypeName = tempType.getMethodRef().getName() + JSR;
        String containerTypeName = String.valueOf(jstType.getSimpleName()) + JSR;
        if (isFull) {
            return String.valueOf(jstType.getPackage().getName()) + "." + containerTypeName + "." + funcTypeName;
        }
        if (isQualified) {
            return String.valueOf(containerTypeName) + "." + funcTypeName;
        }
        return funcTypeName;
    }

    private String determineObjLiteralTypeName(IJstType type, boolean isFull, boolean isQualified) {
        IJstType parent = (IJstType)type.getParentNode();
        if (isFull) {
            return String.valueOf(parent.getPackage().getName()) + parent.getSimpleName() + JSR + "." + type.getSimpleName() + JSR;
        }
        if (isQualified) {
            return String.valueOf(parent.getSimpleName()) + JSR + "." + type.getSimpleName() + JSR;
        }
        return String.valueOf(type.getSimpleName()) + JSR;
    }

    private String determineEmbeddedJsrName(IJstType type, boolean isFull, boolean isQualified) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean nested = type.getOuterType().isEmbededType();
        this.determineEmbeddedJsrName(type, isFull, !isQualified ? nested : isQualified, stringBuilder);
        this.m_dot = false;
        return stringBuilder.toString();
    }

    private void determineEmbeddedJsrName(IJstType type, boolean isFull, boolean isQualified, StringBuilder b) {
        String suffix = JSR;
        if (type.getOuterType() != null) {
            boolean nested = type.getOuterType().isEmbededType();
            this.determineEmbeddedJsrName(type.getOuterType(), isFull, !isQualified ? nested : isQualified, b);
            if (isQualified || isFull) {
                this.addDot(b);
                this.m_dot = false;
            }
            b.append(type.getSimpleName());
            b.append(suffix);
        } else if (isFull) {
            b.append(type.getPackage().getName());
            this.addDot(b);
            this.m_dot = false;
            b.append(type.getSimpleName());
            b.append(suffix);
        } else if (isQualified) {
            b.append(type.getSimpleName());
            b.append(suffix);
            this.addDot(b);
        }
    }

    private void addDot(StringBuilder b) {
        if (!this.m_dot) {
            b.append(".");
            this.m_dot = true;
        }
    }

    private String defaultJsr(boolean isFull, String suffix, String typeName, String simpleTypeName, int typeNameIndexOfDot) {
        if (!isFull && typeNameIndexOfDot != -1) {
            typeName = simpleTypeName;
        }
        return String.valueOf(typeName) + suffix;
    }

    private String determineType(boolean isFull, boolean isPrimitive, Mapping mapping) {
        if (mapping == null) {
            return null;
        }
        String mappingType = mapping.wrapperType;
        if (isPrimitive) {
            mappingType = mapping.primitiveType;
        }
        if (!isFull && mappingType.indexOf(46) != -1) {
            mappingType = mappingType.substring(mappingType.lastIndexOf(46) + 1, mappingType.length());
        }
        return mappingType;
    }

    private void init() {
        this.initTypeMapping();
        this.initPackageMapping();
    }

    @Override
    public boolean isExcludedFromImport(IJstType type) {
        String mappedTypeName = type.getAlias();
        if (mappedTypeName == null) {
            return false;
        }
        return mappedTypeName.contains("String");
    }

    @Override
    public boolean isInactiveImport(IJstType type) {
        Mapping mapping;
        if (!this.m_init) {
            this.init();
            this.m_init = true;
        }
        if ((mapping = this.jsToJavaMapping.get(type.getAlias())) != null && mapping.isInactive) {
            return true;
        }
        String name = this.getPkg(type);
        return this.jsToJsrPackageMap.containsKey(name);
    }

    private String getOriginalJavaPkg(IJstType type) {
        if (type.getAlias() != null && type.getAlias().indexOf(".") != -1) {
            return type.getAlias().substring(0, type.getAlias().lastIndexOf("."));
        }
        return "";
    }

    private String getPkg(IJstType type) {
        String name = "";
        IJstAnnotation annotation = type.getAnnotation(Alias.class.getSimpleName());
        if (type.getPackage() != null) {
            name = type.getPackage().getName();
        } else if (annotation != null && type.getAlias().indexOf(".") != -1) {
            name = this.getAliasTypeSimpleName(annotation, type);
        }
        return name;
    }

    private String getAliasTypeSimpleName(IJstAnnotation annotation, IJstType type) {
        return ((IExpr)annotation.values().get(0)).toExprText();
    }

    @Override
    public boolean isMappedEventType(IJstType type) {
        if (!this.m_enableTypeMapping) {
            return false;
        }
        return false;
    }

    @Override
    public boolean supportsValueBinding(List<SimpleParam> list) {
        if (list.isEmpty()) {
            return false;
        }
        if (list.size() == 1 && this.isObjectType(list.get((int)0).m_type)) {
            return false;
        }
        for (SimpleParam param : list) {
            boolean hasmapping = false;
            if (param.m_mappedName != null) {
                hasmapping = true;
            }
            IJstType type = param.getType();
            if (hasmapping || !this.supportValueBindingInternal(type)) continue;
            return true;
        }
        return false;
    }

    private boolean supportValueBindingInternal(IJstType type) {
        if (!this.m_init) {
            this.init();
            this.m_init = true;
        }
        if (type instanceof JstArray) {
            JstArray jstArray = (JstArray)type;
            type = jstArray.getElementType();
        }
        if (this.isMappedEventType(type)) {
            return false;
        }
        if (type.getName().equals(JS_HANDLER_OBJECT_ENUM)) {
            return false;
        }
        if (this.isMappedEventType(type)) {
            return false;
        }
        return !this.isJsObject(type);
    }

    private boolean isJsObject(IJstType type) {
        JstType object = JstCache.getInstance().getType("Object");
        if (object == null) {
            object = JstCache.getInstance().getType(Object.class.getName());
        }
        return type.equals(object);
    }

    private boolean isObjectType(IJstType type) {
        String name = DataTypeHelper.getTypeName((String)type.getName());
        if ("java.lang.Object".equals(name) || "Object".equals(name) || Object.class.getName().equals(name)) {
            return true;
        }
        if (type instanceof JstRefType) {
            return ((JstRefType)type).getRefType() == Object.class;
        }
        return false;
    }

    @Override
    public void setCurrentType(IJstType currentType) {
        this.m_currentType = currentType;
    }

    @Override
    public boolean isBrowserEventType(IJstType argType) {
        String pkg = this.getPkg(argType);
        if (pkg.equals("")) {
            pkg = this.getOriginalJavaPkg(argType);
        }
        return pkg.equals(EVENTPACKAGE);
    }

    @Override
    public boolean supportsValueBinding(IJstType argType) {
        return this.supportValueBindingInternal(argType);
    }

    public boolean isEnableTypeMapping() {
        return this.m_enableTypeMapping;
    }

    @Override
    public void setEnableTypeMapping(boolean enableTypeMapping) {
        this.m_enableTypeMapping = enableTypeMapping;
    }

    @Override
    public boolean isObject(IJstType type) {
        JstType object = JstCache.getInstance().getType("Object");
        if (object == null) {
            object = JstCache.getInstance().getType(Object.class.getName());
        }
        return type.equals(object);
    }

    @Override
    public boolean shouldImport(IJstType type) {
        return type.getName().equals("vjo.dsf.Message");
    }

    @Override
    public boolean isLiteral(IJstType type) {
        String[] stringArray = LITERALS;
        int n = LITERALS.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (type.getSimpleName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    static class Mapping {
        String primitiveType;
        String wrapperType;
        public boolean isInactive = true;

        Mapping() {
        }
    }
}

