/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.util;

import org.eclipse.vjet.dsf.jsnative.anno.BrowserSupport;
import org.eclipse.vjet.dsf.jsnative.anno.BrowserType;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.token.IExpr;

public class SupportedBrowser {
    public static boolean isIE6Plus(IJstAnnotation annot) {
        return SupportedBrowser.isSupportedBy(annot, BrowserType.IE_6P);
    }

    public static boolean isIE7Plus(IJstAnnotation annot) {
        return SupportedBrowser.isSupportedBy(annot, BrowserType.IE_7P);
    }

    public static boolean isIE8Plus(IJstAnnotation annot) {
        return SupportedBrowser.isSupportedBy(annot, BrowserType.IE_8P);
    }

    public static boolean isFF1Plus(IJstAnnotation annot) {
        return SupportedBrowser.isSupportedBy(annot, BrowserType.FIREFOX_1P);
    }

    public static boolean isFF2Plus(IJstAnnotation annot) {
        return SupportedBrowser.isSupportedBy(annot, BrowserType.FIREFOX_2P);
    }

    public static boolean isFF3Plus(IJstAnnotation annot) {
        return SupportedBrowser.isSupportedBy(annot, BrowserType.FIREFOX_3P);
    }

    public static boolean isOpera7Plus(IJstAnnotation annot) {
        return SupportedBrowser.isSupportedBy(annot, BrowserType.OPERA_7P);
    }

    public static boolean isOpera8Plus(IJstAnnotation annot) {
        return SupportedBrowser.isSupportedBy(annot, BrowserType.OPERA_8P);
    }

    public static boolean isOpera9Plus(IJstAnnotation annot) {
        return SupportedBrowser.isSupportedBy(annot, BrowserType.OPERA_9P);
    }

    public static boolean isSafari3Plus(IJstAnnotation annot) {
        return SupportedBrowser.isSupportedBy(annot, BrowserType.SAFARI_3P);
    }

    public static boolean isSupportedBy(IJstAnnotation annot, BrowserType browserType) {
        if (!BrowserSupport.class.getSimpleName().equals(annot.getName().toString())) {
            return false;
        }
        String name = browserType.getName();
        int version = browserType.getVersion();
        for (IExpr expr : annot.values()) {
            String[] supportedBrowsers;
            if (!(expr instanceof JstArrayInitializer)) continue;
            JstArrayInitializer init = (JstArrayInitializer)expr;
            String browsers = init.toExprText();
            browsers = browsers.substring(browsers.indexOf(91) + 1, browsers.indexOf(93));
            String[] stringArray = supportedBrowsers = browsers.split(",");
            int n = supportedBrowsers.length;
            int n2 = 0;
            while (n2 < n) {
                BrowserType bType;
                String browser = stringArray[n2];
                int dotIndex = browser.indexOf(46);
                if (dotIndex > 0 && (bType = BrowserType.valueOf((String)browser.substring(dotIndex + 1))) != null) {
                    String bName = bType.getName();
                    int bVersion = bType.getVersion();
                    if (name.equals(bName)) {
                        return browserType.isPlus() ? version >= bVersion : version == bVersion;
                    }
                }
                ++n2;
            }
        }
        return false;
    }
}

