/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.post;

import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.JstVisitorAdapter;

public class DirectDependencyVisitor
extends JstVisitorAdapter {
    private int m_inStmt = 0;

    public boolean visit(IJstNode node) {
        if (this.m_inStmt < 1 || node == null) {
            return true;
        }
        IJstType rootType = node.getRootType();
        if (node instanceof ObjCreationExpr) {
            this.addDirectDependency(((ObjCreationExpr)node).getResultType(), rootType);
            return true;
        }
        if (node instanceof JstIdentifier) {
            JstIdentifier identifier = (JstIdentifier)node;
            if (TranslateHelper.Type.getLocalVarType(identifier.getName(), node) != null) {
                return true;
            }
            IJstNode binding = identifier.getJstBinding();
            if (binding == null || !(binding instanceof JstType)) {
                return true;
            }
            JstType jstType = (JstType)binding;
            String name = jstType.getSimpleName();
            if (name == null) {
                return true;
            }
            this.addDirectDependency((IJstType)jstType, rootType);
            return true;
        }
        if (node instanceof JstProperty) {
            AssignExpr aExpr;
            JstProperty prop = (JstProperty)node;
            if (prop.getInitializer() != null && prop.getInitializer() instanceof AssignExpr && (aExpr = (AssignExpr)prop.getInitializer()).getExpr() instanceof ObjCreationExpr) {
                this.addDirectDependency(((ObjCreationExpr)aExpr.getExpr()).getResultType(), rootType);
                return true;
            }
            return true;
        }
        if (node instanceof JstType || node instanceof JstTypeWithArgs || node instanceof JstTypeReference) {
            JstType type = null;
            if (node instanceof JstTypeWithArgs) {
                type = (JstType)((JstTypeWithArgs)node).getType();
            } else if (node instanceof JstTypeReference) {
                IJstType tmp = ((JstTypeReference)node).getReferencedType();
                if (tmp instanceof JstTypeWithArgs) {
                    type = (JstType)((JstTypeWithArgs)tmp).getType();
                } else if (tmp instanceof JstType) {
                    type = (JstType)tmp;
                }
            } else {
                type = (JstType)node;
            }
            if (this.isUsedInDispatch(type, rootType)) {
                this.addDirectDependency((IJstType)type, rootType);
            }
            return true;
        }
        return true;
    }

    private boolean isUsedInDispatch(JstType type, IJstType currentType) {
        if (type == null || currentType.equals(type)) {
            return false;
        }
        for (IJstMethod mtd : currentType.getMethods()) {
            for (IJstMethod ovMtd : mtd.getOverloaded()) {
                if (ovMtd.getArgs().size() == 0) continue;
                for (JstArg arg : ovMtd.getArgs()) {
                    if (!this.isInImports(arg.getType(), currentType)) continue;
                    return true;
                }
            }
        }
        if (currentType.getConstructor() != null) {
            for (IJstMethod ovMtd : currentType.getConstructor().getOverloaded()) {
                if (ovMtd.getArgs().size() == 0) continue;
                for (JstArg arg : ovMtd.getArgs()) {
                    if (!this.isInImports(arg.getType(), currentType)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isInImports(IJstType type, IJstType currentType) {
        for (IJstType itm : currentType.getImports()) {
            if (!type.getName().equals(itm.getName())) continue;
            return true;
        }
        return false;
    }

    public void preVisit(IJstNode node) {
        if (this.isProcess(node)) {
            ++this.m_inStmt;
        }
    }

    public void postVisit(IJstNode node) {
        if (this.isProcess(node)) {
            --this.m_inStmt;
        }
    }

    private boolean isProcess(IJstNode node) {
        return node instanceof IStmt || node instanceof IJstProperty || node instanceof JstType || node instanceof JstTypeWithArgs;
    }

    private void addDirectDependency(IJstType jstType, IJstType targetType) {
        if (jstType == null) {
            return;
        }
        IJstType type = jstType;
        while (type.getOuterType() != null) {
            type = type.getOuterType();
        }
        if (type instanceof JstTypeWithArgs) {
            type = ((JstTypeWithArgs)type).getType();
        }
        TranslateCtx.ctx().getTranslateInfo((JstType)targetType).addActiveImport(type);
    }
}

