/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.policy;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.vjet.dsf.javatojs.translate.policy.Pkg;

public class ExclusionPolicyModel {
    private List<Pkg> s_pkgs = new ArrayList<Pkg>();
    private List<String> s_classes = new ArrayList<String>();
    private List<String> s_classes_regExp = new ArrayList<String>();

    boolean isClassExcluded(String clsName) {
        for (String classNameExp : this.s_classes_regExp) {
            if (!Pattern.matches(classNameExp, clsName)) continue;
            return true;
        }
        for (Pkg p : this.s_pkgs) {
            if (!p.containsClass(clsName)) continue;
            return true;
        }
        return false;
    }

    void add(String className) {
        this.s_classes.add(className);
        this.s_classes_regExp.add(this.wildcardToRegex(className));
    }

    void add(Pkg pkg) throws RuntimeException {
        this.s_pkgs.add(pkg);
    }

    public String wildcardToRegex(String wildcard) {
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append('^');
        int i = 0;
        int is = wildcard.length();
        while (i < is) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    break;
                }
                case '?': {
                    s.append(".");
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    break;
                }
                default: {
                    s.append(c);
                }
            }
            ++i;
        }
        s.append('$');
        return s.toString();
    }
}

