/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.custom;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.custom.ICustomTranslator;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;

public class CustomTranslateDelegator
extends BaseTranslator
implements ICustomTranslator {
    @Override
    public void initialize(JstType jstType) {
        List<ICustomTranslator> cts = this.getCtx().getConfig().getCustomTranslators();
        for (ICustomTranslator t : cts) {
            t.initialize(jstType);
        }
    }

    @Override
    public IJstType processType(String javaTypeName, ASTNode astNode, BaseJstNode jstNode) {
        List<ICustomTranslator> cts = this.getCtx().getConfig().getCustomTranslators();
        for (ICustomTranslator t : cts) {
            IJstType toType = t.processType(javaTypeName, astNode, jstNode);
            if (toType == null) continue;
            return toType;
        }
        return null;
    }

    @Override
    public JstIdentifier processIdentifier(Name name, boolean hasSuper, boolean hasThis, IExpr jstQualifier, JstIdentifier jstIdentifier, BaseJstNode jstNode) {
        JstIdentifier identifier = null;
        List<ICustomTranslator> cts = this.getCtx().getConfig().getCustomTranslators();
        for (ICustomTranslator t : cts) {
            identifier = t.processIdentifier(name, hasSuper, hasThis, jstQualifier, jstIdentifier, jstNode);
            if (identifier == null) continue;
            return identifier;
        }
        return null;
    }

    @Override
    public IExpr processInstanceCreation(ClassInstanceCreation cic, IExpr jstQualifier, IJstType jstType, List<IExpr> jstArgs, BaseJstNode jstNode) {
        IExpr rtnExpr = null;
        List<ICustomTranslator> cts = this.getCtx().getConfig().getCustomTranslators();
        for (ICustomTranslator t : cts) {
            rtnExpr = t.processInstanceCreation(cic, jstQualifier, jstType, jstArgs, jstNode);
            if (rtnExpr == null) continue;
            return rtnExpr;
        }
        return null;
    }

    @Override
    public IExpr processMtdInvocation(ASTNode astNode, boolean hasSuper, IExpr jstQualifier, JstIdentifier jstIdentifier, List<IExpr> jstArgs, BaseJstNode jstNode) {
        IExpr expr = null;
        List<ICustomTranslator> cts = this.getCtx().getConfig().getCustomTranslators();
        for (ICustomTranslator t : cts) {
            expr = t.processMtdInvocation(astNode, hasSuper, jstQualifier, jstIdentifier, jstArgs, jstNode);
            if (expr == null) continue;
            return expr;
        }
        return null;
    }

    @Override
    public boolean processMethodBody(MethodDeclaration astMtd, JstMethod jstMtd) {
        List<ICustomTranslator> cts = this.getCtx().getConfig().getCustomTranslators();
        for (ICustomTranslator t : cts) {
            if (!t.processMethodBody(astMtd, jstMtd)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean processTypeBody(List<?> bodyDeclaration, JstType jstType) {
        List<ICustomTranslator> cts = this.getCtx().getConfig().getCustomTranslators();
        for (ICustomTranslator t : cts) {
            if (!t.processTypeBody(bodyDeclaration, jstType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JstIdentifier getStaticTypeQualifier(IJstType jstType, BaseJstNode jstNode) {
        JstIdentifier identifier = null;
        List<ICustomTranslator> cts = this.getCtx().getConfig().getCustomTranslators();
        for (ICustomTranslator t : cts) {
            identifier = t.getStaticTypeQualifier(jstType, jstNode);
            if (identifier == null) continue;
            return identifier;
        }
        return null;
    }
}

