/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.config.MethodKey;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.stmt.JstBlockInitializer;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public class VjoTranslateHelper {
    private static Set<String> s_vjoNativeTypes = new HashSet<String>();

    static {
        s_vjoNativeTypes.add("vjo.Object");
        s_vjoNativeTypes.add("vjo.Enum");
        s_vjoNativeTypes.add("vjo.Class");
        s_vjoNativeTypes.add("document");
        s_vjoNativeTypes.add("window");
    }

    public static boolean isVjoObjectType(IJstType type) {
        return type != null && "vjo.Object".equals(type.getName());
    }

    public static boolean isVjoNativeType(String name) {
        return s_vjoNativeTypes.contains(name);
    }

    public static boolean isVjoJdkType(String name) {
        return name != null && name.startsWith("org.eclipse.vjet.vjo.java.");
    }

    public static IExpr processTypeLiteral(IJstType type, BaseJstNode jstNode) {
        JstIdentifier jstQualifier = null;
        if (!type.getModifiers().isStatic()) {
            jstQualifier = new JstIdentifier(VjoConvention.getType((String)type.getName()));
            jstQualifier.setJstBinding((IJstNode)type);
            jstQualifier.setType(type);
        } else {
            jstQualifier = VjoTranslateHelper.getStaticMemberQualifier(type, jstNode);
        }
        if (jstQualifier == null) {
            jstQualifier = new JstIdentifier("vjo.Object");
            JstType objType = JstCache.getInstance().getType("vjo.Object");
            jstQualifier.setJstBinding((IJstNode)objType);
            jstQualifier.setType((IJstType)objType);
        }
        return new FieldAccessExpr(new JstIdentifier(TranslateCtx.ctx().getConfig().getVjoConvention().getClassKeyword()), (IExpr)jstQualifier);
    }

    public static JstIdentifier getStaticPtyOrMtdQualifier(JstIdentifier qualifier, BaseJstNode jstNode) {
        if (qualifier == null) {
            return null;
        }
        return VjoTranslateHelper.getStaticMemberQualifier(TranslateHelper.getJstBindingOwnerType(qualifier), jstNode);
    }

    public static JstIdentifier getStaticTypeQualifier(JstIdentifier qualifier, BaseJstNode jstNode) {
        if (qualifier == null) {
            return null;
        }
        return VjoTranslateHelper.getStaticTypeQualifier(TranslateHelper.getJstBindingOwnerType(qualifier), jstNode);
    }

    public static JstIdentifier getStaticMemberQualifier(IJstType qualifierType, BaseJstNode jstNode) {
        JstIdentifier qualifier = null;
        qualifier = VjoTranslateHelper.getStaticTypeQualifier(qualifierType, jstNode);
        if (qualifier == null) {
            return null;
        }
        if (qualifierType == jstNode.getOwnerType() || qualifierType == null) {
            return qualifier;
        }
        qualifier.setName(String.valueOf(qualifier.getName()) + "." + qualifierType.getSimpleName());
        return qualifier;
    }

    public static JstIdentifier getStaticTypeQualifier(IJstType type, BaseJstNode jstNode) {
        return VjoTranslateHelper.getStaticTypeQualifier(type, jstNode, false);
    }

    public static JstIdentifier getStaticTypeQualifier(IJstType type, BaseJstNode jstNode, boolean enableForceQualify) {
        IJstType qualifierType;
        MethodKey mtdKey;
        TranslateInfo tInfo;
        IJstMethod jstMtd;
        TranslateCtx ctx = TranslateCtx.ctx();
        if (ctx.isJsType(type)) {
            return null;
        }
        boolean forceFullyQualify = false;
        if (enableForceQualify && (jstMtd = TranslateHelper.Method.getOwnerMethod((IJstNode)jstNode)) != null && jstMtd.getOwnerType() instanceof JstType && (tInfo = ctx.getTranslateInfo((JstType)jstMtd.getOwnerType())).getMethodCustomInfo(mtdKey = MethodKey.genMethodKey(jstMtd)).isForceFullyQualify()) {
            forceFullyQualify = true;
        }
        if ((qualifierType = type) instanceof JstTypeWithArgs) {
            qualifierType = ((JstTypeWithArgs)qualifierType).getType();
        }
        if (jstNode == null || jstNode.getOwnerType() == null) {
            return null;
        }
        JstType ownerType = jstNode.getOwnerType();
        JstIdentifier jstQualifier = ctx.getProvider().getCustomTranslator().getStaticTypeQualifier(type, jstNode);
        if (jstQualifier != null) {
            String name = jstQualifier.getName();
            if (name == null || name.length() == 0) {
                return null;
            }
            return jstQualifier;
        }
        if (qualifierType != null && ownerType.hasImport(qualifierType.getName()) && qualifierType.getPackage() != null) {
            jstQualifier = new JstIdentifier(qualifierType.getPackage().getName());
            jstQualifier.setJstBinding((IJstNode)qualifierType);
            jstQualifier.setType(qualifierType);
            return jstQualifier;
        }
        if (qualifierType != null && DataTypeHelper.getNativeType((String)qualifierType.getName()) != null) {
            return null;
        }
        if (qualifierType != null && (qualifierType.getName().equals("vjo.Enum") || qualifierType.getName().equals("vjo.Class"))) {
            ctx.getConfig().getVjoConvention();
            return new JstIdentifier(VjoConvention.getVjoNS());
        }
        if (qualifierType == ownerType) {
            jstQualifier = new JstIdentifier(VjoTranslateHelper.getStaticNsRoot((IJstNode)jstNode, forceFullyQualify));
            jstQualifier.setJstBinding((IJstNode)ownerType);
            jstQualifier.setType((IJstType)ownerType);
            return jstQualifier;
        }
        if (qualifierType == null) {
            jstQualifier = new JstIdentifier(VjoTranslateHelper.getStaticNsRoot((IJstNode)jstNode, forceFullyQualify));
            jstQualifier.setJstBinding((IJstNode)ownerType);
            jstQualifier.setType((IJstType)ownerType);
            return jstQualifier;
        }
        if (ownerType.hasImport(qualifierType.getSimpleName())) {
            jstQualifier = new JstIdentifier(VjoTranslateHelper.getStaticNsQualifier(qualifierType, forceFullyQualify, (IJstNode)jstNode));
            jstQualifier.setJstBinding((IJstNode)qualifierType);
            jstQualifier.setType(qualifierType);
            return jstQualifier;
        }
        if (ownerType.getRootType().hasImport(qualifierType.getSimpleName())) {
            jstQualifier = new JstIdentifier(VjoTranslateHelper.getStaticNsQualifier(qualifierType, forceFullyQualify, (IJstNode)jstNode));
            jstQualifier.setJstBinding((IJstNode)qualifierType);
            jstQualifier.setType(qualifierType);
            return jstQualifier;
        }
        if (ownerType.getRootType().hasImport(qualifierType.getName())) {
            jstQualifier = new JstIdentifier(qualifierType.getPackage().getName());
            jstQualifier.setJstBinding((IJstNode)qualifierType);
            jstQualifier.setType(qualifierType);
            return jstQualifier;
        }
        if (qualifierType.isSiblingType()) {
            return VjoTranslateHelper.getStaticTypeQualifier(qualifierType.getContainingType(), jstNode);
        }
        Stack<Object> path = new Stack<IJstType>();
        boolean isDecendent = VjoTranslateHelper.buildEmbededTypePath((IJstType)ownerType, qualifierType, path);
        if (isDecendent) {
            StringBuilder sb = new StringBuilder(VjoTranslateHelper.getStaticNsRoot((IJstNode)jstNode, forceFullyQualify));
            sb.append(ctx.getConfig().getVjoConvention().getInnerStaticPrefix());
            for (IJstType inner : path) {
                if (inner == path.lastElement()) break;
                sb.append(".").append(inner.getSimpleName());
            }
            jstQualifier = new JstIdentifier(sb.toString());
            jstQualifier.setJstBinding((IJstNode)qualifierType);
            jstQualifier.setType(qualifierType);
            return jstQualifier;
        }
        path = new Stack();
        boolean isAncestor = VjoTranslateHelper.buildEmbededTypePath(qualifierType, (IJstType)ownerType, path);
        if (isAncestor) {
            StringBuilder sb = new StringBuilder(VjoTranslateHelper.getStaticNsRoot((IJstNode)qualifierType, forceFullyQualify));
            sb.append(ctx.getConfig().getVjoConvention().getOuterStaticPrefix());
            for (IJstType inner : path) {
                if (inner == path.lastElement()) break;
                sb.append(".").append(inner.getSimpleName());
            }
            jstQualifier = new JstIdentifier(sb.toString());
            jstQualifier.setJstBinding((IJstNode)qualifierType);
            jstQualifier.setType(qualifierType);
            return jstQualifier;
        }
        IJstType rootType = ownerType.getRootType();
        boolean isRelative = VjoTranslateHelper.buildEmbededTypePath(rootType, qualifierType, path = new Stack());
        if (isRelative) {
            StringBuilder sb = new StringBuilder(VjoTranslateHelper.getStaticNsRoot((IJstNode)qualifierType, forceFullyQualify));
            sb.append(ctx.getConfig().getVjoConvention().getOuterStaticPrefix());
            sb.append(".").append(rootType.getSimpleName());
            for (IJstType inner : path) {
                if (inner == path.lastElement()) break;
                sb.append(".").append(inner.getSimpleName());
            }
            jstQualifier = new JstIdentifier(sb.toString());
            jstQualifier.setJstBinding((IJstNode)qualifierType);
            jstQualifier.setType(qualifierType);
            return jstQualifier;
        }
        if (qualifierType.getOuterType() != null && (jstQualifier = VjoTranslateHelper.getStaticTypeQualifier(qualifierType.getOuterType(), jstNode)) != null) {
            StringBuilder sb = new StringBuilder(jstQualifier.getName());
            sb.append(".").append(qualifierType.getOuterType().getSimpleName());
            jstQualifier = new JstIdentifier(sb.toString());
            jstQualifier.setJstBinding((IJstNode)qualifierType);
            jstQualifier.setType(qualifierType);
            return jstQualifier;
        }
        jstQualifier = new JstIdentifier(VjoTranslateHelper.getStaticNsQualifier(qualifierType, forceFullyQualify, (IJstNode)jstNode));
        jstQualifier.setJstBinding((IJstNode)qualifierType);
        jstQualifier.setType(qualifierType);
        return jstQualifier;
    }

    public static JstIdentifier getInstanceTypeQualifier(IExpr optionalExpr, IJstType qualifierType, IJstNode jstNode) {
        if (jstNode == null || jstNode.getOwnerType() == null) {
            return null;
        }
        IJstType ownerType = jstNode.getOwnerType();
        boolean isAnon = ownerType.isAnonymous();
        if (isAnon) {
            IJstNode node = ownerType.getParentNode();
            while (node != null) {
                if (node instanceof IJstType) {
                    ownerType = (IJstType)node;
                    break;
                }
                node = node.getParentNode();
            }
        }
        if (TranslateHelper.isInInstanceBlock(jstNode) && ownerType.getEmbededTypes().size() > 0) {
            Stack<IJstType> path = new Stack<IJstType>();
            IJstType anchor = optionalExpr == null ? ownerType : optionalExpr.getResultType();
            boolean isEmbeded = VjoTranslateHelper.buildEmbededTypePath(anchor, qualifierType, path);
            StringBuilder sb = new StringBuilder();
            VjoConvention vjoConvension = TranslateCtx.ctx().getConfig().getVjoConvention();
            if (optionalExpr == null || optionalExpr.toExprText().equals(VjoConvention.getThisPrefix())) {
                if (isAnon) {
                    sb.append(VjoConvention.getThisPrefix()).append(vjoConvension.getParentInstancePrefix());
                } else {
                    sb.append(VjoTranslateHelper.getInstanceNsRoot(jstNode));
                }
            }
            sb.append(vjoConvension.getInnerStaticPrefix());
            if (isEmbeded) {
                for (IJstType inner : path) {
                    if (sb.length() > 0) {
                        sb.append(".");
                    }
                    sb.append(inner.getSimpleName());
                }
            }
            JstIdentifier jstQualifier = new JstIdentifier(sb.toString());
            jstQualifier.setJstBinding((IJstNode)qualifierType);
            jstQualifier.setType(qualifierType);
            return jstQualifier;
        }
        if (!ownerType.hasImport(qualifierType.getSimpleName()) && ownerType.hasImport(qualifierType.getName())) {
            return new JstIdentifier(qualifierType.getName());
        }
        return new JstIdentifier(qualifierType.getSimpleName());
    }

    public static JstIdentifier getInstanceMemberQualifier(IJstType qualifierType, IJstNode jstNode) {
        if (jstNode == null || jstNode.getOwnerType() == null) {
            return null;
        }
        IJstType ownerType = jstNode.getOwnerType();
        String qualifer = VjoTranslateHelper.getOuterQualifier(qualifierType, ownerType);
        if (qualifer != null) {
            StringBuilder sb = new StringBuilder(VjoTranslateHelper.getInstanceNsRoot(jstNode));
            sb.append(qualifer);
            JstIdentifier jstQualifier = new JstIdentifier(sb.toString());
            jstQualifier.setJstBinding((IJstNode)qualifierType);
            jstQualifier.setType(qualifierType);
            return jstQualifier;
        }
        return new JstIdentifier(qualifierType.getSimpleName());
    }

    private static String getStaticNsRoot(IJstNode jstNode, boolean forceFullyQualify) {
        if (forceFullyQualify) {
            return jstNode.getOwnerType().getName();
        }
        if (TranslateHelper.isInInstanceBlock(jstNode) || VjoTranslateHelper.isStaticBlock(jstNode)) {
            TranslateCtx.ctx().getConfig().getVjoConvention();
            return VjoConvention.getNameWithStaticThis((String)jstNode.getOwnerType().getSimpleName());
        }
        TranslateCtx.ctx().getConfig().getVjoConvention();
        return VjoConvention.getThisPrefix();
    }

    private static String getStaticNsQualifier(IJstType jstType, boolean forceFullyQualify, IJstNode jstNode) {
        if (forceFullyQualify && !(jstType instanceof JstRefType)) {
            return jstType.getOwnerType().getPackage().getName();
        }
        return TranslateCtx.ctx().getConfig().getVjoConvention().getShortHandNS();
    }

    private static boolean isStaticBlock(IJstNode jstNode) {
        IJstNode parentNode = jstNode.getParentNode();
        if (parentNode == null) {
            return false;
        }
        if (parentNode instanceof JstBlockInitializer) {
            return ((JstBlockInitializer)parentNode).getModifiers().isStatic();
        }
        return false;
    }

    private static String getInstanceNsRoot(IJstNode jstNode) {
        TranslateCtx.ctx().getConfig().getVjoConvention();
        return VjoConvention.getThisPrefix();
    }

    private static String getOuterQualifier(IJstType outerType, IJstType type) {
        IJstType embededType = type;
        if (embededType instanceof JstTypeWithArgs) {
            embededType = ((JstTypeWithArgs)embededType).getType();
        }
        String prefix = TranslateCtx.ctx().getConfig().getVjoConvention().getOuterInstancePrefix();
        if (embededType.isAnonymous()) {
            return TranslateCtx.ctx().getConfig().getVjoConvention().getParentInstancePrefix();
        }
        IJstType parent = embededType.getOuterType();
        String qualifier = prefix;
        while (parent != null) {
            if (parent == outerType) {
                return qualifier;
            }
            IJstType extend = parent.getExtend();
            while (extend != null) {
                if (outerType.getParamNames().isEmpty() ? extend == outerType : extend instanceof JstTypeWithArgs && ((JstTypeWithArgs)extend).getType() == outerType) {
                    return qualifier;
                }
                extend = extend.getExtend();
            }
            parent = parent.getOuterType();
            qualifier = String.valueOf(qualifier) + prefix;
        }
        return null;
    }

    private static boolean buildEmbededTypePath(IJstType outerType, IJstType type, Stack<IJstType> path) {
        IJstType embededType = type;
        if (embededType instanceof JstTypeWithArgs) {
            embededType = ((JstTypeWithArgs)embededType).getType();
        }
        for (IJstType inner : outerType.getEmbededTypes()) {
            path.push(inner);
            if (inner == embededType) {
                return true;
            }
            if (VjoTranslateHelper.buildEmbededTypePath(inner, embededType, path)) {
                return true;
            }
            path.pop();
        }
        return false;
    }
}

