/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.vjet.dsf.common.tracer.TraceUtil;
import org.eclipse.vjet.dsf.javatojs.parse.BaseTypeVisitor;
import org.eclipse.vjet.dsf.javatojs.report.ErrorReportPolicy;
import org.eclipse.vjet.dsf.javatojs.report.ErrorReporter;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslationStatus;
import org.eclipse.vjet.dsf.javatojs.util.AstBindingHelper;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.logger.LogLevel;

public class TranslateLogger {
    private TranslateCtx m_ctx;
    private ErrorReportPolicy m_policy;

    public TranslateLogger(ErrorReportPolicy policy) {
        this.m_policy = policy;
        this.m_ctx = TranslateCtx.ctx();
    }

    public void logUnsupportedNode(BaseTranslator translator, ASTNode astNode, BaseJstNode jstNode) {
        this.traceNode(LogLevel.WARN, "UnsupportedNode", translator, astNode, jstNode);
    }

    public void logUnsupportedType(BaseTranslator translator, ASTNode type, JstType ownerType) {
        this.logUnhandledType(translator.getErrorReporter(), type.getClass(), type);
        this.traceType(LogLevel.WARN, "ExcludedType", translator, type, (BaseJstNode)ownerType);
    }

    public void logUnhandledNode(BaseTypeVisitor visitor, ASTNode astNode, BaseJstNode jstNode) {
        this.traceNode(LogLevel.ERROR, "UnhandledNode", (Object)visitor, astNode, jstNode);
    }

    public void logUnhandledNode(BaseTranslator translator, ASTNode astNode, BaseJstNode jstNode) {
        this.logUnhandledNode(translator.getErrorReporter(), astNode.getClass(), jstNode.getOwnerType().getClass(), astNode);
        this.traceNode(LogLevel.ERROR, "UnhandledNode", translator, astNode, jstNode);
    }

    public void logUnhandledNode(ErrorReporter reporter, Class srcType, Class targetType, ASTNode currNode) {
    }

    public void logUnhandledType(BaseTranslator translator, ASTNode type, BaseJstNode jstNode) {
        this.logUnhandledType(translator.getErrorReporter(), type.getClass(), type);
        this.traceType(LogLevel.ERROR, "UnhandledType", translator, type, jstNode);
    }

    public void logUnhandledType(ErrorReporter reporter, Class srcDataType, ASTNode type) {
        String message = "Data type '" + type + "' is not supported";
        reporter.report(this.m_policy.getUnsupportedDataTypeLevel(), message, TranslateHelper.getResourceString(type), TranslateHelper.getLineNumber(type), TranslateHelper.getColumnNumber(type));
    }

    public void logError(String msgId, String msg, BaseTranslator translator, ASTNode astNode, BaseJstNode jstNode) {
        this.log(LogLevel.ERROR, msgId, msg, translator, astNode, jstNode);
    }

    public void logWarning(String msgId, String msg, BaseTranslator translator, ASTNode astNode, BaseJstNode jstNode) {
        this.log(LogLevel.WARN, msgId, msg, translator, astNode, jstNode);
    }

    public void logInfo(String msgId, String msg, BaseTranslator translator, ASTNode astNode, BaseJstNode jstNode) {
        this.log(LogLevel.INFO, msgId, msg, translator, astNode, jstNode);
    }

    public void log(LogLevel level, String msgId, String msg, BaseTranslator translator, ASTNode astNode, BaseJstNode jstNode) {
        if (level == LogLevel.ERROR) {
            this.logError(translator.getErrorReporter(), msg, astNode);
        } else if (level == LogLevel.WARN) {
            this.logWarning(translator.getErrorReporter(), msg, astNode);
        }
        this.trace(level, msgId, msg, astNode, jstNode);
    }

    public void logError(ErrorReporter reporter, String msg, ASTNode currNode) {
        reporter.error(msg, TranslateHelper.getResourceString(currNode), TranslateHelper.getLineNumber(currNode), TranslateHelper.getColumnNumber(currNode));
    }

    public void logWarning(ErrorReporter reporter, String msg, ASTNode currNode) {
        reporter.warning(msg, TranslateHelper.getResourceString(currNode), TranslateHelper.getLineNumber(currNode), TranslateHelper.getColumnNumber(currNode));
    }

    public void trace(LogLevel level, String msgId, String msg, ASTNode astNode, BaseJstNode jstNode) {
        TranslationStatus status = this.m_ctx.getTranslateInfo(jstNode.getOwnerType()).getStatus();
        if (!status.hasError(astNode)) {
            TranslateError error = new TranslateError(level, msgId, AstBindingHelper.getSourceName((IJstNode)jstNode), TranslateHelper.getLineNumber(astNode), msg);
            status.addError(astNode, error);
        }
    }

    private void traceNode(LogLevel level, String msgId, Object caller, ASTNode astNode, BaseJstNode jstNode) {
        TranslationStatus status = this.m_ctx.getTranslateInfo(jstNode.getOwnerType()).getStatus();
        if (!status.hasError(astNode)) {
            Throwable t = new Throwable();
            t.fillInStackTrace();
            String clsName = TraceUtil.getClassName((Object)caller);
            String methodName = TraceUtil.getMethodName((Object)caller, (Throwable)t);
            TranslateError error = new TranslateError(level, msgId, AstBindingHelper.getSourceName((IJstNode)jstNode.getOwnerType()), TranslateHelper.getLineNumber(astNode), String.valueOf(clsName) + "::" + methodName + "(...) '" + astNode.getClass().getSimpleName() + "' not translated");
            status.addError(astNode, error);
        }
    }

    private void traceType(LogLevel level, String msgId, BaseTranslator translator, ASTNode astNode, BaseJstNode jstNode) {
        TranslationStatus status = this.m_ctx.getTranslateInfo(jstNode.getOwnerType()).getStatus();
        if (!status.hasError(astNode)) {
            Throwable t = new Throwable();
            t.fillInStackTrace();
            String clsName = TraceUtil.getClassName((Object)translator);
            String methodName = TraceUtil.getMethodName((Object)translator, (Throwable)t);
            String type = astNode.toString();
            if (astNode instanceof ImportDeclaration) {
                type = ((ImportDeclaration)astNode).getName().toString();
            }
            TranslateError error = new TranslateError(level, msgId, AstBindingHelper.getSourceName((IJstNode)jstNode.getOwnerType()), TranslateHelper.getLineNumber(astNode), String.valueOf(clsName) + "::" + methodName + "(...) '" + type + "' not translated");
            status.addError(astNode, error);
        }
    }
}

