/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslationMode;
import org.eclipse.vjet.dsf.javatojs.translate.TranslationStatus;
import org.eclipse.vjet.dsf.javatojs.translate.config.MethodKey;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomInfo;
import org.eclipse.vjet.dsf.javatojs.util.AstBindingHelper;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.stmt.JstBlockInitializer;

public class TranslateInfo {
    private final JstType m_type;
    private TranslationMode m_mode;
    private TranslationStatus m_status;
    private List<String> m_importedPkgs;
    private Map<String, String> m_importedTypes = new HashMap<String, String>();
    private Map<String, String> m_importedStaticRefs = new HashMap<String, String>();
    private Map<String, CustomInfo> m_fldCustomInfos;
    private Map<MethodKey, CustomInfo> m_mtdCustomInfos;
    private Map<String, CustomInfo> m_embeddedTypeCustomInfos;
    private Map<String, JstType> m_unknownTypes;
    private Map<String, IJstType> m_typeTable = new HashMap<String, IJstType>();
    private IJstType m_baseType;
    private List<IJstType> m_interfaceTypes;
    private List<String> m_embededTypes;
    private Map<String, Map<Integer, List<JstMethod>>> m_overloadedStaticMtds;
    private Map<String, Map<Integer, List<JstMethod>>> m_overloadedInstanceMtds;
    private Map<String, Map<MethodDeclaration, JstMethod>> m_removedMtds;
    private Map<Initializer, JstBlockInitializer> m_initilizers;
    private Map<AnonymousClassDeclaration, JstType> m_anonymousTypes;
    private Map<TypeDeclarationStatement, JstType> m_localTypes;
    private boolean m_clearTypeRefs = false;
    private int m_temp_index_counter = 0;
    private Set<IJstType> m_active_imports = new HashSet<IJstType>();

    public TranslateInfo(JstType type) {
        this.m_type = type;
    }

    public JstType getType() {
        return this.m_type;
    }

    public TranslateInfo addMode(TranslationMode mode) {
        if (this.m_mode == null) {
            this.m_mode = mode;
        } else if (mode != null) {
            this.m_mode.setMode(this.m_mode.getMode() | mode.getMode());
        }
        return this;
    }

    public TranslationMode getMode() {
        if (this.m_mode == null) {
            this.m_mode = new TranslationMode();
        }
        return this.m_mode;
    }

    public TranslationStatus getStatus() {
        if (this.m_status == null) {
            this.m_status = new TranslationStatus(this.m_type);
        }
        return this.m_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImport(String shortName, String fullName) {
        if (shortName == null || fullName == null) {
            return;
        }
        TranslateInfo translateInfo = this;
        synchronized (translateInfo) {
            this.m_importedTypes.put(shortName, fullName);
        }
    }

    public String getImported(String shortName) {
        String name = this.m_importedTypes.get(shortName);
        if (name != null) {
            return name;
        }
        return this.getImportedStaticRefTypeName(shortName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImportedPkg(String pkgName) {
        if (pkgName == null) {
            return;
        }
        TranslateInfo translateInfo = this;
        synchronized (translateInfo) {
            if (this.m_importedPkgs == null) {
                this.m_importedPkgs = new ArrayList<String>();
            } else if (this.m_importedPkgs.contains(pkgName)) {
                return;
            }
            this.m_importedPkgs.add(pkgName);
        }
    }

    public List<String> getImportedPkgs() {
        if (this.m_importedPkgs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_importedPkgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImportedStaticRef(String refName, String typeName) {
        TranslateInfo translateInfo = this;
        synchronized (translateInfo) {
            this.m_importedStaticRefs.put(refName, typeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImportedStaticRefTypeName(String refName) {
        TranslateInfo translateInfo = this;
        synchronized (translateInfo) {
            String typeName = this.m_importedStaticRefs.get(refName);
            if (typeName != null || !this.getMode().hasImplementation()) {
                return typeName;
            }
            for (Map.Entry<String, String> entry : this.m_importedStaticRefs.entrySet()) {
                JstType jstType;
                if (!entry.getKey().equals("*") || (jstType = JstCache.getInstance().getType(entry.getValue())) == null || jstType.getProperty(refName, true, true) == null && jstType.getMethod(refName, true, true) == null) continue;
                return entry.getValue();
            }
            return null;
        }
    }

    public CustomInfo getFieldCustomInfo(String shortName) {
        if (shortName == null || this.m_fldCustomInfos == null) {
            return CustomInfo.NONE;
        }
        CustomInfo cInfo = this.m_fldCustomInfos.get(shortName);
        return cInfo == null ? CustomInfo.NONE : cInfo;
    }

    public void addFieldCustomInfo(String shortName, CustomInfo customInfo) {
        if (shortName == null || customInfo == null) {
            return;
        }
        if (this.m_fldCustomInfos == null) {
            this.m_fldCustomInfos = new LinkedHashMap<String, CustomInfo>(2);
        }
        this.m_fldCustomInfos.put(shortName, customInfo);
    }

    public CustomInfo getMethodCustomInfo(MethodKey mtdKey) {
        if (mtdKey == null || this.m_mtdCustomInfos == null) {
            return CustomInfo.NONE;
        }
        CustomInfo cInfo = this.m_mtdCustomInfos.get(mtdKey);
        return cInfo == null ? CustomInfo.NONE : cInfo;
    }

    public void addMethodCustomInfo(MethodKey mtdKey, CustomInfo customInfo) {
        if (mtdKey == null || customInfo == null) {
            return;
        }
        if (this.m_mtdCustomInfos == null) {
            this.m_mtdCustomInfos = new LinkedHashMap<MethodKey, CustomInfo>(2);
        }
        this.m_mtdCustomInfos.put(mtdKey, customInfo);
    }

    public CustomInfo getEmbeddedTypeCustomInfo(String shortName) {
        if (shortName == null || this.m_embeddedTypeCustomInfos == null) {
            return CustomInfo.NONE;
        }
        CustomInfo cInfo = this.m_embeddedTypeCustomInfos.get(shortName);
        return cInfo == null ? CustomInfo.NONE : cInfo;
    }

    public void addEmbeddedTypeCustomInfo(String shortName, CustomInfo customInfo) {
        if (shortName == null || customInfo == null) {
            return;
        }
        if (this.m_embeddedTypeCustomInfos == null) {
            this.m_embeddedTypeCustomInfos = new LinkedHashMap<String, CustomInfo>(2);
        }
        this.m_embeddedTypeCustomInfos.put(shortName, customInfo);
    }

    public Map<MethodDeclaration, JstMethod> getRemovedMtds(String name) {
        if (name == null || this.m_removedMtds == null) {
            return Collections.emptyMap();
        }
        Map<MethodDeclaration, JstMethod> map = this.m_removedMtds.get(name);
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public void addRemovedMtd(MethodDeclaration astMtd, JstMethod jstMtd) {
        String name;
        Map<MethodDeclaration, JstMethod> map;
        if (astMtd == null || jstMtd == null) {
            return;
        }
        if (this.m_removedMtds == null) {
            this.m_removedMtds = new HashMap<String, Map<MethodDeclaration, JstMethod>>();
        }
        if ((map = this.m_removedMtds.get(name = astMtd.getName().toString())) == null) {
            map = new HashMap<MethodDeclaration, JstMethod>();
            this.m_removedMtds.put(name, map);
        }
        if (!map.containsKey(astMtd)) {
            map.put(astMtd, jstMtd);
        }
    }

    public void addUnknownType(String shortName, JstType type) {
        if (shortName == null) {
            return;
        }
        if (this.m_unknownTypes == null) {
            this.m_unknownTypes = new HashMap<String, JstType>(2);
        }
        if (!this.m_unknownTypes.containsKey(shortName)) {
            this.m_unknownTypes.put(shortName, type);
        }
    }

    public JstType getUnknownType(String shortName) {
        if (shortName == null || this.m_unknownTypes == null) {
            return null;
        }
        return this.m_unknownTypes.get(shortName);
    }

    public Map<String, JstType> getUnknownTypes() {
        if (this.m_unknownTypes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.m_unknownTypes);
    }

    public boolean isUnknownType(String shortName) {
        if (shortName == null || this.m_unknownTypes == null) {
            return false;
        }
        return this.m_unknownTypes.containsKey(shortName);
    }

    public void setType(String typeName, IJstType type) {
        if (typeName == null || type == null) {
            return;
        }
        this.m_typeTable.put(typeName, type);
    }

    public IJstType getType(String typeName, boolean recursive) {
        IJstType type = this.m_typeTable.get(typeName);
        if (type != null) {
            return type;
        }
        if (!recursive || this.m_type.getParentNode() == null) {
            return null;
        }
        JstType childType = this.m_type;
        JstType parentType = this.m_type.getParentNode().getOwnerType();
        if (parentType != null && childType != parentType && (type = TranslateCtx.ctx().getTranslateInfo(parentType).getType(typeName, recursive)) != null) {
            return type;
        }
        return null;
    }

    public Map<String, IJstType> getTypes() {
        return Collections.unmodifiableMap(this.m_typeTable);
    }

    public void removeType(String symbol) {
        this.m_typeTable.remove(symbol);
    }

    public void setBaseType(IJstType baseType) {
        this.m_baseType = baseType;
    }

    public IJstType getBaseType() {
        return this.m_baseType;
    }

    public void addInterfaceType(IJstType type) {
        if (type == null) {
            return;
        }
        if (this.m_interfaceTypes == null) {
            this.m_interfaceTypes = new ArrayList<IJstType>(2);
        }
        this.m_interfaceTypes.add(type);
    }

    public boolean isInterfaceType(IJstType type) {
        if (this.m_interfaceTypes == null) {
            return false;
        }
        return this.m_interfaceTypes.contains(type);
    }

    public List<IJstType> getInterfaceTypes() {
        if (this.m_interfaceTypes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_interfaceTypes);
    }

    public void addEmbededType(String name) {
        if (name == null) {
            return;
        }
        if (this.m_embededTypes == null) {
            this.m_embededTypes = new ArrayList<String>(2);
        }
        this.m_embededTypes.add(name);
    }

    public boolean isEmbededType(String name) {
        if (this.m_embededTypes == null) {
            return false;
        }
        return this.m_embededTypes.contains(name);
    }

    public List<String> getEmbededTypes() {
        if (this.m_embededTypes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_embededTypes);
    }

    public void addOverloaded(JstMethod jstMtd) {
        Integer argCount;
        List<JstMethod> list;
        String mtdName;
        if (jstMtd == null) {
            return;
        }
        MethodDeclaration astMtd = (MethodDeclaration)AstBindingHelper.getAstNode((IJstNode)jstMtd);
        if (astMtd == null) {
            return;
        }
        Map<String, Map<Integer, List<JstMethod>>> overloadedMap = this.getOverloadedMethodMap(jstMtd.isStatic(), true);
        Map<Integer, List<JstMethod>> map = overloadedMap.get(mtdName = jstMtd.getName().getName());
        if (map == null) {
            map = new HashMap<Integer, List<JstMethod>>();
            overloadedMap.put(mtdName, map);
        }
        if ((list = map.get(argCount = new Integer(astMtd.parameters().size()))) == null) {
            list = new ArrayList<JstMethod>();
            map.put(argCount, list);
        }
        String surffix = "_" + argCount + "_" + list.size() + JstMethod.getOverloadSuffix((IJstType)jstMtd.getOwnerType());
        jstMtd.setSurffix(surffix);
        jstMtd.setName(jstMtd.getName() + surffix);
        list.add(jstMtd);
    }

    public boolean isOverloaded(String mtdName, boolean isStatic) {
        if (mtdName == null) {
            return false;
        }
        Map<String, Map<Integer, List<JstMethod>>> map = this.getOverloadedMethodMap(isStatic, false);
        if (map == null) {
            return false;
        }
        return map.containsKey(mtdName);
    }

    public Map<Integer, List<JstMethod>> getOverloaded(String mtdName, boolean isStatic) {
        if (mtdName == null) {
            return Collections.emptyMap();
        }
        Map<String, Map<Integer, List<JstMethod>>> map = this.getOverloadedMethodMap(isStatic, false);
        if (map == null) {
            return Collections.emptyMap();
        }
        return map.get(mtdName);
    }

    public JstMethod getOverloaded(MethodDeclaration astMtd) {
        Map<Integer, List<JstMethod>> map;
        if (astMtd == null) {
            return null;
        }
        String mtdName = astMtd.getName().toString();
        mtdName = TranslateCtx.ctx().getProvider().getNameTranslator().processVarName(mtdName);
        if (astMtd.isConstructor()) {
            mtdName = "constructs";
        }
        if ((map = this.getOverloaded(mtdName, TranslateHelper.isStatic(astMtd.modifiers()))) == null) {
            return null;
        }
        List<JstMethod> list = map.get(new Integer(astMtd.parameters().size()));
        if (list == null) {
            return null;
        }
        for (JstMethod jstMtd : list) {
            if (AstBindingHelper.getAstNode((IJstNode)jstMtd) != astMtd) continue;
            return jstMtd;
        }
        return null;
    }

    public void addInitializer(Initializer initializer, JstBlockInitializer jstInitializer) {
        if (initializer == null || jstInitializer == null) {
            return;
        }
        if (this.m_initilizers == null) {
            this.m_initilizers = new HashMap<Initializer, JstBlockInitializer>();
        }
        this.m_initilizers.put(initializer, jstInitializer);
    }

    public JstBlockInitializer getJstInitializer(Initializer initializer) {
        if (initializer == null || this.m_initilizers == null) {
            return null;
        }
        return this.m_initilizers.get(initializer);
    }

    public void addAnonymousType(AnonymousClassDeclaration anonymousType, JstType jstType) {
        if (anonymousType == null || jstType == null) {
            return;
        }
        if (this.m_anonymousTypes == null) {
            this.m_anonymousTypes = new HashMap<AnonymousClassDeclaration, JstType>();
        }
        this.m_anonymousTypes.put(anonymousType, jstType);
    }

    public JstType getJstAnonymousType(AnonymousClassDeclaration anonymousType) {
        if (anonymousType == null || this.m_anonymousTypes == null) {
            return null;
        }
        return this.m_anonymousTypes.get(anonymousType);
    }

    public void addLocalType(TypeDeclarationStatement localType, JstType jstType) {
        if (localType == null || jstType == null) {
            return;
        }
        if (this.m_localTypes == null) {
            this.m_localTypes = new HashMap<TypeDeclarationStatement, JstType>();
        }
        jstType.setLocalType(true);
        this.m_localTypes.put(localType, jstType);
    }

    public JstType getLocalType(TypeDeclarationStatement localType) {
        if (localType == null || this.m_localTypes == null) {
            return null;
        }
        return this.m_localTypes.get(localType);
    }

    public JstType getLocalType(String name) {
        if (name == null || this.m_localTypes == null) {
            return null;
        }
        for (JstType itm : this.m_localTypes.values()) {
            if (!name.equals(itm.getName())) continue;
            return itm;
        }
        return null;
    }

    public void setClearTypeRefs(boolean clearTypeRefs) {
        this.m_clearTypeRefs = clearTypeRefs;
    }

    public boolean clearTypeRefs() {
        boolean clear;
        boolean bl = clear = this.m_clearTypeRefs || !this.getUnknownTypes().isEmpty();
        if (clear) {
            return true;
        }
        if (this.m_type != this.m_type.getRootType()) {
            return TranslateCtx.ctx().getTranslateInfo(this.m_type.getRootType()).clearTypeRefs();
        }
        return false;
    }

    public String toString() {
        return this.m_type.getName();
    }

    private Map<String, Map<Integer, List<JstMethod>>> getOverloadedMethodMap(boolean isStatic, boolean create) {
        if (isStatic) {
            if (this.m_overloadedStaticMtds == null && create) {
                this.m_overloadedStaticMtds = new HashMap<String, Map<Integer, List<JstMethod>>>();
            }
            return this.m_overloadedStaticMtds;
        }
        if (this.m_overloadedInstanceMtds == null && create) {
            this.m_overloadedInstanceMtds = new HashMap<String, Map<Integer, List<JstMethod>>>();
        }
        return this.m_overloadedInstanceMtds;
    }

    public void addActiveImport(IJstType type) {
        this.m_active_imports.add(type);
    }

    public Set<IJstType> getActiveImports() {
        return this.m_active_imports;
    }

    public int getUniqueTempIndex() {
        return this.m_temp_index_counter++;
    }
}

