/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.vjet.dsf.javatojs.translate.AstBinding;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.LiteralTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.VjoTranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.config.MethodKey;
import org.eclipse.vjet.dsf.javatojs.translate.util.AutoBoxer;
import org.eclipse.vjet.dsf.jsnative.anno.JsNativeMeta;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.declaration.VarTable;
import org.eclipse.vjet.dsf.jst.expr.ArithExpr;
import org.eclipse.vjet.dsf.jst.expr.ArrayAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.ArrayCreationExpr;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.BoolExpr;
import org.eclipse.vjet.dsf.jst.expr.CastExpr;
import org.eclipse.vjet.dsf.jst.expr.ConditionalExpr;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.InfixExpr;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.expr.JstInitializer;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.expr.ParenthesizedExpr;
import org.eclipse.vjet.dsf.jst.expr.PostfixExpr;
import org.eclipse.vjet.dsf.jst.expr.PrefixExpr;
import org.eclipse.vjet.dsf.jst.expr.PtyGetter;
import org.eclipse.vjet.dsf.jst.reserved.JsCoreKeywords;
import org.eclipse.vjet.dsf.jst.stmt.ExprStmt;
import org.eclipse.vjet.dsf.jst.stmt.JstStmt;
import org.eclipse.vjet.dsf.jst.stmt.PtySetter;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.JstLiteral;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IBoolExpr;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.ISimpleTerm;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;
import org.eclipse.vjet.vjo.VjoTypes;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public class ExpressionTranslator
extends BaseTranslator {
    public IExpr processExpression(Expression astExpr, BaseJstNode jstNode) {
        if (astExpr == null) {
            return null;
        }
        JstLiteral jstExpr = null;
        if (astExpr instanceof BooleanLiteral || astExpr instanceof NumberLiteral || astExpr instanceof StringLiteral || astExpr instanceof CharacterLiteral || astExpr instanceof NullLiteral) {
            jstExpr = this.toJstLiteral(astExpr, jstNode, true);
        } else if (astExpr instanceof TypeLiteral) {
            Type ndType = ((TypeLiteral)astExpr).getType();
            if (ndType.isArrayType()) {
                this.getLogger().logError("ExcludedType", "Array type translation not supported", this, (ASTNode)astExpr, jstNode);
                return null;
            }
            IJstType type = this.getDataTypeTranslator().processType(ndType, jstNode);
            jstExpr = VjoTranslateHelper.processTypeLiteral(type, jstNode);
        } else if (astExpr instanceof SimpleName || astExpr instanceof QualifiedName) {
            jstExpr = this.toJstIdentifier(astExpr, jstNode, true);
        } else if (astExpr instanceof CastExpression) {
            CastExpression cExpr = (CastExpression)astExpr;
            Expression expr = cExpr.getExpression();
            IJstType type = this.getDataTypeTranslator().processType(cExpr.getType(), jstNode);
            jstExpr = this.processExpression(expr, jstNode);
            if (DataTypeHelper.isNumericPrimitiveType((IJstType)type) || DataTypeHelper.isCharPrimitiveType((IJstType)type)) {
                jstExpr = new MtdInvocationExpr(VjoTypes.CAST.getName().getName(), new IExpr[]{jstExpr, new JstIdentifier("'" + type.getName() + "'")}).setQualifyExpr((IExpr)VjoTranslateHelper.getStaticMemberQualifier((IJstType)VjoTypes.VJO_JAVA_LANG_UTIL, jstNode));
                jstNode.getOwnerType().addImport((IJstType)VjoTypes.VJO_JAVA_LANG_UTIL);
            } else {
                jstExpr = new CastExpr((IExpr)jstExpr, type);
            }
        } else if (astExpr instanceof FieldAccess || astExpr instanceof SuperFieldAccess) {
            jstExpr = this.toFieldAccess(astExpr, jstNode, true);
        } else if (astExpr instanceof ArrayAccess) {
            jstExpr = this.toArrayAccess((ArrayAccess)astExpr, jstNode);
        } else if (astExpr instanceof ArrayInitializer) {
            jstExpr = this.toJstArrayInitializer(astExpr, jstNode);
        } else if (astExpr instanceof Assignment) {
            jstExpr = this.toAssignExpr((Assignment)astExpr, jstNode);
        } else if (astExpr instanceof InfixExpression || astExpr instanceof PrefixExpression || astExpr instanceof PostfixExpression || astExpr instanceof ParenthesizedExpression) {
            jstExpr = this.toArithmeticExpr(astExpr, jstNode, true);
        } else if (astExpr instanceof ConditionalExpression) {
            jstExpr = this.toConditionalExpr((ConditionalExpression)astExpr, jstNode);
        } else if (astExpr instanceof MethodInvocation || astExpr instanceof SuperMethodInvocation) {
            jstExpr = this.processMtdInvocation(astExpr, jstNode);
        } else if (astExpr instanceof ClassInstanceCreation) {
            IExpr objCreationExpr;
            ClassInstanceCreation cic = (ClassInstanceCreation)astExpr;
            IJstType objType = this.getDataTypeTranslator().processType(cic.getType(), jstNode);
            IExpr jstQualifier = this.processExpression(cic.getExpression(), jstNode);
            List args = cic.arguments();
            ArrayList<IExpr> jstArgs = null;
            if (!args.isEmpty()) {
                jstArgs = new ArrayList<IExpr>();
                for (Object a : args) {
                    if (a instanceof Expression) {
                        jstArgs.add(this.getExprTranslator().processExpression((Expression)a, jstNode));
                        continue;
                    }
                    this.getLogger().logUnhandledNode(this, (ASTNode)a, jstNode);
                }
            }
            if ((objCreationExpr = this.getCustomTranslator().processInstanceCreation(cic, jstQualifier, objType, jstArgs, jstNode)) != null) {
                jstExpr = objCreationExpr;
            } else {
                String typeName = cic.getType().toString();
                if (objType == null && jstQualifier != null && jstQualifier.getOwnerType() != null) {
                    objType = TranslateHelper.Type.getEmbededType(jstQualifier.getResultType(), typeName, true);
                }
                jstExpr = this.toObjCreation(cic.getType(), objType, jstQualifier, typeName, cic.getExpression(), cic.arguments(), cic.getAnonymousClassDeclaration(), jstNode);
            }
        } else if (astExpr instanceof ArrayCreation) {
            jstExpr = this.toArrayCreation((ArrayCreation)astExpr, jstNode);
        } else if (astExpr instanceof InstanceofExpression) {
            jstExpr = this.toInstanceOfMethodExpr((InstanceofExpression)astExpr, jstNode);
        } else {
            if (astExpr instanceof ThisExpression) {
                ThisExpression expr = (ThisExpression)astExpr;
                Name name = expr.getQualifier();
                JstType ownerType = jstNode.getOwnerType();
                String t = JsCoreKeywords.THIS;
                if (name != null) {
                    JstType outer = ownerType;
                    String prefix = t;
                    VjoConvention convention = this.getCtx().getConfig().getVjoConvention();
                    while (outer != null) {
                        String typeName = outer.getSimpleName();
                        if (typeName != null && typeName.equals(name.toString())) {
                            ownerType = outer;
                            t = prefix;
                            break;
                        }
                        if (outer.isAnonymous()) {
                            IJstNode n = outer.getParentNode();
                            while (!(n instanceof IJstType) && n != null) {
                                n = n.getParentNode();
                            }
                            if (n == null) break;
                            prefix = String.valueOf(prefix) + convention.getParentInstancePrefix();
                            outer = (IJstType)n;
                            continue;
                        }
                        prefix = String.valueOf(prefix) + convention.getOuterInstancePrefix();
                        outer = outer.getOuterType();
                    }
                }
                JstIdentifier identifier = new JstIdentifier(t);
                identifier.setType((IJstType)ownerType);
                identifier.setJstBinding((IJstNode)ownerType);
                return identifier;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)astExpr, jstNode);
            return null;
        }
        if (jstExpr != null && jstExpr instanceof BaseJstNode) {
            ((BaseJstNode)jstExpr).setParent((IJstNode)jstNode);
        }
        return jstExpr;
    }

    ISimpleTerm toSimpleTerm(Expression astExpr, BaseJstNode jstNode) {
        assert (astExpr != null) : "astExpr cannot be null";
        JstLiteral jstLiteral = this.toJstLiteral(astExpr, jstNode, false);
        if (jstLiteral != null) {
            return jstLiteral;
        }
        JstIdentifier jstIdentifier = this.toJstIdentifier(astExpr, jstNode, false);
        if (jstIdentifier != null) {
            return jstIdentifier;
        }
        return null;
    }

    List<AssignExpr> toAssignExprs(VariableDeclarationExpression astExpr, JstStmt jstStmt) {
        VariableDeclarationExpression vdExpr = astExpr;
        IJstType type = this.getDataTypeTranslator().processType(vdExpr.getType(), (BaseJstNode)jstStmt);
        if (type == null) {
            this.getLogger().logError("NullResult", "failed to translate", this, (ASTNode)vdExpr.getType(), (BaseJstNode)jstStmt);
        }
        ArrayList<AssignExpr> list = new ArrayList<AssignExpr>();
        for (Object o : vdExpr.fragments()) {
            if (o instanceof VariableDeclarationFragment) {
                VariableDeclarationFragment f = (VariableDeclarationFragment)o;
                String name = f.getName().toString();
                Expression e = f.getInitializer();
                list.add(new AssignExpr((ILHS)new JstVar(type, name), this.getExprTranslator().processExpression(e, (BaseJstNode)jstStmt)));
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)o, (BaseJstNode)jstStmt);
        }
        return list;
    }

    AssignExpr toAssignExpr(Assignment astExpr, BaseJstNode jstNode) {
        Assignment a = astExpr;
        Expression left = a.getLeftHandSide();
        Expression right = a.getRightHandSide();
        String op = a.getOperator().toString();
        return new AssignExpr(this.toLHS(left, jstNode), this.processExpression(right, jstNode), op);
    }

    ArithExpr toArithmeticExpr(Expression astExpr, BaseJstNode jstNode, boolean report) {
        if (astExpr instanceof InfixExpression) {
            InfixExpression infix = (InfixExpression)astExpr;
            Expression le = infix.getLeftOperand();
            Expression re = infix.getRightOperand();
            InfixExpr.Operator op = InfixExpr.Operator.toOperator((String)TranslateHelper.getOperatorStringForJs(infix.getOperator().toString()));
            IExpr rightExpress = this.processExpression(re, jstNode);
            InfixExpr expr = new InfixExpr(this.processExpression(le, jstNode), rightExpress, op);
            List exOprds = infix.extendedOperands();
            if (exOprds != null) {
                for (Object o : exOprds) {
                    if (o instanceof Expression) {
                        expr = new InfixExpr((IExpr)expr, this.processExpression((Expression)o, jstNode), op);
                        continue;
                    }
                    this.getLogger().logUnhandledNode(this, (ASTNode)o, jstNode);
                }
            }
            return expr;
        }
        if (astExpr instanceof PrefixExpression) {
            PrefixExpression prefix = (PrefixExpression)astExpr;
            Expression e = prefix.getOperand();
            return new PrefixExpr(this.processExpression(e, jstNode), PrefixExpr.Operator.toOperator((String)prefix.getOperator().toString()));
        }
        if (astExpr instanceof PostfixExpression) {
            PostfixExpression postfix = (PostfixExpression)astExpr;
            Expression e = postfix.getOperand();
            return new PostfixExpr(this.processExpression(e, jstNode), PostfixExpr.Operator.toOperator((String)postfix.getOperator().toString()));
        }
        if (astExpr instanceof ParenthesizedExpression) {
            ParenthesizedExpression parenthefix = (ParenthesizedExpression)astExpr;
            Expression e = parenthefix.getExpression();
            return new ParenthesizedExpr(this.processExpression(e, jstNode));
        }
        if (report) {
            this.getLogger().logUnhandledNode(this, (ASTNode)astExpr, jstNode);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    IBoolExpr toBoolExpr(Expression astExpr, BaseJstNode jstNode) {
        block4: {
            block5: {
                block3: {
                    e = astExpr;
                    parenthesisCount = 0;
                    while (e instanceof ParenthesizedExpression) {
                        e = ((ParenthesizedExpression)e).getExpression();
                        ++parenthesisCount;
                    }
                    if (!(e instanceof InfixExpression)) break block3;
                    infix = (InfixExpression)e;
                    left = this.getExprTranslator().processExpression(infix.getLeftOperand(), jstNode);
                    right = this.getExprTranslator().processExpression(infix.getRightOperand(), jstNode);
                    boolExpr = new BoolExpr(left, right, TranslateHelper.getOperatorStringForJs(infix.getOperator().toString()));
                    break block4;
                }
                if (!(e instanceof InstanceofExpression)) break block5;
                this.getLogger().logWarning("IncompleteNode", String.valueOf(e.getClass().getSimpleName()) + " translated to " + JsCoreKeywords.INSTANCEOF, this, (ASTNode)e, jstNode);
                infix = (InstanceofExpression)e;
                left = this.getExprTranslator().processExpression(infix.getLeftOperand(), jstNode);
                rightType = this.getDataTypeTranslator().processType(infix.getRightOperand(), jstNode);
                if (rightType != null) ** GOTO lbl22
                return null;
lbl-1000:
                // 1 sources

                {
                    rightType = ((JstTypeWithArgs)rightType).getType();
lbl22:
                    // 2 sources

                    ** while (rightType instanceof JstTypeWithArgs)
                }
lbl23:
                // 1 sources

                right = rightType instanceof JstArray != false ? new JstIdentifier("") : TranslateHelper.Type.createIdentifier(rightType, jstNode);
                boolExpr = new BoolExpr(left, (IExpr)right, BoolExpr.Operator.INSTANCE_OF);
                break block4;
            }
            boolExpr = new BoolExpr(this.getExprTranslator().processExpression(e, jstNode));
        }
        i = 0;
        while (i < parenthesisCount) {
            boolExpr = new ParenthesizedExpr((IExpr)boolExpr);
            ++i;
        }
        return boolExpr;
    }

    /*
     * Unable to fully structure code
     */
    IExpr toInstanceOfMethodExpr(InstanceofExpression astExpr, BaseJstNode jstNode) {
        left = this.getExprTranslator().processExpression(astExpr.getLeftOperand(), jstNode);
        rightType = this.getDataTypeTranslator().processType(astExpr.getRightOperand(), jstNode);
        if (rightType != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            rightType = ((JstTypeWithArgs)rightType).getType();
lbl6:
            // 2 sources

            ** while (rightType instanceof JstTypeWithArgs)
        }
lbl7:
        // 1 sources

        rname = DataTypeHelper.getTypeName((String)rightType.getName());
        if (rightType instanceof JstArray) {
            right = new JstIdentifier("");
        } else {
            right = rightType.getModifiers().isStatic() != false ? new JstIdentifier(rname) : new JstIdentifier(VjoConvention.getType((String)rname));
            right.setJstBinding((IJstNode)rightType);
        }
        if (JsNativeMeta.isJsNativeType((String)rname)) {
            exp = new BoolExpr(left, (IExpr)right, BoolExpr.Operator.INSTANCE_OF);
            return exp;
        }
        exp = new MtdInvocationExpr("isInstance", new IExpr[0]);
        exp.setQualifyExpr((IExpr)right);
        exp.addArg(left);
        return exp;
    }

    IStmt toStmt(Expression astExpr, BaseJstNode jstNode) {
        if (astExpr == null) {
            return null;
        }
        if (astExpr instanceof Assignment) {
            return this.toAssignExpr((Assignment)astExpr, jstNode);
        }
        ArithExpr expr = this.toArithmeticExpr(astExpr, jstNode, false);
        if (expr != null) {
            return expr;
        }
        IExpr mtdCall = this.processMtdInvocation(astExpr, jstNode);
        if (mtdCall == null) {
            return null;
        }
        if (mtdCall instanceof IStmt) {
            return (IStmt)mtdCall;
        }
        return new ExprStmt(mtdCall);
    }

    ObjCreationExpr toObjCreation(Type astType, IJstType objType, IExpr jstExpr, String typeName, Expression expr, List args, AnonymousClassDeclaration anonymous, BaseJstNode jstNode) {
        ObjCreationExpr objCreationExpr;
        if (objType == null) {
            this.getLogger().logError("NullResult", "failed to translate type", this, (ASTNode)anonymous, jstNode);
            return null;
        }
        JstIdentifier identifier = null;
        if (DataTypeHelper.isJavaMappedToNative((String)objType.getName())) {
            identifier = new JstIdentifier(DataTypeHelper.getTypeName((String)objType.getName()));
        } else if (this.getCtx().getConfig().getPackageMapping().mapTo(typeName).equals(objType.getName())) {
            identifier = new JstIdentifier(objType.getName());
        } else if (jstExpr != null) {
            identifier = VjoTranslateHelper.getInstanceTypeQualifier(jstExpr, objType, (IJstNode)jstNode);
        } else if (objType.getModifiers().isStatic() || objType.getOuterType() != null && objType.getOuterType().isInterface() || jstNode.getOwnerType().hasImport(objType.getSimpleName())) {
            JstIdentifier jstQualifier;
            IJstType type = objType;
            if (type instanceof JstTypeWithArgs) {
                type = ((JstTypeWithArgs)type).getType();
            }
            if ((jstQualifier = VjoTranslateHelper.getStaticTypeQualifier(type, jstNode)) == null) {
                identifier = new JstIdentifier(type.getSimpleName());
            } else {
                Object name = jstQualifier.getName();
                if (type != jstNode.getOwnerType()) {
                    name = String.valueOf(name) + "." + type.getSimpleName();
                }
                identifier = new JstIdentifier((String)name);
            }
        } else {
            identifier = VjoTranslateHelper.getInstanceTypeQualifier(null, objType, (IJstNode)jstNode);
        }
        ArrayList<IExpr> jstArgs = new ArrayList<IExpr>();
        for (Object a : args) {
            if (a instanceof Expression) {
                jstArgs.add(this.getExprTranslator().processExpression((Expression)a, jstNode));
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)a, jstNode);
        }
        IJstMethod constructor = TranslateHelper.Method.getConstructor(objType, jstArgs);
        TranslateHelper.Method.validateMethodReference(constructor, (ASTNode)astType, jstNode, this);
        identifier.setJstBinding((IJstNode)TranslateHelper.Method.getConstructor(objType, jstArgs));
        MtdInvocationExpr mtdCall = new MtdInvocationExpr(identifier, new IExpr[0]);
        if (!jstArgs.isEmpty()) {
            mtdCall.setArgs(jstArgs);
        }
        mtdCall.setResultType(objType);
        if (anonymous != null) {
            JstType anonymousType = this.getCtx().getTranslateInfo(jstNode.getRootType()).getJstAnonymousType(anonymous);
            if (anonymousType == null) {
                this.getLogger().logError("MissingDataInTranslateInfo", "anonymous type not found", this, (ASTNode)anonymous, jstNode);
                return null;
            }
            objCreationExpr = new ObjCreationExpr(mtdCall, (IJstType)anonymousType);
            objCreationExpr.setParent((IJstNode)jstNode);
            if (!objType.isInterface()) {
                JstTypeReference jstTypeRef = new JstTypeReference(objType);
                jstTypeRef.setSource(new JstSource((JstSource.IBinding)new AstBinding((ASTNode)astType)));
                anonymousType.addExtend((IJstTypeReference)jstTypeRef);
            }
            this.getCtx().getTranslateInfo(anonymousType).addMode(this.getCtx().getTranslateInfo(jstNode.getOwnerType()).getMode());
            this.getTypeTranslator().processBody(anonymous.bodyDeclarations(), anonymousType);
        } else {
            objCreationExpr = new ObjCreationExpr(mtdCall);
            objCreationExpr.setParent((IJstNode)jstNode);
        }
        if (expr == null || expr instanceof ThisExpression) {
            return objCreationExpr;
        }
        if (expr instanceof ClassInstanceCreation) {
            objCreationExpr.setExpression((IExpr)new ParenthesizedExpr(jstExpr));
        } else {
            objCreationExpr.setExpression(jstExpr);
        }
        return objCreationExpr;
    }

    JstVars toJstVars(Type astType, List fragments, BaseJstNode jstNode) {
        IJstType jstType = this.getDataTypeTranslator().processType(astType, jstNode);
        if (jstType == null) {
            this.getLogger().logError("NullResult", "failed to translate", this, (ASTNode)astType, jstNode);
        }
        IJstType varType = jstType;
        VarTable varTable = TranslateHelper.getVarTable((IJstNode)jstNode);
        JstInitializer jstInitializers = new JstInitializer();
        for (Object o : fragments) {
            if (o instanceof VariableDeclarationFragment) {
                VariableDeclarationFragment f = (VariableDeclarationFragment)o;
                Expression e = f.getInitializer();
                String name = this.getNameTranslator().processVarName(f.getName(), jstNode);
                if (f.getExtraDimensions() > 0) {
                    int dims = f.getExtraDimensions();
                    varType = jstType;
                    while (dims > 0) {
                        varType = JstFactory.getInstance().createJstArrayType(varType, true);
                        --dims;
                    }
                }
                varTable.addVarType(name, varType);
                JstIdentifier identifier = new JstIdentifier(name);
                identifier.setType(varType);
                identifier.setJstBinding((IJstNode)varType);
                jstInitializers.addAssignment((ILHS)identifier, this.getExprTranslator().processExpression(e, jstNode));
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)o, jstNode);
        }
        return new JstVars(varType, jstInitializers);
    }

    private JstIdentifier toJstIdentifier(Expression astExpr, BaseJstNode jstNode, boolean report) {
        JstIdentifier identifier = null;
        if (astExpr instanceof Name) {
            identifier = this.getNameTranslator().processName((Name)astExpr, false, jstNode);
        } else if (report) {
            this.getLogger().logUnhandledNode(this, (ASTNode)astExpr, jstNode);
        }
        return identifier;
    }

    private FieldAccessExpr toFieldAccess(Expression astExpr, BaseJstNode jstNode, boolean report) {
        if (astExpr instanceof FieldAccess) {
            FieldAccess f = (FieldAccess)astExpr;
            Expression expr = f.getExpression();
            if (expr == null || expr instanceof ThisExpression) {
                JstIdentifier name = this.getNameTranslator().processName((Name)f.getName(), false, true, null, false, jstNode);
                return new FieldAccessExpr(name);
            }
            IExpr optionalExpr = this.processExpression(f.getExpression(), jstNode);
            JstIdentifier ident = this.getNameTranslator().processName((Name)f.getName(), false, false, optionalExpr, false, jstNode);
            IJstNode binding = ident.getJstBinding();
            if (optionalExpr instanceof ObjCreationExpr && binding != null && binding instanceof IJstProperty && ((IJstProperty)binding).isStatic()) {
                return new FieldAccessExpr(ident, null);
            }
            return new FieldAccessExpr(ident, optionalExpr);
        }
        if (astExpr instanceof SuperFieldAccess) {
            SuperFieldAccess f = (SuperFieldAccess)astExpr;
            return new FieldAccessExpr(this.getNameTranslator().processName((Name)f.getName(), true, false, null, false, (BaseJstNode)jstNode.getOwnerType()));
        }
        if (report) {
            this.getLogger().logUnhandledNode(this, (ASTNode)astExpr, jstNode);
        }
        return null;
    }

    private ArrayAccessExpr toArrayAccess(ArrayAccess astExpr, BaseJstNode jstNode) {
        return new ArrayAccessExpr(this.processExpression(astExpr.getArray(), jstNode), this.processExpression(astExpr.getIndex(), jstNode));
    }

    private JstArrayInitializer toJstArrayInitializer(Expression astExpr, BaseJstNode jstNode) {
        JstArrayInitializer jai = new JstArrayInitializer();
        ArrayInitializer ai = (ArrayInitializer)astExpr;
        List astExprs = ai.expressions();
        if (astExprs != null) {
            for (Object o : astExprs) {
                if (o instanceof Expression) {
                    jai.add(this.processExpression((Expression)o, jstNode));
                    continue;
                }
                this.getLogger().logUnhandledNode(this, (ASTNode)o, jstNode);
            }
        }
        return jai;
    }

    private ConditionalExpr toConditionalExpr(ConditionalExpression astExpr, BaseJstNode jstNode) {
        IBoolExpr boolExpr = this.toBoolExpr(astExpr.getExpression(), jstNode);
        IExpr thenExpr = this.processExpression(astExpr.getThenExpression(), jstNode);
        IExpr elseExpr = this.processExpression(astExpr.getElseExpression(), jstNode);
        return new ConditionalExpr(boolExpr, thenExpr, elseExpr);
    }

    private IExpr processMtdInvocation(Expression astExpr, BaseJstNode jstNode) {
        MethodInvocation astMtdCall;
        SimpleName name = null;
        Expression optionalExpr = null;
        List args = null;
        boolean isSuper = false;
        if (astExpr instanceof MethodInvocation) {
            astMtdCall = (MethodInvocation)astExpr;
            name = astMtdCall.getName();
            optionalExpr = astMtdCall.getExpression();
            args = astMtdCall.arguments();
        } else if (astExpr instanceof SuperMethodInvocation) {
            astMtdCall = (SuperMethodInvocation)astExpr;
            name = astMtdCall.getName();
            args = astMtdCall.arguments();
            isSuper = true;
        } else {
            if (astExpr instanceof ClassInstanceCreation) {
                ClassInstanceCreation cic = (ClassInstanceCreation)astExpr;
                return this.processExpression((Expression)cic, jstNode);
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)astExpr, jstNode);
            return null;
        }
        ArrayList<IExpr> jstArgs = new ArrayList<IExpr>();
        for (Object a : args) {
            if (a instanceof Name) {
                jstArgs.add((IExpr)this.getNameTranslator().processName((Name)a, false, jstNode));
                continue;
            }
            if (a instanceof Expression) {
                jstArgs.add(this.getExprTranslator().processExpression((Expression)a, jstNode));
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)a, jstNode);
        }
        JstIdentifier identifier = null;
        IExpr jstOptionalExpr = null;
        if (optionalExpr == null) {
            identifier = this.getNameTranslator().processMtdName((Name)name, jstArgs, isSuper, true, null, jstNode);
        } else if (optionalExpr instanceof ThisExpression) {
            jstOptionalExpr = this.processExpression((Expression)((ThisExpression)optionalExpr), jstNode);
            boolean isThis = jstOptionalExpr == null;
            identifier = this.getNameTranslator().processMtdName((Name)name, jstArgs, isSuper, isThis, jstOptionalExpr, jstNode);
        } else {
            jstOptionalExpr = this.getExprTranslator().processExpression(optionalExpr, jstNode);
            identifier = jstOptionalExpr != null && jstOptionalExpr.getResultType() != null ? this.getNameTranslator().processMtdName((Name)name, jstArgs, isSuper, false, jstOptionalExpr, jstNode) : new JstIdentifier(name.toString());
        }
        if (TranslateHelper.isStaticMember(identifier)) {
            JstType qualifierType;
            IJstNode binding;
            MethodKey mtdKey;
            TranslateInfo tInfo;
            JstIdentifier jstQualifier = VjoTranslateHelper.getStaticPtyOrMtdQualifier(identifier, jstNode);
            boolean forceFullyQualify = false;
            boolean usedQualifierType = false;
            IJstMethod jstMtd = TranslateHelper.Method.getOwnerMethod((IJstNode)jstNode);
            if (jstMtd != null && jstMtd.getOwnerType() instanceof JstType && (tInfo = this.getCtx().getTranslateInfo((JstType)jstMtd.getOwnerType())).getMethodCustomInfo(mtdKey = MethodKey.genMethodKey(jstMtd)).isForceFullyQualify()) {
                forceFullyQualify = true;
            }
            if (forceFullyQualify && (binding = identifier.getJstBinding()) != null && binding instanceof JstMethod && !(qualifierType = ((JstMethod)binding).getOwnerType()).isEmbededType()) {
                JstIdentifier q = new JstIdentifier(qualifierType.getName());
                q.setJstBinding((IJstNode)qualifierType);
                q.setType((IJstType)qualifierType);
                identifier.setQualifier(q);
                jstOptionalExpr = null;
                usedQualifierType = true;
            }
            if (!usedQualifierType && identifier.getQualifier() != null) {
                identifier.setQualifier(jstQualifier);
                jstOptionalExpr = null;
            }
        }
        IExpr mtdCall = null;
        IJstType calleeType = null;
        IJstMethod mtd = null;
        if (jstOptionalExpr != null && (calleeType = jstOptionalExpr.getResultType()) != null && !(calleeType instanceof JstParamType)) {
            if (calleeType instanceof JstTypeWithArgs) {
                calleeType = ((JstTypeWithArgs)calleeType).getType();
            }
            if ((mtd = TranslateHelper.Method.getMethod((ASTNode)astExpr, (IJstType)((BaseJstNode)calleeType).getOwnerType(), identifier.getName(), jstArgs)) != null) {
                identifier.setType(mtd.getRtnType());
            }
        }
        if (calleeType == null) {
            calleeType = jstNode.getOwnerType();
        }
        if ((mtdCall = this.getCustomTranslator().processMtdInvocation((ASTNode)astExpr, isSuper, jstOptionalExpr, identifier, jstArgs, jstNode)) == null) {
            MtdInvocationExpr methodCall = this.toMtdInvocationExpr(identifier, jstOptionalExpr, jstArgs, jstNode);
            if (mtd == null) {
                mtd = (IJstMethod)methodCall.getMethod();
            }
            if (mtd != null) {
                List exceptedArgs = mtd.getArgs();
                int exceptedLen = exceptedArgs.size();
                int actualLen = jstArgs.size();
                int len = Math.min(exceptedLen, actualLen);
                boolean vararg = exceptedLen != actualLen;
                AutoBoxer autoBoxer = AutoBoxer.getInstance();
                IJstType expectedType = null;
                int i = 0;
                while (i < len) {
                    JstArg arg = (JstArg)exceptedArgs.get(i);
                    IExpr expr = (IExpr)jstArgs.get(i);
                    if (autoBoxer.needAutoBoxing(expr, expectedType = arg.getType())) {
                        IExpr boxed = autoBoxer.autoBoxing(expr, expectedType);
                        methodCall.setArg(i, boxed);
                    }
                    ++i;
                }
                if (vararg && exceptedLen < actualLen) {
                    i = exceptedLen;
                    while (i < actualLen) {
                        IExpr expr = (IExpr)jstArgs.get(i);
                        if (autoBoxer.needAutoBoxing(expr, expectedType)) {
                            IExpr boxed = autoBoxer.autoBoxing(expr, expectedType);
                            methodCall.setArg(i, boxed);
                        }
                        ++i;
                    }
                }
            }
            mtdCall = methodCall;
        }
        IExpr qualifier = null;
        if (mtdCall instanceof MtdInvocationExpr) {
            MtdInvocationExpr mtdInvoke = (MtdInvocationExpr)mtdCall;
            IExpr mtdName = mtdInvoke.getMethodIdentifier();
            qualifier = mtdInvoke.getQualifyExpr();
            if (qualifier == null) {
                if (mtdName instanceof JstIdentifier && TranslateHelper.Expression.removeQualifier(qualifier = ((JstIdentifier)mtdName).getQualifier(), (IJstNode)mtdCall)) {
                    ((JstIdentifier)mtdName).setQualifier(null);
                }
            } else if (TranslateHelper.Expression.removeQualifier(qualifier, (IJstNode)mtdCall)) {
                ((MtdInvocationExpr)mtdCall).setQualifyExpr(null);
            }
        } else if (mtdCall instanceof PtyGetter) {
            PtyGetter ptyGetter = (PtyGetter)mtdCall;
            qualifier = ptyGetter.getQualifyExpr();
            if (qualifier == null) {
                JstIdentifier ptyName = ptyGetter.getPtyName();
                if (ptyName instanceof JstIdentifier && TranslateHelper.Expression.removeQualifier(qualifier = ptyName.getQualifier(), (IJstNode)mtdCall)) {
                    ptyName.setQualifier(null);
                }
            } else if (TranslateHelper.Expression.removeQualifier(qualifier, (IJstNode)mtdCall)) {
                ptyGetter.setQualifyExpr(null);
            }
        } else if (mtdCall instanceof PtySetter) {
            PtySetter ptySetter = (PtySetter)mtdCall;
            qualifier = ptySetter.getQualifyExpr();
            if (qualifier == null) {
                JstIdentifier ptyName = ptySetter.getPtyName();
                if (ptyName instanceof JstIdentifier && TranslateHelper.Expression.removeQualifier(qualifier = ptyName.getQualifier(), (IJstNode)mtdCall)) {
                    ptyName.setQualifier(null);
                }
            } else if (TranslateHelper.Expression.removeQualifier(qualifier, (IJstNode)mtdCall)) {
                ptySetter.setQualifyExpr(null);
            }
        }
        return mtdCall;
    }

    private MtdInvocationExpr toMtdInvocationExpr(JstIdentifier identifier, IExpr qualifyExpr, List<IExpr> jstArgs, BaseJstNode jstNode) {
        Object q = qualifyExpr instanceof ObjCreationExpr ? new ParenthesizedExpr(qualifyExpr) : qualifyExpr;
        MtdInvocationExpr mtdCall = new MtdInvocationExpr(identifier, new IExpr[0]);
        for (IExpr a : jstArgs) {
            mtdCall.addArg(a);
        }
        mtdCall.setQualifyExpr(q);
        mtdCall.setResultType(identifier.getResultType());
        mtdCall.setParent((IJstNode)jstNode);
        return mtdCall;
    }

    private IExpr toArrayCreation(ArrayCreation astExpr, BaseJstNode jstNode) {
        IExpr e;
        IJstType type = this.getDataTypeTranslator().processType((Type)astExpr.getType(), jstNode);
        if (type == null) {
            this.getLogger().logError("NullResult", "failed to translate type", this, (ASTNode)astExpr, jstNode);
            return null;
        }
        JstIdentifier identifier = new JstIdentifier(type.getName());
        identifier.setType(type);
        ArrayCreationExpr ace = new ArrayCreationExpr((IExpr)identifier);
        ArrayInitializer ai = astExpr.getInitializer();
        if (ai != null && (e = this.getExprTranslator().processExpression((Expression)ai, jstNode)) instanceof JstArrayInitializer) {
            if (type instanceof JstArray) {
                ((JstArrayInitializer)e).setType((JstArray)type);
            }
            return e;
        }
        List dimensions = astExpr.dimensions();
        for (Object o : dimensions) {
            if (o instanceof Expression) {
                ace.addDimension(this.getExprTranslator().processExpression((Expression)o, jstNode));
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)o, jstNode);
        }
        return ace;
    }

    private ILHS toLHS(Expression astExpr, BaseJstNode jstNode) {
        assert (astExpr != null) : "astExpr cannot be null";
        if (astExpr instanceof Name) {
            return this.toJstIdentifier(astExpr, jstNode, true);
        }
        if (astExpr instanceof FieldAccess || astExpr instanceof SuperFieldAccess) {
            return this.toFieldAccess(astExpr, jstNode, true);
        }
        if (astExpr instanceof ArrayAccess) {
            return this.toArrayAccess((ArrayAccess)astExpr, jstNode);
        }
        if (astExpr instanceof ParenthesizedExpression) {
            ParenthesizedExpression expr = (ParenthesizedExpression)astExpr;
            IExpr lhs = this.processExpression(expr.getExpression(), jstNode);
            if (lhs instanceof ILHS) {
                return (ILHS)lhs;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)astExpr, jstNode);
            return null;
        }
        this.getLogger().logUnhandledNode(this, (ASTNode)astExpr, jstNode);
        return null;
    }

    private JstLiteral toJstLiteral(Expression astExpr, BaseJstNode jstNode, boolean report) {
        if (astExpr instanceof PrefixExpression) {
            PrefixExpression pexpr = (PrefixExpression)astExpr;
            JstLiteral tmp = this.toJstLiteral(pexpr.getOperand(), jstNode, report);
            if (tmp != null) {
                return new SimpleLiteral(tmp.getResultType().getClass(), tmp.getResultType(), String.valueOf(pexpr.getOperator().toString()) + tmp.toValueText());
            }
            return null;
        }
        LiteralTranslator translator = this.getLiteralTranslator();
        if (astExpr instanceof NumberLiteral) {
            return translator.toJstLiteral((NumberLiteral)astExpr, jstNode);
        }
        if (astExpr instanceof CharacterLiteral) {
            return translator.toJstLiteral((CharacterLiteral)astExpr);
        }
        if (astExpr instanceof BooleanLiteral) {
            return translator.toJstLiteral((BooleanLiteral)astExpr);
        }
        if (astExpr instanceof StringLiteral) {
            return translator.toJstLiteral((StringLiteral)astExpr);
        }
        if (astExpr instanceof NullLiteral) {
            return translator.toJstLiteral((NullLiteral)astExpr);
        }
        if (report) {
            this.getLogger().logUnhandledNode(this, (ASTNode)astExpr, jstNode);
        }
        return null;
    }
}

