/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.report;

import java.io.PrintStream;
import java.util.ListIterator;
import org.eclipse.vjet.af.common.error.ErrorArgsInterface;
import org.eclipse.vjet.af.common.error.ErrorFilter;
import org.eclipse.vjet.af.common.error.ErrorId;
import org.eclipse.vjet.af.common.error.ErrorList;
import org.eclipse.vjet.af.common.error.ErrorNamedArgs;
import org.eclipse.vjet.af.common.error.ErrorObject;
import org.eclipse.vjet.af.common.error.ErrorSeverity;
import org.eclipse.vjet.dsf.javatojs.report.ErrorReportPolicy;
import org.eclipse.vjet.dsf.javatojs.report.ErrorReporter;

public class DefaultErrorReporter
implements ErrorReporter {
    private static final String MESSAGE = "message";
    private static final String RESOURCE = "resource";
    private static final String LINE = "line";
    private static final String COLUMN = "column";
    private static final ErrorId s_errorId = new ErrorId("javatojs.error.reporter");
    private static final ErrorFilter s_errorFilter = new ErrorFilter(){

        public boolean matches(ErrorObject errorObject) {
            return errorObject.isError();
        }
    };
    private static final ErrorFilter s_warningFilter = new ErrorFilter(){

        public boolean matches(ErrorObject errorObject) {
            return errorObject.isWarning();
        }
    };
    private ErrorList m_errors;
    private PrintStream m_err;
    private boolean m_reportErrors;
    private boolean m_reportWarnings;

    public DefaultErrorReporter() {
        this(System.err);
    }

    public DefaultErrorReporter(PrintStream err) {
        this.m_err = err;
        this.m_reportErrors = true;
        this.m_reportWarnings = true;
    }

    @Override
    public void report(ErrorReportPolicy.ReportLevel level, String message, String resource, int line, int column) {
        if (level == ErrorReportPolicy.ReportLevel.IGNORE) {
            return;
        }
        if (level == ErrorReportPolicy.ReportLevel.WARNING) {
            this.warning(message, resource, line, column);
        } else if (level == ErrorReportPolicy.ReportLevel.ERROR) {
            this.error(message, resource, line, column);
        }
    }

    @Override
    public void error(String message, String resource, int line, int column) {
        if (!this.m_reportErrors || message == null) {
            return;
        }
        ErrorNamedArgs args = new ErrorNamedArgs();
        args.add(MESSAGE, message);
        if (resource != null) {
            args.add(RESOURCE, resource);
        }
        args.add(LINE, String.valueOf(line));
        args.add(COLUMN, String.valueOf(column));
        this.addError(new ErrorObject(s_errorId, ErrorSeverity.ERROR, (ErrorArgsInterface)args));
    }

    @Override
    public void warning(String message, String resource, int line, int column) {
        if (!this.m_reportWarnings || message == null) {
            return;
        }
        ErrorNamedArgs args = new ErrorNamedArgs();
        args.add(MESSAGE, message);
        if (resource != null) {
            args.add(RESOURCE, resource);
        }
        args.add(LINE, String.valueOf(line));
        args.add(COLUMN, String.valueOf(column));
        this.addError(new ErrorObject(s_errorId, ErrorSeverity.WARNING, (ErrorArgsInterface)args));
    }

    @Override
    public boolean hasErrors() {
        if (this.m_errors == null) {
            return false;
        }
        return this.m_errors.hasAnyErrors(s_errorFilter);
    }

    @Override
    public boolean hasWarnings() {
        if (this.m_errors == null) {
            return false;
        }
        return this.m_errors.hasAnyErrors(s_warningFilter);
    }

    @Override
    public void reportErrors() {
        ErrorList errors = this.getErrors();
        ListIterator iter = errors.listIterator();
        while (iter.hasNext()) {
            ErrorObject eo = (ErrorObject)iter.next();
            this.m_err.println(this.formatAsString(eo));
        }
    }

    @Override
    public void reportWarnings() {
        ErrorList errors = this.getWarnings();
        ListIterator iter = errors.listIterator();
        while (iter.hasNext()) {
            ErrorObject eo = (ErrorObject)iter.next();
            this.m_err.println(this.formatAsString(eo));
        }
    }

    @Override
    public void reportAll() {
        this.reportErrors();
        this.reportWarnings();
    }

    @Override
    public void setReportErrors(boolean value) {
        this.m_reportErrors = value;
    }

    @Override
    public void setReportWarnings(boolean value) {
        this.m_reportWarnings = value;
    }

    private synchronized void addError(ErrorObject error) {
        if (this.m_errors == null) {
            this.m_errors = new ErrorList();
        }
        this.m_errors.add(error);
    }

    @Override
    public ErrorList getErrors() {
        if (this.m_errors == null) {
            return new ErrorList();
        }
        return this.m_errors.getAllErrors(s_errorFilter);
    }

    @Override
    public ErrorList getWarnings() {
        if (this.m_errors == null) {
            return new ErrorList();
        }
        return this.m_errors.getAllErrors(s_warningFilter);
    }

    private String formatAsString(ErrorObject eo) {
        StringBuilder msg = new StringBuilder();
        msg.append(String.valueOf(eo.getSeverity().getName()) + " : ");
        ErrorArgsInterface params = eo.getParameters();
        msg.append(params.getValueByName(MESSAGE));
        return msg.toString();
    }
}

