/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.vjet.dsf.javatojs.trace.ITranslateTracer;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.TranslationMode;
import org.eclipse.vjet.dsf.javatojs.translate.config.MethodKey;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomInfo;
import org.eclipse.vjet.dsf.javatojs.util.AstBindingHelper;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;

public abstract class BaseTypeVisitor
extends ASTVisitor {
    private TranslateCtx m_ctx;
    private TranslationMode m_mode;
    private CompilationUnit m_cu;
    private ASTNode m_bigBrother = null;
    private boolean m_skipImpl = false;
    private Stack<JstType> m_typeStack = new Stack();
    private Stack<JstMethod> m_mtdStack = new Stack();
    private Stack<JstBlock> m_blockStack = new Stack();
    private List<ASTNode> m_excludedNodes = new ArrayList<ASTNode>();
    private List<JstType> m_dependents = new ArrayList<JstType>();
    private ITranslateTracer m_tracer;

    public BaseTypeVisitor(JstType type, TranslationMode mode) {
        assert (mode != null) : "mode cannot be null";
        this.m_mode = mode;
        this.setCurType(type);
    }

    public void preVisit(ASTNode node) {
        if (node instanceof AbstractTypeDeclaration) {
            IJstType dependent;
            String nodeName = ((AbstractTypeDeclaration)node).getName().toString();
            JstType curType = this.getCurType();
            String typeName = curType.getSimpleName();
            if (typeName != null && !typeName.equals(nodeName) && (dependent = TranslateHelper.Type.getDependedType(curType, nodeName)) != null && dependent instanceof JstType) {
                curType = (JstType)dependent;
                this.setCurType(curType);
            }
            this.getCtx().getTranslateInfo(curType).addMode(this.m_mode);
        } else if (node instanceof AnonymousClassDeclaration) {
            JstType curType = this.getCurType();
            this.getCtx().getTranslateInfo(curType).addMode(this.m_mode);
        }
    }

    public void postVisit(ASTNode node) {
        if (node instanceof AbstractTypeDeclaration || node instanceof AnonymousClassDeclaration) {
            JstType curType = this.getCurType();
            if (this.m_mode.hasDependency()) {
                this.getCtx().getTranslateInfo(curType).getStatus().setDependencyDone();
            }
            if (this.m_mode.hasDeclaration()) {
                this.getCtx().getTranslateInfo(curType).getStatus().setDeclTranlationDone();
            }
            if (this.m_typeStack.size() > 1) {
                this.removeCurType();
            }
        }
    }

    public boolean visit(CompilationUnit cu) {
        if (cu == null) {
            return false;
        }
        this.m_cu = cu;
        if (this.m_cu.types().size() > 1) {
            for (Object node : this.m_cu.types()) {
                TypeDeclaration typeDecl = (TypeDeclaration)node;
                if (!typeDecl.getName().toString().equals(this.getCurType().getSimpleName())) continue;
                this.m_bigBrother = typeDecl;
                break;
            }
        }
        return true;
    }

    public boolean visit(ImportDeclaration astImport) {
        JstType jstType = this.getCtx().getProvider().getDataTypeTranslator().processImport(astImport, this.getCurType());
        if (jstType != null) {
            this.addDependency((IJstType)jstType, null);
        }
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        return this.visit((AbstractTypeDeclaration)node);
    }

    public boolean visit(EnumDeclaration node) {
        return this.visit((AbstractTypeDeclaration)node);
    }

    public boolean visit(FieldDeclaration node) {
        JstType curType = this.getCurType();
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(curType);
        IJstType fldType = this.getCtx().getProvider().getFieldTranslator().processField(node, curType);
        boolean include = false;
        Iterator ite = node.fragments().iterator();
        CustomInfo fInfo = null;
        IJstType customizedAsType = null;
        while (ite.hasNext()) {
            String fName = ((VariableDeclarationFragment)ite.next()).getName().getIdentifier();
            fInfo = tInfo.getFieldCustomInfo(fName);
            customizedAsType = fInfo.getAsType();
            if (include || fInfo.isExcluded()) continue;
            include = true;
        }
        if (!include) {
            this.m_excludedNodes.add((ASTNode)node);
            return false;
        }
        this.addDependency(customizedAsType, null);
        this.addDependency(fldType, (ASTNode)node.getType());
        return !this.m_skipImpl;
    }

    public boolean visit(EnumConstantDeclaration node) {
        this.getCtx().getProvider().getFieldTranslator().processEnumConstsDecl(node, this.getCurType());
        if (this.getCtx().getTranslateInfo(this.getCurType()).getFieldCustomInfo(node.getName().toString()).isExcluded()) {
            this.m_excludedNodes.add((ASTNode)node);
            return false;
        }
        return true;
    }

    public boolean visit(MethodDeclaration astMtd) {
        MethodKey mtdKey;
        TranslateCtx ctx = this.getCtx();
        JstType curType = this.getCurType();
        JstMethod mtd = ctx.getProvider().getMethodTranslator().processMethod(astMtd, curType);
        if (mtd == null) {
            return false;
        }
        TranslateInfo tInfo = this.getCtx().getTranslateInfo(curType);
        CustomInfo cInfo = tInfo.getMethodCustomInfo(mtdKey = MethodKey.genMethodKey(astMtd));
        if (cInfo.isExcluded()) {
            this.m_excludedNodes.add((ASTNode)astMtd);
            return false;
        }
        this.setCurMtd(mtd);
        this.setCurBlock(mtd.getBlock(true));
        if (cInfo.isMappedToJS() || cInfo.isMappedToVJO()) {
            return false;
        }
        IJstType customizedAsType = cInfo.getAsType();
        if (customizedAsType != null) {
            this.addDependency(customizedAsType, null);
        }
        IJstType rtnType = mtd.getRtnType();
        this.addDependency(rtnType, (ASTNode)astMtd.getReturnType2());
        for (JstArg arg : mtd.getArgs()) {
            IJstType argType = arg.getType();
            this.addDependency(argType, (ASTNode)AstBindingHelper.getAstType(arg));
        }
        return !this.m_skipImpl;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        return false;
    }

    public boolean visit(MarkerAnnotation node) {
        return false;
    }

    public boolean visit(NormalAnnotation node) {
        return false;
    }

    public boolean visit(SingleMemberAnnotation node) {
        return false;
    }

    public boolean visit(ParameterizedType node) {
        IJstType jstType = this.getCtx().getProvider().getDataTypeTranslator().processType(node.getType(), (BaseJstNode)this.getCurType());
        while (jstType != null && jstType instanceof JstTypeWithArgs) {
            jstType = ((JstTypeWithArgs)jstType).getType();
        }
        this.addDependency(jstType, (ASTNode)node.getType());
        return false;
    }

    public JstType getType() {
        return this.getCurType();
    }

    public TranslationMode getMode() {
        return this.m_mode;
    }

    public List<JstType> getDependency() {
        return Collections.unmodifiableList(this.m_dependents);
    }

    public boolean hasDependency(String name, boolean isJavaName) {
        if (name == null) {
            return false;
        }
        String jstName = name;
        if (isJavaName) {
            jstName = this.getCtx().getConfig().getPackageMapping().mapTo(name);
        }
        for (JstType t : this.m_dependents) {
            if (!jstName.equals(t.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean skipImpl() {
        return this.m_skipImpl;
    }

    protected BaseJstNode getScopeParent() {
        if (this.getCurBlock() != null) {
            return this.getCurBlock();
        }
        if (this.getCurMtd() != null) {
            return this.getCurMtd();
        }
        return this.getCurType();
    }

    protected BaseJstNode getCurrentDeclaration() {
        if (this.getCurMtd() != null) {
            return this.getCurMtd();
        }
        return this.getCurType();
    }

    protected BaseJstNode getCurScope() {
        if (this.getCurBlock() != null) {
            return this.getCurBlock();
        }
        if (this.getCurMtd() != null) {
            return this.getCurMtd();
        }
        return this.getCurType();
    }

    protected void setCurType(JstType type) {
        if (type == this.getCurType()) {
            return;
        }
        this.getCtx().getTranslateInfo(type).addMode(this.m_mode);
        this.m_typeStack.push(type);
    }

    protected JstType getCurType() {
        if (this.m_typeStack.isEmpty()) {
            return null;
        }
        return this.m_typeStack.peek();
    }

    protected JstType removeCurType() {
        if (!this.m_typeStack.isEmpty()) {
            return this.m_typeStack.pop();
        }
        return null;
    }

    protected void setCurMtd(JstMethod mtd) {
        this.m_mtdStack.push(mtd);
    }

    protected JstMethod getCurMtd() {
        if (this.m_mtdStack.isEmpty()) {
            return null;
        }
        return this.m_mtdStack.peek();
    }

    protected void removeCurMtd() {
        if (!this.m_mtdStack.isEmpty()) {
            this.m_mtdStack.pop();
        }
    }

    protected void setCurBlock(JstBlock block) {
        this.m_blockStack.push(block);
    }

    protected JstBlock getCurBlock() {
        if (this.m_blockStack.isEmpty()) {
            return null;
        }
        return this.m_blockStack.peek();
    }

    protected void removeCurBlock() {
        if (!this.m_blockStack.isEmpty()) {
            this.m_blockStack.pop();
        }
    }

    protected void addDependency(IJstType jstType, ASTNode astNode) {
        if (jstType == null || this.m_dependents.contains(jstType) || jstType.getOuterType() != null) {
            return;
        }
        JstType curType = this.getCurType();
        if (curType.getName() != null && curType.getName().equals(jstType.getName())) {
            return;
        }
        JstType outer = curType.getOuterType();
        while (outer != null) {
            if (outer.getName() != null && outer.getName().equals(jstType.getName())) {
                return;
            }
            outer = outer.getOuterType();
        }
        Name astName = null;
        if (astNode instanceof SimpleType) {
            astName = ((SimpleType)astNode).getName();
        } else if (astNode instanceof Name) {
            astName = (Name)astNode;
        }
        if (astName instanceof SimpleName && TranslateHelper.Type.isMapped(jstType, (SimpleName)astName)) {
            return;
        }
        if (jstType instanceof JstType) {
            this.m_dependents.add((JstType)jstType);
            return;
        }
        if (jstType instanceof JstTypeWithArgs) {
            this.addDependency(((JstTypeWithArgs)jstType).getType(), astNode);
            this.addDependency(((JstTypeWithArgs)jstType).getArgType(), astNode);
            return;
        }
    }

    protected ITranslateTracer getTracer() {
        if (this.m_tracer == null) {
            this.m_tracer = this.getCtx().getTraceManager().getTracer();
        }
        return this.m_tracer;
    }

    protected TranslateCtx getCtx() {
        if (this.m_ctx == null) {
            this.m_ctx = TranslateCtx.ctx();
        }
        return this.m_ctx;
    }

    private boolean visit(AbstractTypeDeclaration node) {
        String name;
        TranslateCtx ctx = this.getCtx();
        JstType curType = this.getCurType();
        if (this.m_cu.types().size() > 1 && this.m_cu.types().contains(node) && node != this.m_bigBrother) {
            JstType rootType = (JstType)this.m_typeStack.get(0);
            curType = TranslateHelper.Factory.createJstType((ASTNode)node, (IJstNode)rootType);
            curType.setPackage(rootType.getPackage());
            rootType.addSiblingType(curType);
            this.setCurType(curType);
        }
        JstType jstType = curType;
        ctx.getProvider().getTypeTranslator().processType(node, curType);
        if (TranslateHelper.Type.isEmbededType(node) && !(name = node.getName().toString()).equals(jstType.getSimpleName()) && (jstType = curType.getEmbededType(name)) == null) {
            jstType = ctx.getProvider().getTypeTranslator().processEmbededType(node, curType);
        }
        if (jstType == null) {
            return false;
        }
        if (ctx.isExcluded((IJstType)jstType)) {
            this.m_excludedNodes.add((ASTNode)node);
            return false;
        }
        this.m_skipImpl = ctx.isJavaOnly((IJstType)jstType) || ctx.isJSProxy((IJstType)jstType);
        List extend = curType.getExtendsRef();
        if (!extend.isEmpty()) {
            IJstTypeReference jstTypeRef = (IJstTypeReference)extend.get(0);
            this.addDependency(jstTypeRef.getReferencedType(), (ASTNode)AstBindingHelper.getAstType(jstTypeRef));
            return true;
        }
        IJstType baseType = ctx.getTranslateInfo(curType).getBaseType();
        if (baseType != null && baseType instanceof JstType) {
            Type astBase = null;
            if (node instanceof TypeDeclaration) {
                astBase = ((TypeDeclaration)node).getSuperclassType();
            }
            this.addDependency(baseType, (ASTNode)astBase);
        }
        return true;
    }
}

