/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.control.translate;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.vjet.dsf.common.trace.TraceAttr;
import org.eclipse.vjet.dsf.common.trace.event.TraceId;
import org.eclipse.vjet.dsf.javatojs.control.translate.BasePhase;
import org.eclipse.vjet.dsf.javatojs.control.translate.TranslationParallelRunner;
import org.eclipse.vjet.dsf.javatojs.control.translate.TypeVisitTask;
import org.eclipse.vjet.dsf.javatojs.parse.BaseTypeVisitor;
import org.eclipse.vjet.dsf.javatojs.parse.TypeDeclarationVisitor;
import org.eclipse.vjet.dsf.javatojs.parse.TypeDnDVisitor;
import org.eclipse.vjet.dsf.javatojs.trace.ITranslateTracer;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.trace.TranslationTraceId;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.TranslationMode;
import org.eclipse.vjet.dsf.javatojs.util.AstBindingHelper;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public class DeclarationPhase
extends BasePhase {
    private static final TraceId DECLARATION_PHASE = TranslationTraceId.DECLARATION_PHASE;

    public DeclarationPhase(List<JstType> types) {
        this(types, false);
    }

    public DeclarationPhase(List<JstType> types, boolean includeDependency) {
        super(new TranslationMode().addDeclaration());
        this.setStartingTypes(types);
        if (includeDependency) {
            this.getMode().addDependency();
        }
    }

    public List<JstType> translate() {
        ITranslateTracer tracer = this.getTracer();
        tracer.startGroup(DECLARATION_PHASE, new TraceAttr[0]);
        try {
            TranslateCtx ctx = this.getCtx();
            TranslationMode mode = this.getMode();
            ArrayList<TypeVisitTask> tasks = new ArrayList<TypeVisitTask>();
            for (JstType jstType : this.getStartingTypes()) {
                if (jstType == null) {
                    this.addError(new TranslateError("NullInput", "jstType is null"));
                    continue;
                }
                TranslateInfo tInfo = ctx.getTranslateInfo(jstType);
                if (mode.hasDeclaration() && tInfo.getMode().hasDeclaration() || mode.hasDependency() && tInfo.getMode().hasDependency()) continue;
                CompilationUnit cu = AstBindingHelper.getCompilationUnit(jstType);
                String srcName = AstBindingHelper.getSourceName((IJstNode)jstType);
                ctx.getTranslateInfo(jstType).addMode(mode);
                BaseTypeVisitor visitor = this.createVisitor(jstType);
                tasks.add(new TypeVisitTask(srcName, cu, visitor, this.getTracer(jstType), ctx));
            }
            if (tasks.size() == 1 || !ctx.isParallelEnabled()) {
                for (TypeVisitTask task : tasks) {
                    task.execute();
                    this.addDependency(task.getVisitor());
                    this.setExceptions(task.getType(), task.getExceptions());
                }
            } else if (tasks.size() > 0) {
                TranslationParallelRunner.getInstance().execute(tasks);
                for (TypeVisitTask task : tasks) {
                    this.addDependency(task.getVisitor());
                    this.setExceptions(task.getType(), task.getExceptions());
                }
            }
            this.mergeTraces();
            List<JstType> list = this.getDependentTypes();
            return list;
        }
        finally {
            tracer.endGroup(DECLARATION_PHASE, this.getErrors());
        }
    }

    private BaseTypeVisitor createVisitor(JstType type) {
        if (this.getMode().hasDependency() && !this.getCtx().isJavaOnly((IJstType)type)) {
            return new TypeDnDVisitor(type);
        }
        return new TypeDeclarationVisitor(type);
    }
}

