/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.kernel.stage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.kernel.stage.DefaultStageProvider;
import org.eclipse.vjet.kernel.stage.IStage;

public class StageGraph<T> {
    private List<Path<T>> m_paths = new ArrayList<Path<T>>(5);
    private DefaultStageProvider<T> m_provider = new DefaultStageProvider();

    public Path<T> newPath() {
        Path path = new Path(this);
        this.add(path);
        return path;
    }

    public Path<T> getPath(T stageId) {
        if (stageId == null || this.m_paths.isEmpty()) {
            return null;
        }
        for (Path<T> path : this.m_paths) {
            if (!path.contains(stageId)) continue;
            return path;
        }
        return null;
    }

    public Path<T> getCurrentPath() {
        if (this.m_paths.isEmpty()) {
            return this.newPath();
        }
        return this.m_paths.get(this.m_paths.size() - 1);
    }

    public void add(T stageId) {
        this.getCurrentPath().add(stageId);
    }

    public void add(IStage<T> stage) {
        this.getCurrentPath().add(stage);
    }

    public boolean contains(T stageId) {
        if (stageId == null || this.m_paths.isEmpty()) {
            return false;
        }
        for (Path<T> path : this.m_paths) {
            if (!path.contains(stageId)) continue;
            return true;
        }
        return false;
    }

    public T getFirst() {
        if (this.m_paths.isEmpty()) {
            return null;
        }
        Path<T> path = this.m_paths.get(0);
        if (path != null) {
            return path.getHead();
        }
        return null;
    }

    public T getNext(T stageId) {
        if (stageId == null) {
            return null;
        }
        Path<T> path = this.getPath(stageId);
        if (path == null) {
            return null;
        }
        return path.getNext(stageId);
    }

    public IStage<T> get(T id) {
        if (id == null) {
            throw new RuntimeException("id is null");
        }
        return this.m_provider.get(id);
    }

    public Map<T, IStage<T>> getAll() {
        return this.m_provider.getAll();
    }

    public List<Path<T>> getAllPaths() {
        if (this.m_paths == null || this.m_paths.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_paths);
    }

    public boolean isEmpty() {
        if (this.m_paths.isEmpty()) {
            return true;
        }
        for (Path<T> path : this.m_paths) {
            if (path.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clearAll() {
        this.m_paths.clear();
        this.m_provider.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Path<T> path : this.m_paths) {
            sb.append(path);
            if (path.getLinkTo() != null) {
                sb.append(" => ");
                sb.append(path.getLinkTo());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected void register(IStage<T> stage) {
        this.m_provider.add((IStage)stage);
    }

    protected void add(Path<T> path) {
        if (path == null) {
            throw new RuntimeException("path is null");
        }
        this.m_paths.add(path);
    }

    public static class Hook<T> {
        private final T m_fromAddr;
        private List<T> m_toAddrs;

        Hook(T fromAddr) {
            this.m_fromAddr = fromAddr;
        }

        public T getFromAddr() {
            return this.m_fromAddr;
        }

        public List<T> getToAddrs() {
            if (this.m_toAddrs == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.m_toAddrs);
        }

        void addToAddr(T toAddr) {
            if (this.m_toAddrs == null) {
                this.m_toAddrs = new ArrayList<T>();
            }
            this.m_toAddrs.add(toAddr);
        }
    }

    public static class Path<T> {
        private StageGraph<T> m_graph;
        private List<T> m_stageIds = new ArrayList<T>(5);
        private T m_linkTo;

        protected Path(StageGraph<T> graph) {
            if (graph == null) {
                throw new RuntimeException("graph is null");
            }
            this.m_graph = graph;
        }

        public boolean isEmpty() {
            return this.m_stageIds.isEmpty();
        }

        public boolean contains(T stageId) {
            return this.m_stageIds.contains(stageId);
        }

        public int indexOf(T stageId) {
            return this.m_stageIds.indexOf(stageId);
        }

        public int size() {
            return this.m_stageIds.size();
        }

        public T getHead() {
            if (this.m_stageIds.isEmpty()) {
                return null;
            }
            return this.m_stageIds.get(0);
        }

        public T getNext(T stageId) {
            int index = this.indexOf(stageId);
            if (index < 0 || index == this.m_stageIds.size() - 1) {
                return null;
            }
            return this.m_stageIds.get(++index);
        }

        public T getTail() {
            if (this.m_stageIds.isEmpty()) {
                return null;
            }
            return this.m_stageIds.get(this.m_stageIds.size() - 1);
        }

        public T getLinkTo() {
            return this.m_linkTo;
        }

        public Path<T> add(T stageId) {
            if (stageId == null) {
                throw new RuntimeException("stageId is null");
            }
            if (this.m_graph.contains(stageId)) {
                throw new RuntimeException("Already exists: " + stageId);
            }
            this.m_stageIds.add(stageId);
            return this;
        }

        public Path<T> add(IStage<T> stage) {
            if (stage == null) {
                throw new RuntimeException("stage is null");
            }
            this.m_graph.register(stage);
            return this.add(stage.getId());
        }

        public Path<T> add(int index, IStage<T> stage) {
            if (stage == null) {
                throw new RuntimeException("stage is null");
            }
            this.m_graph.register(stage);
            return this.add(index, stage.getId());
        }

        public Path<T> add(int index, T stageId) {
            if (stageId == null) {
                throw new RuntimeException("stageId is null");
            }
            if (this.m_graph.contains(stageId)) {
                throw new RuntimeException("Already exists: " + stageId);
            }
            this.m_stageIds.add(index, stageId);
            return this;
        }

        public Path<T> insert(T refStageId, T newStageId) {
            if (refStageId == null) {
                throw new RuntimeException("refStageId is null");
            }
            int index = this.m_stageIds.indexOf(refStageId);
            if (index < 0) {
                throw new RuntimeException("refStageId not found: " + refStageId);
            }
            return this.add(index, newStageId);
        }

        public Path<T> insert(T refStageId, IStage<T> newStage) {
            if (refStageId == null) {
                throw new RuntimeException("refStageId is null");
            }
            int index = this.m_stageIds.indexOf(refStageId);
            if (index < 0) {
                throw new RuntimeException("refStageId not found: " + refStageId);
            }
            return this.add(index, (T)newStage);
        }

        public void linkTo(T next) {
            if (next == null) {
                throw new RuntimeException("toAddr is null");
            }
            this.m_linkTo = next;
        }

        public void linkTo(Path<T> path) {
            if (path == null) {
                throw new RuntimeException("path is null");
            }
            this.linkTo(path.getHead());
        }

        public List<T> getAll() {
            if (this.m_stageIds == null || this.m_stageIds.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.m_stageIds);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            T head = this.getHead();
            sb.append(head);
            T stageId = this.getNext(head);
            while (stageId != null) {
                sb.append(" -> ");
                sb.append(stageId);
                stageId = this.getNext(stageId);
            }
            return sb.toString();
        }

        protected StageGraph<T> getGraph() {
            return this.m_graph;
        }
    }
}

