/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.mod.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.mod.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.mod.ui.text.IColorManager;
import org.eclipse.dltk.mod.ui.text.TodoTagRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class ScriptCommentScanner
extends AbstractScriptScanner {
    private final String[] fProperties;
    private final ITodoTaskPreferences preferences;
    private int state = 0;
    private static final int STATE_START = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_BODY = 2;
    private static final char COMMENT_CHAR = '#';

    public ScriptCommentScanner(IColorManager manager, IPreferenceStore store, String comment, String todoTag, ITodoTaskPreferences preferences) {
        super(manager, store);
        this.fProperties = new String[]{comment, todoTag};
        this.preferences = preferences;
        this.initialize();
    }

    @Override
    protected String[] getTokenProperties() {
        return this.fProperties;
    }

    @Override
    protected List createRules() {
        this.setDefaultReturnToken((IToken)this.getToken(this.fProperties[0]));
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add(this.createTodoRule());
        return rules;
    }

    protected IRule createTodoRule() {
        return new TodoTagRule((IToken)this.getToken(this.fProperties[1]), this.preferences.getTagNames(), this.preferences.isCaseSensitive());
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.state = 0;
    }

    @Override
    public IToken nextToken() {
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        if (this.state == 0) {
            this.state = 1;
            int count = 0;
            int c = this.read();
            if (c == 35) {
                c = this.read();
                ++count;
            }
            while (c != -1 && Character.isWhitespace((char)c)) {
                c = this.read();
                ++count;
            }
            this.unread();
            if (count > 0) {
                return this.fDefaultReturnToken;
            }
            if (c == -1) {
                return Token.EOF;
            }
        }
        if (this.state == 1) {
            this.state = 2;
            IToken token = this.fRules[0].evaluate((ICharacterScanner)this);
            if (!token.isUndefined()) {
                return token;
            }
        }
        int count = 0;
        while (this.read() != -1) {
            ++count;
        }
        return count > 0 ? this.fDefaultReturnToken : Token.EOF;
    }
}

