/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.preferences;

import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.VariableBlock;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.preferences.PreferencesMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BuildpathVariablesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.dltk.mod.ui.preferences.BuildpathVariablesPreferencePage";
    public static final String DATA_SELECT_VARIABLE = "BuildpathVariablesPreferencePage.select_var";
    private VariableBlock fVariableBlock;
    private String fStoredSettings;

    public BuildpathVariablesPreferencePage() {
        this.setPreferenceStore(DLTKUIPlugin.getDefault().getPreferenceStore());
        this.fVariableBlock = new VariableBlock(true, null);
        this.fStoredSettings = null;
        this.setTitle(PreferencesMessages.BuildpathVariablesPreferencePage_title);
        this.setDescription(PreferencesMessages.BuildpathVariablesPreferencePage_description);
        this.noDefaultAndApplyButton();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        Control result = this.fVariableBlock.createContents(parent);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        DLTKUIPlugin.getDefault().savePluginPreferences();
        return this.fVariableBlock.performOk();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fStoredSettings != null && !this.fStoredSettings.equals(this.getCurrentSettings())) {
                this.fVariableBlock.refresh(null);
            }
        } else {
            if (this.fVariableBlock.hasChanges()) {
                String title = PreferencesMessages.BuildpathVariablesPreferencePage_savechanges_title;
                String message = PreferencesMessages.BuildpathVariablesPreferencePage_savechanges_message;
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message)) {
                    this.performOk();
                }
                this.fVariableBlock.setChanges(false);
            }
            this.fStoredSettings = this.getCurrentSettings();
        }
        super.setVisible(visible);
    }

    private String getCurrentSettings() {
        StringBuffer buf = new StringBuffer();
        String[] names = DLTKCore.getBuildpathVariableNames();
        int i = 0;
        while (i < names.length) {
            String curr = names[i];
            buf.append(curr).append('\u0000');
            IPath val = DLTKCore.getBuildpathVariable((String)curr);
            if (val != null) {
                buf.append(val.toString());
            }
            buf.append('\u0000');
            ++i;
        }
        return buf.toString();
    }

    public void applyData(Object data) {
        Object id;
        if (data instanceof Map && (id = ((Map)data).get(DATA_SELECT_VARIABLE)) instanceof String) {
            this.fVariableBlock.setSelection((String)id);
        }
        super.applyData(data);
    }
}

