/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.wizards.buildpath;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.mod.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.AddSourceFolderWizard;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.BuildPathBasePage;
import org.eclipse.dltk.mod.internal.ui.wizards.buildpath.MultipleFolderSelectionDialog;
import org.eclipse.dltk.mod.ui.actions.AbstractOpenWizardAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CreateMultipleSourceFoldersDialog
extends TrayDialog {
    private final IScriptProject fScriptProject;
    private final BPListElement[] fExistingElements;
    private final HashSet fRemovedElements;
    private final HashSet fModifiedElements;
    private final HashSet fInsertedElements;
    private final Hashtable fNonExistingFolders;

    public CreateMultipleSourceFoldersDialog(IScriptProject scriptProject, BPListElement[] existingElements, Shell shell) {
        super(shell);
        this.fScriptProject = scriptProject;
        this.fExistingElements = existingElements;
        this.fRemovedElements = new HashSet();
        this.fModifiedElements = new HashSet();
        this.fInsertedElements = new HashSet();
        this.fNonExistingFolders = new Hashtable();
        int i = 0;
        while (i < existingElements.length) {
            BPListElement cur = existingElements[i];
            if (cur.getResource() == null || !cur.getResource().exists()) {
                this.addFakeFolder((IContainer)this.fScriptProject.getProject(), cur);
            }
            ++i;
        }
    }

    public int open() {
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        List existingContainers = this.getExistingContainers(this.fExistingElements);
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.fScriptProject.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        FakeFolderBaseWorkbenchContentProvider cp = new FakeFolderBaseWorkbenchContentProvider();
        String title = NewWizardMessages.SourceContainerWorkbookPage_ExistingSourceFolderDialog_new_title;
        String message = NewWizardMessages.SourceContainerWorkbookPage_ExistingSourceFolderDialog_edit_description;
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp){

            @Override
            protected Control createDialogArea(Composite parent) {
                Control result = super.createDialogArea(parent);
                if (DLTKCore.DEBUG) {
                    System.err.println("CreateMultipleSourceFoldersDialog: Add help support");
                }
                return result;
            }

            @Override
            protected Object createFolder(IContainer container) {
                final Object[] result = new Object[1];
                final BPListElement newElement = new BPListElement(CreateMultipleSourceFoldersDialog.this.fScriptProject, 3, false);
                final AddSourceFolderWizard wizard = CreateMultipleSourceFoldersDialog.this.newSourceFolderWizard(newElement, CreateMultipleSourceFoldersDialog.this.fExistingElements, container);
                AbstractOpenWizardAction action = new AbstractOpenWizardAction(){

                    @Override
                    protected INewWizard createWizard() throws CoreException {
                        return wizard;
                    }
                };
                action.addPropertyChangeListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getProperty().equals("result")) {
                            if (event.getNewValue().equals(Boolean.TRUE)) {
                                result[0] = CreateMultipleSourceFoldersDialog.this.addFakeFolder((IContainer)CreateMultipleSourceFoldersDialog.this.fScriptProject.getProject(), newElement);
                            } else {
                                wizard.cancel();
                            }
                        }
                    }
                });
                action.run();
                return result[0];
            }
        };
        dialog.setExisting(existingContainers.toArray());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(filter);
        dialog.setInput(this.fScriptProject.getProject().getParent());
        dialog.setInitialFocus(this.fScriptProject.getProject());
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            int i2 = 0;
            while (i2 < elements.length) {
                IResource res = (IResource)elements[i2];
                this.fInsertedElements.add(new BPListElement(this.fScriptProject, 3, res.getFullPath(), res, false));
                ++i2;
            }
            if (this.fExistingElements.length != 1) {
                ArrayList added = new ArrayList(this.fInsertedElements);
                HashSet updatedEclusionPatterns = new HashSet();
                this.addExlusionPatterns(added, updatedEclusionPatterns);
                this.fModifiedElements.addAll(updatedEclusionPatterns);
            }
            return 0;
        }
        return 1;
    }

    public List getInsertedElements() {
        return new ArrayList(this.fInsertedElements);
    }

    public List getRemovedElements() {
        return new ArrayList(this.fRemovedElements);
    }

    public List getModifiedElements() {
        return new ArrayList(this.fModifiedElements);
    }

    private void addExlusionPatterns(List newEntries, Set modifiedEntries) {
        BuildPathBasePage.fixNestingConflicts(newEntries.toArray(new BPListElement[newEntries.size()]), this.fExistingElements, modifiedEntries);
        if (!modifiedEntries.isEmpty()) {
            String title = NewWizardMessages.SourceContainerWorkbookPage_exclusion_added_title;
            String message = NewWizardMessages.SourceContainerWorkbookPage_exclusion_added_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private AddSourceFolderWizard newSourceFolderWizard(BPListElement element, BPListElement[] existing, IContainer parent) {
        AddSourceFolderWizard wizard = new AddSourceFolderWizard(existing, element, false, true, false, false, false, parent);
        wizard.setDoFlushChange(false);
        return wizard;
    }

    private List getExistingContainers(BPListElement[] existingElements) {
        ArrayList<Object> res = new ArrayList<Object>();
        int i = 0;
        while (i < existingElements.length) {
            IResource resource = existingElements[i].getResource();
            if (resource instanceof IContainer) {
                res.add(resource);
            }
            ++i;
        }
        Set keys = this.fNonExistingFolders.keySet();
        for (IFolder folder : keys) {
            res.add(folder);
        }
        return res;
    }

    private IFolder addFakeFolder(IContainer container, BPListElement element) {
        IContainer parent;
        IFolder result;
        IPath path;
        IPath projectPath = this.fScriptProject.getPath();
        if (projectPath.isPrefixOf(path = element.getPath())) {
            path = path.removeFirstSegments(projectPath.segmentCount());
        }
        Object folder = result = container.getFolder(path);
        do {
            parent = folder.getParent();
            this.fNonExistingFolders.put(folder, parent);
        } while ((folder = parent instanceof IFolder ? (IFolder)parent : null) != null && !folder.exists());
        return result;
    }

    private final class FakeFolderBaseWorkbenchContentProvider
    extends BaseWorkbenchContentProvider {
        private FakeFolderBaseWorkbenchContentProvider() {
        }

        public Object getParent(Object element) {
            Object object = CreateMultipleSourceFoldersDialog.this.fNonExistingFolders.get(element);
            if (object != null) {
                return object;
            }
            return super.getParent(element);
        }

        public Object[] getChildren(Object element) {
            ArrayList<Object> result = new ArrayList<Object>();
            Set keys = CreateMultipleSourceFoldersDialog.this.fNonExistingFolders.keySet();
            for (Object key : keys) {
                if (!CreateMultipleSourceFoldersDialog.this.fNonExistingFolders.get(key).equals(element)) continue;
                result.add(key);
            }
            if (result.size() == 0) {
                return super.getChildren(element);
            }
            Object[] children = super.getChildren(element);
            int i = 0;
            while (i < children.length) {
                result.add(children[i]);
                ++i;
            }
            return result.toArray();
        }
    }
}

