/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.wizards;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.mod.core.DLTKContentTypeManager;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.internal.core.BuildpathEntry;
import org.eclipse.dltk.mod.internal.ui.wizards.Messages;
import org.eclipse.dltk.mod.launching.ScriptRuntime;

public class BuildpathDetector {
    private HashMap fSourceFolders = new HashMap();
    private List fSourceFiles;
    private HashSet fZIPFiles = new HashSet(10);
    private IProject fProject;
    private IBuildpathEntry[] fResultBuildpath;
    private IProgressMonitor fMonitor;
    private IDLTKLanguageToolkit fToolkit;

    public BuildpathDetector(IProject project, IDLTKLanguageToolkit toolkit) throws CoreException {
        this.fSourceFiles = new ArrayList(100);
        this.fProject = project;
        this.fResultBuildpath = null;
        this.fToolkit = toolkit;
    }

    private boolean isNested(IPath path, Iterator iter) {
        while (iter.hasNext()) {
            IPath other = (IPath)iter.next();
            if (!other.isPrefixOf(path)) continue;
            return true;
        }
        return false;
    }

    public void detectBuildpath(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IBuildpathEntry entry;
            monitor.beginTask(Messages.BuildpathDetector_detectingBuildpath, 120);
            this.fMonitor = monitor;
            final ArrayList correctFiles = new ArrayList();
            this.fProject.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    return BuildpathDetector.this.visit(proxy, correctFiles);
                }
            }, 0);
            monitor.worked(10);
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 80);
            this.processSources(correctFiles, sub);
            sub.done();
            ArrayList<IBuildpathEntry> cpEntries = new ArrayList<IBuildpathEntry>();
            this.detectSourceFolders(cpEntries);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(10);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(10);
            this.detectLibraries(cpEntries);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(10);
            this.addInterpreterContainer(cpEntries);
            if (cpEntries.size() == 1 && (entry = (IBuildpathEntry)cpEntries.get(0)).getEntryKind() == 5) {
                cpEntries.add(0, DLTKCore.newSourceEntry((IPath)this.fProject.getFullPath()));
            }
            if (cpEntries.isEmpty() && this.fSourceFiles.isEmpty()) {
                return;
            }
            IBuildpathEntry[] entries = cpEntries.toArray(new IBuildpathEntry[cpEntries.size()]);
            if (!BuildpathEntry.validateBuildpath((IScriptProject)DLTKCore.create((IProject)this.fProject), (IBuildpathEntry[])entries).isOK()) {
                return;
            }
            this.fResultBuildpath = entries;
        }
        finally {
            monitor.done();
        }
    }

    protected void processSources(List correctFiles, SubProgressMonitor sub) {
    }

    protected void addInterpreterContainer(ArrayList cpEntries) {
        cpEntries.add(DLTKCore.newContainerEntry((IPath)new Path(ScriptRuntime.INTERPRETER_CONTAINER)));
    }

    private void detectLibraries(ArrayList cpEntries) {
        if (this.fToolkit.languageSupportZIPBuildpath()) {
            ArrayList<IBuildpathEntry> res = new ArrayList<IBuildpathEntry>();
            Set sourceFolderSet = this.fSourceFolders.keySet();
            for (IPath path : this.fZIPFiles) {
                if (this.isNested(path, sourceFolderSet.iterator())) continue;
                IBuildpathEntry entry = DLTKCore.newLibraryEntry((IPath)path);
                res.add(entry);
            }
            Collections.sort(res, new BPSorter());
            cpEntries.addAll(res);
        }
    }

    private void detectSourceFolders(ArrayList resEntries) {
        ArrayList<IBuildpathEntry> res = new ArrayList<IBuildpathEntry>();
        Set sourceFolderSet = this.fSourceFolders.keySet();
        for (IPath path : sourceFolderSet) {
            boolean primary = true;
            for (IPath other : sourceFolderSet) {
                if (path.equals((Object)other) || !other.isPrefixOf(path)) continue;
                primary = false;
                break;
            }
            if (!primary) continue;
            boolean isHidden = false;
            int i = 0;
            while (i < path.segmentCount()) {
                if (path.segment(i).startsWith(".")) {
                    isHidden = true;
                    break;
                }
                ++i;
            }
            if (isHidden) continue;
            IBuildpathEntry entry = DLTKCore.newSourceEntry((IPath)path);
            res.add(entry);
        }
        Collections.sort(res, new BPSorter());
        resEntries.addAll(res);
    }

    private void addToMap(HashMap map, IPath folderPath, IPath relPath) {
        ArrayList<IPath> list = (ArrayList<IPath>)map.get(folderPath);
        if (list == null) {
            list = new ArrayList<IPath>(50);
            map.put(folderPath, list);
        }
        list.add(relPath);
    }

    private IPath getFolderPath(IPath packPath, IPath relpath) {
        IPath common;
        int remainingSegments = packPath.segmentCount() - relpath.segmentCount();
        if (remainingSegments >= 0 && (common = packPath.removeFirstSegments(remainingSegments)).equals((Object)relpath)) {
            return packPath.uptoSegment(remainingSegments);
        }
        return null;
    }

    private boolean hasExtension(String name, String ext) {
        return name.endsWith(ext) && ext.length() != name.length();
    }

    public boolean visit(IResourceProxy proxy, List files) {
        if (this.fMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (proxy.getType() == 1) {
            String name = proxy.getName();
            IResource res = proxy.requestResource();
            if (this.visitSourceModule((IFile)res)) {
                files.add(res);
            } else if (res.getType() == 1 && (this.hasExtension(name, ".zip") || this.hasExtension(name, ".jar"))) {
                this.fZIPFiles.add(proxy.requestFullPath());
            }
            return false;
        }
        return true;
    }

    protected boolean visitSourceModule(IFile file) {
        if (DLTKContentTypeManager.isValidResourceForContentType((IDLTKLanguageToolkit)this.fToolkit, (IResource)file)) {
            IPath packPath = file.getParent().getFullPath();
            String cuName = file.getName();
            this.addToMap(this.fSourceFolders, packPath, (IPath)new Path(cuName));
            return true;
        }
        return false;
    }

    public IBuildpathEntry[] getBuildpath() {
        return this.fResultBuildpath;
    }

    private static class BPSorter
    implements Comparator {
        private Collator fCollator = Collator.getInstance();

        private BPSorter() {
        }

        public int compare(Object o1, Object o2) {
            IBuildpathEntry e1 = (IBuildpathEntry)o1;
            IBuildpathEntry e2 = (IBuildpathEntry)o2;
            return this.fCollator.compare(e1.getPath().toString(), e2.getPath().toString());
        }
    }
}

