/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.callhierarchy;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.mod.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.dltk.mod.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.dltk.mod.internal.ui.search.DLTKSearchScopeFactory;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.util.ExceptionHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkingSet;

class SelectWorkingSetAction
extends Action {
    private final SearchScopeActionGroup fGroup;

    public SelectWorkingSetAction(SearchScopeActionGroup group) {
        super(CallHierarchyMessages.SearchScopeActionGroup_workingset_select_text);
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_workingset_select_tooltip);
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    public void run() {
        try {
            IWorkingSet[] workingSets = DLTKSearchScopeFactory.getInstance().queryWorkingSets();
            if (workingSets != null) {
                this.fGroup.setActiveWorkingSets(workingSets);
                SearchUtil.updateLRUWorkingSets(workingSets);
            } else {
                this.fGroup.setActiveWorkingSets(null);
            }
        }
        catch (ModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), DLTKUIPlugin.getActiveWorkbenchShell(), CallHierarchyMessages.SelectWorkingSetAction_error_title, CallHierarchyMessages.SelectWorkingSetAction_error_message);
        }
    }
}

