/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ScriptModelUtil;
import org.eclipse.dltk.mod.internal.corext.refactoring.changes.UndoSourceModuleChange;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.UndoEdit;

public class SourceModuleChange
extends TextFileChange {
    private ISourceModule fCUnit;

    public SourceModuleChange(String name, ISourceModule cunit) {
        super(name, SourceModuleChange.getFile(cunit));
        Assert.isNotNull((Object)cunit);
        this.fCUnit = cunit;
        this.setTextType("java");
    }

    private static IFile getFile(ISourceModule cunit) {
        return (IFile)cunit.getResource();
    }

    public Object getModifiedElement() {
        return this.fCUnit;
    }

    public ISourceModule getSourceModule() {
        return this.fCUnit;
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        this.fCUnit.becomeWorkingCopy(null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        return super.acquireDocument((IProgressMonitor)new SubProgressMonitor(pm, 1));
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        super.releaseDocument(document, pm);
        try {
            this.fCUnit.discardWorkingCopy();
        }
        finally {
            if (!this.isDocumentAcquired()) {
                if (this.fCUnit.isWorkingCopy()) {
                    ScriptModelUtil.reconcile((ISourceModule)this.fCUnit);
                } else {
                    this.fCUnit.makeConsistent(pm);
                }
            }
        }
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        try {
            return new UndoSourceModuleChange(this.getName(), this.fCUnit, edit, stampToRestore, this.getSaveMode());
        }
        catch (CoreException e) {
            DLTKUIPlugin.log(e);
            return null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (ISourceModule.class.equals((Object)adapter)) {
            return this.fCUnit;
        }
        return super.getAdapter(adapter);
    }
}

