/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.dltk.mod.formatter.AbstractFormatterNode;
import org.eclipse.dltk.mod.formatter.IFormatterContainerNode;
import org.eclipse.dltk.mod.formatter.IFormatterContext;
import org.eclipse.dltk.mod.formatter.IFormatterDocument;
import org.eclipse.dltk.mod.formatter.IFormatterNode;
import org.eclipse.dltk.mod.formatter.IFormatterWriter;

public class FormatterBlockNode
extends AbstractFormatterNode
implements IFormatterContainerNode {
    private final List body = new ArrayList();

    public FormatterBlockNode(IFormatterDocument document) {
        super(document);
    }

    protected void acceptNodes(List nodes, IFormatterContext context, IFormatterWriter visitor) throws Exception {
        for (IFormatterNode node : nodes) {
            context.enter(node);
            node.accept(context, visitor);
            context.leave(node);
        }
    }

    @Override
    public void addChild(IFormatterNode child) {
        this.body.add(child);
    }

    @Override
    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        this.acceptBody(context, visitor);
    }

    protected void acceptBody(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        this.acceptNodes(this.body, context, visitor);
    }

    @Override
    public int getEndOffset() {
        if (!this.body.isEmpty()) {
            return ((IFormatterNode)this.body.get(this.body.size() - 1)).getEndOffset();
        }
        return 0;
    }

    @Override
    public int getStartOffset() {
        if (!this.body.isEmpty()) {
            return ((IFormatterNode)this.body.get(0)).getStartOffset();
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        for (IFormatterNode node : this.body) {
            if (node.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getChildren() {
        return Collections.unmodifiableList(this.body);
    }

    @Override
    public String toString() {
        return this.body.toString();
    }

    protected boolean isIndenting() {
        return true;
    }

    @Override
    public List getBody() {
        return this.body;
    }
}

