/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ti.goals;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.ast.ASTNode;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.search.FieldReferenceMatch;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.core.search.MethodReferenceMatch;
import org.eclipse.dltk.mod.core.search.SearchEngine;
import org.eclipse.dltk.mod.core.search.SearchMatch;
import org.eclipse.dltk.mod.core.search.SearchParticipant;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.dltk.mod.core.search.SearchRequestor;
import org.eclipse.dltk.mod.ti.GoalState;
import org.eclipse.dltk.mod.ti.IContext;
import org.eclipse.dltk.mod.ti.ISourceModuleContext;
import org.eclipse.dltk.mod.ti.goals.GoalEvaluator;
import org.eclipse.dltk.mod.ti.goals.IGoal;
import org.eclipse.dltk.mod.ti.goals.ItemReference;
import org.eclipse.dltk.mod.ti.goals.PossiblePosition;

public abstract class SearchBasedGoalEvaluator
extends GoalEvaluator {
    private List possiblePositionsGoals = new ArrayList();
    private List references = new ArrayList();
    private SearchRequestor requestor = new SearchRequestor(){

        @Override
        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            SearchMatch match2;
            ASTNode node = null;
            if (match instanceof FieldReferenceMatch) {
                match2 = (FieldReferenceMatch)match;
                node = ((FieldReferenceMatch)match2).getNode();
            }
            if (match instanceof MethodReferenceMatch) {
                match2 = (MethodReferenceMatch)match;
                node = ((MethodReferenceMatch)match2).getNode();
            }
            PossiblePosition pos = new PossiblePosition(match.getResource(), match.getOffset(), match.getLength(), node);
            SearchBasedGoalEvaluator.this.possiblePositionsGoals.add(SearchBasedGoalEvaluator.this.createVerificationGoal(pos));
        }
    };

    public SearchBasedGoalEvaluator(IGoal goal) {
        super(goal);
    }

    @Override
    public IGoal[] init() {
        IGoal goal = this.getGoal();
        IScriptProject project = null;
        IContext context = goal.getContext();
        if (context instanceof ISourceModuleContext) {
            ISourceModuleContext basicContext = (ISourceModuleContext)((Object)goal.getContext());
            project = basicContext.getSourceModule().getScriptProject();
        }
        if (project == null) {
            return null;
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope(project);
        SearchPattern pattern = this.createSearchPattern(scope.getLanguageToolkit());
        SearchEngine engine = new SearchEngine();
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, this.requestor, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return IGoal.NO_GOALS;
        }
        return this.possiblePositionsGoals.toArray(new IGoal[this.possiblePositionsGoals.size()]);
    }

    @Override
    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (result != null && result instanceof ItemReference) {
            this.references.add(result);
        }
        return IGoal.NO_GOALS;
    }

    @Override
    public Object produceResult() {
        return this.references.toArray(new ItemReference[this.references.size()]);
    }

    protected abstract SearchPattern createSearchPattern(IDLTKLanguageToolkit var1);

    protected abstract IGoal createVerificationGoal(PossiblePosition var1);
}

