/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.search;

import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementDelta;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.compiler.env.AccessRuleSet;
import org.eclipse.dltk.mod.internal.core.Model;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.search.DLTKSearchScope;

public class DLTKWorkspaceScope
extends DLTKSearchScope {
    protected boolean needsInitialize;

    public DLTKWorkspaceScope(IDLTKLanguageToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public boolean encloses(IModelElement element) {
        return true;
    }

    @Override
    public boolean encloses(String resourcePathString) {
        return true;
    }

    @Override
    public IPath[] enclosingProjectsAndZips() {
        if (this.needsInitialize) {
            this.initialize(5);
        }
        return super.enclosingProjectsAndZips();
    }

    public boolean equals(Object o) {
        return o instanceof DLTKWorkspaceScope;
    }

    @Override
    public AccessRuleSet getAccessRuleSet(String relativePath, String containerPath) {
        if (this.pathRestrictions == null) {
            return null;
        }
        return super.getAccessRuleSet(relativePath, containerPath);
    }

    public int hashCode() {
        return DLTKWorkspaceScope.class.hashCode();
    }

    @Override
    public void initialize(int size) {
        super.initialize(size);
        try {
            Model model = ModelManager.getModelManager().getModel();
            IScriptProject[] projects = this.toolkit != null ? model.getScriptProjects(this.toolkit.getNatureId()) : model.getScriptProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                int includeMask = 7;
                this.add((ScriptProject)projects[i], null, includeMask, new HashSet(length * 2, 1.0f), null);
                ++i;
            }
        }
        catch (ModelException modelException) {}
        this.needsInitialize = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processDelta(IModelElementDelta delta) {
        if (this.needsInitialize) {
            return;
        }
        IModelElement element = delta.getElement();
        block0 : switch (element.getElementType()) {
            case 1: {
                IModelElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    IModelElementDelta child = children[i];
                    this.processDelta(child);
                    ++i;
                }
                return;
            }
            case 2: {
                int kind = delta.getKind();
                switch (kind) {
                    case 1: 
                    case 2: {
                        this.needsInitialize = true;
                        return;
                    }
                    case 4: {
                        int flags = delta.getFlags();
                        if ((flags & 0x400) != 0 || (flags & 0x200) != 0) {
                            this.needsInitialize = true;
                            return;
                        }
                        IModelElementDelta[] children = delta.getAffectedChildren();
                        int i = 0;
                        int length = children.length;
                        while (i < length) {
                            IModelElementDelta child = children[i];
                            this.processDelta(child);
                            ++i;
                        }
                        return;
                    }
                }
                return;
            }
            case 3: {
                int kind = delta.getKind();
                switch (kind) {
                    case 1: 
                    case 2: {
                        this.needsInitialize = true;
                        break block0;
                    }
                    case 4: {
                        int flags = delta.getFlags();
                        if ((flags & 0x40) <= 0 && (flags & 0x80) <= 0) return;
                        this.needsInitialize = true;
                    }
                }
            }
        }
    }

    @Override
    public String toString() {
        return "DLTKWorkspaceScope";
    }
}

