/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.builder;

import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.mod.compiler.problem.IProblemReporter;
import org.eclipse.dltk.mod.compiler.task.ITaskReporter;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IBuildProblemReporterFactory;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.environment.IFileHandle;
import org.eclipse.dltk.mod.internal.core.builder.AbstractBuildContext;
import org.eclipse.dltk.mod.internal.core.builder.BuildProblemReporter;

public class SourceModuleBuildContext
extends AbstractBuildContext {
    BuildProblemReporter reporter = null;

    public SourceModuleBuildContext(ISourceModule module) {
        super(module);
        IDLTKLanguageToolkit toolkit;
        IResource resource = module.getResource();
        if (resource != null && (toolkit = DLTKLanguageManager.findToolkitForResource(resource)) != null) {
            String natureId = toolkit.getNatureId();
            IBuildProblemReporterFactory factory = DLTKLanguageManager.getBuildProblemReporterFactory(natureId);
            this.reporter = factory != null ? factory.createReporter(resource) : new BuildProblemReporter(resource);
        }
    }

    @Override
    public IFileHandle getFileHandle() {
        return null;
    }

    @Override
    public IProblemReporter getProblemReporter() {
        return this.reporter;
    }

    @Override
    public ITaskReporter getTaskReporter() {
        return this.reporter;
    }
}

