/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.util.ArrayList;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IParent;
import org.eclipse.dltk.mod.core.IRegion;

public class Region
implements IRegion {
    protected ArrayList fRootElements = new ArrayList(1);

    @Override
    public void add(IModelElement element) {
        if (!this.contains(element)) {
            this.removeAllChildren(element);
            this.fRootElements.add(element);
            this.fRootElements.trimToSize();
        }
    }

    @Override
    public boolean contains(IModelElement element) {
        int size = this.fRootElements.size();
        ArrayList parents = this.getAncestors(element);
        int i = 0;
        while (i < size) {
            IModelElement aTop = (IModelElement)this.fRootElements.get(i);
            if (aTop.equals(element)) {
                return true;
            }
            int j = 0;
            int pSize = parents.size();
            while (j < pSize) {
                if (aTop.equals(parents.get(j))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private ArrayList getAncestors(IModelElement element) {
        ArrayList<IModelElement> parents = new ArrayList<IModelElement>();
        IModelElement parent = element.getParent();
        while (parent != null) {
            parents.add(parent);
            parent = parent.getParent();
        }
        parents.trimToSize();
        return parents;
    }

    @Override
    public IModelElement[] getElements() {
        int size = this.fRootElements.size();
        IModelElement[] roots = new IModelElement[size];
        int i = 0;
        while (i < size) {
            roots[i] = (IModelElement)this.fRootElements.get(i);
            ++i;
        }
        return roots;
    }

    @Override
    public boolean remove(IModelElement element) {
        this.removeAllChildren(element);
        return this.fRootElements.remove(element);
    }

    protected void removeAllChildren(IModelElement element) {
        if (element instanceof IParent) {
            ArrayList<IModelElement> newRootElements = new ArrayList<IModelElement>();
            int i = 0;
            int size = this.fRootElements.size();
            while (i < size) {
                IModelElement currentRoot = (IModelElement)this.fRootElements.get(i);
                IModelElement parent = currentRoot.getParent();
                boolean isChild = false;
                while (parent != null) {
                    if (parent.equals(element)) {
                        isChild = true;
                        break;
                    }
                    parent = parent.getParent();
                }
                if (!isChild) {
                    newRootElements.add(currentRoot);
                }
                ++i;
            }
            this.fRootElements = newRootElements;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        IModelElement[] roots = this.getElements();
        buffer.append('[');
        int i = 0;
        while (i < roots.length) {
            buffer.append(roots[i].getElementName());
            if (i < roots.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }
}

