/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelStatus;
import org.eclipse.dltk.mod.core.IProblemRequestor;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.AccumulatingProblemReporter;
import org.eclipse.dltk.mod.internal.core.ModelElementDelta;
import org.eclipse.dltk.mod.internal.core.ModelElementDeltaBuilder;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ModelOperation;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.dltk.mod.internal.core.SourceModule;
import org.eclipse.dltk.mod.internal.core.StructureBuilder;
import org.eclipse.dltk.mod.internal.core.search.ProjectIndexerManager;
import org.eclipse.dltk.mod.internal.core.util.Messages;

public class ReconcileWorkingCopyOperation
extends ModelOperation {
    private boolean forceProblemDetection;
    private WorkingCopyOwner workingCopyOwner;
    private ModelElementDeltaBuilder deltaBuilder;

    public ReconcileWorkingCopyOperation(ISourceModule module, boolean forceProblemDetection, WorkingCopyOwner workingCopyOwner) {
        super(new IModelElement[]{module});
        this.forceProblemDetection = forceProblemDetection;
        this.workingCopyOwner = workingCopyOwner;
    }

    @Override
    protected void executeOperation() throws ModelException {
        if (this.progressMonitor != null) {
            if (this.progressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.progressMonitor.beginTask(Messages.element_reconciling, 2);
        }
        try {
            SourceModule workingCopy = this.getWorkingCopy();
            ModelManager.PerWorkingCopyInfo requestor = workingCopy.getPerWorkingCopyInfo();
            this.deltaBuilder = new ModelElementDeltaBuilder(workingCopy);
            this.makeConsistent(workingCopy, requestor);
            this.deltaBuilder.buildDeltas();
            ModelElementDelta delta = this.deltaBuilder.delta;
            if (delta != null) {
                this.addReconcileDelta(workingCopy, delta);
            }
        }
        finally {
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
        }
    }

    public void makeConsistent(SourceModule workingCopy, IProblemRequestor problemRequestor) throws ModelException {
        if (!workingCopy.isConsistent()) {
            workingCopy.makeConsistent(this.progressMonitor);
            ProjectIndexerManager.reconciled(workingCopy);
        } else if (this.forceProblemDetection && problemRequestor.isActive()) {
            AccumulatingProblemReporter reporter = new AccumulatingProblemReporter(problemRequestor);
            IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(workingCopy);
            if (toolkit != null) {
                StructureBuilder.build(toolkit.getNatureId(), workingCopy, reporter);
            }
            reporter.reportToRequestor();
        }
    }

    protected SourceModule getWorkingCopy() {
        return (SourceModule)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected IModelStatus verify() {
        IModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        SourceModule workingCopy = this.getWorkingCopy();
        if (!workingCopy.isWorkingCopy()) {
            return new ModelStatus(969, workingCopy);
        }
        return status;
    }
}

