/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ModelStatus;

public class ArchiveEntryFile
extends PlatformObject
implements IStorage {
    private String entryName;
    private String zipName;
    private IPath path;
    private IResource zipResource;

    public ArchiveEntryFile(String entryName, String zipName, IPath parentRelativePath, IResource zipResource) {
        this.entryName = entryName;
        this.zipName = zipName;
        this.path = parentRelativePath;
        this.zipResource = zipResource;
    }

    public ZipFile getZipFile() throws CoreException, IOException {
        ZipFile zipFile = this.zipResource == null ? ModelManager.getModelManager().getZipFile((IPath)new Path(this.zipName)) : new ZipFile(this.zipResource.getLocation().toOSString());
        return zipFile;
    }

    public InputStream getContents() throws CoreException {
        ByteArrayInputStream byteArrayInputStream;
        if (ModelManager.ZIP_ACCESS_VERBOSE) {
            System.out.println("(" + Thread.currentThread() + ") [JarEntryFile.getContents()] Creating ZipFile on " + this.zipName);
        }
        ZipFile zipFile = null;
        try {
            int len;
            zipFile = this.getZipFile();
            ZipEntry zipEntry = zipFile.getEntry(this.path.append(this.entryName).toString());
            if (zipEntry == null) {
                throw new ModelException(new ModelStatus(979, this.entryName));
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            byte[] buf = new byte[1024];
            ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
            while ((len = inputStream.read(buf)) > 0) {
                arrayOut.write(buf, 0, len);
            }
            byteArrayInputStream = new ByteArrayInputStream(arrayOut.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ModelException(e, 985);
            }
        }
        zipFile.close();
        return byteArrayInputStream;
    }

    public IPath getFullPath() {
        return new Path(this.entryName);
    }

    public String getName() {
        return new Path(this.entryName).lastSegment();
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        return "JarEntryFile[" + this.zipName + "::" + this.entryName + "]";
    }
}

